/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.prettytable;

import java.util.ArrayList;
import java.util.List;
import org.appng.cli.prettytable.PrettyTable;
import org.appng.cli.prettytable.TableColumn;

public class TableRow {
    private final List<String> values = new ArrayList<String>();

    TableRow(List<TableColumn> columns, Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            String value = String.valueOf(values[i]);
            this.values.add(value);
            columns.get(i).setCellWidth(value.length());
        }
    }

    public StringBuilder render(List<TableColumn> columns, boolean withBorders, boolean beVerbose) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.values.size(); ++i) {
            TableColumn tableColumn = columns.get(i);
            boolean isVerbose = tableColumn.isVerbose();
            if (isVerbose && !beVerbose) continue;
            if (withBorders) {
                builder.append(PrettyTable.bordered(this.values.get(i), tableColumn.getCellWidth()));
                continue;
            }
            builder.append(PrettyTable.tabbed(this.values.get(i)));
            if (i != columns.size() - 1) continue;
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder;
    }

    public String getValueAt(int index) {
        return this.values.get(index);
    }
}

