/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.application;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.Collection;
import org.appng.api.BusinessException;
import org.appng.api.model.Application;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.cli.NoSuchSiteException;
import org.appng.cli.commands.CommandList;
import org.appng.core.domain.SiteImpl;

@Parameters(commandDescription="Lists the available applications/the applications installed for a site.")
public class ListApplications
extends CommandList
implements ExecutableCliCommand {
    @Parameter(names={"-s"}, description="The site name to list the installed applications for.")
    private String siteName;

    public ListApplications() {
    }

    ListApplications(String siteName) {
        this.siteName = siteName;
    }

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        Collection applications;
        if (null == this.siteName) {
            applications = cle.getCoreService().getApplications();
        } else {
            SiteImpl siteByName = cle.getCoreService().getSiteByName(this.siteName);
            if (null == siteByName) {
                throw new NoSuchSiteException(this.siteName);
            }
            applications = siteByName.getApplications();
        }
        if (null != applications) {
            this.prettyTable.addColumn("ID");
            this.prettyTable.addColumn("Name");
            this.prettyTable.addColumn("Display name");
            this.prettyTable.addColumn("Core application");
            this.prettyTable.addColumn("Filebased", true);
            this.prettyTable.addColumn("Hidden", true);
            for (Application application : applications) {
                this.prettyTable.addRow(application.getId(), application.getName(), application.getDisplayName(), application.isCoreApplication(), application.isFileBased(), application.isHidden());
            }
            cle.setResult(this.renderTable());
        }
    }
}

