/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.application;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import org.appng.api.BusinessException;
import org.appng.api.model.Properties;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.cli.NoSuchRepositoryException;
import org.appng.cli.commands.FileOwner;
import org.appng.core.model.AccessibleApplication;
import org.appng.core.model.Repository;
import org.appng.core.model.RepositoryCacheFactory;
import org.appng.core.service.CoreService;
import org.appng.xml.application.PackageInfo;

@Parameters(commandDescription="Imports a application.")
public class InstallApplication
implements ExecutableCliCommand {
    @Parameter(names={"-n"}, required=true, description="The name of the application.")
    private String applicationName;
    @Parameter(names={"-v"}, required=true, description="The version of the application.")
    private String applicationVersion;
    @Parameter(names={"-t"}, required=false, description="The timestamp of the application. Required if a specific snapshot version should be provisioned.")
    private String applicationTimestamp;
    @Parameter(names={"-r"}, required=true, description="The name of the repository.")
    private String repositoryName;
    @Parameter(names={"-c"}, required=false, description="Install as core application.")
    private boolean isCoreApplication = false;
    @Parameter(names={"-h"}, required=false, description="Application will be hidden.")
    private boolean isHidden = false;
    @Parameter(names={"-f"}, required=false, description="Application will be filebased.")
    private boolean isFileBased = false;

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        PackageInfo installedPackage;
        CoreService coreService;
        AccessibleApplication application;
        Repository repository = cle.getCoreService().getApplicationRepositoryByName(this.repositoryName);
        if (null == repository) {
            throw new NoSuchRepositoryException(this.repositoryName);
        }
        if (null == RepositoryCacheFactory.instance()) {
            RepositoryCacheFactory.init((Properties)cle.getPlatformConfig());
        }
        if (null != (application = (coreService = cle.getCoreService()).findApplicationByName((installedPackage = coreService.installPackage((Integer)repository.getId(), this.applicationName, this.applicationVersion, this.applicationTimestamp, this.isCoreApplication, this.isHidden, this.isFileBased)).getName()))) {
            String group;
            String user;
            File applicationFolder;
            if (this.isFileBased && !application.isFileBased()) {
                cle.setResult("application was already present and located in the database, so -f was ignored.");
            }
            if (application.isFileBased() && !new FileOwner(applicationFolder = coreService.getApplicationFolder(null, application.getName())).own(user = cle.getCliConfig().getProperty("appng.user"), group = cle.getCliConfig().getProperty("appng.group"))) {
                cle.setResult("failed to set directory permissions for " + applicationFolder.getAbsolutePath());
            }
        }
    }
}

