/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli.commands.application;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import org.appng.api.BusinessException;
import org.appng.api.FieldProcessor;
import org.appng.api.support.FieldProcessorImpl;
import org.appng.cli.CliEnvironment;
import org.appng.cli.ExecutableCliCommand;
import org.appng.xml.platform.Message;
import org.appng.xml.platform.MessageType;

@Parameters(commandDescription="Deletes a application.")
public class DeleteApplication
implements ExecutableCliCommand {
    private static final String NL = "\n";
    @Parameter(names={"-a"}, required=true, description="The application name.")
    private String applicationName;

    @Override
    public void execute(CliEnvironment cle) throws BusinessException {
        FieldProcessorImpl fp = new FieldProcessorImpl(null);
        try {
            cle.getCoreService().deleteApplication(this.applicationName, (FieldProcessor)fp);
        }
        catch (BusinessException e) {
            throw new BusinessException((Throwable)e);
        }
        finally {
            StringBuilder result = new StringBuilder();
            List messages = fp.getMessages().getMessageList();
            for (Message message : messages) {
                MessageType clazz = message.getClazz();
                String content = message.getContent();
                String str = clazz.name() + ": " + content + NL;
                result = result.append(str);
            }
            cle.setResult(result.toString());
        }
    }
}

