/*
 * Decompiled with CFR 0.152.
 */
package org.appng.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.ParameterException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.appng.cli.CliCommands;
import org.appng.cli.CliEnvironment;
import org.appng.cli.commands.CommandBatch;
import org.appng.cli.commands.CommandMain;
import org.appng.cli.commands.application.ActivateApplication;
import org.appng.cli.commands.application.DeactivateApplication;
import org.appng.cli.commands.application.DeleteApplication;
import org.appng.cli.commands.application.InstallApplication;
import org.appng.cli.commands.application.ListApplications;
import org.appng.cli.commands.applicationrole.AddRole;
import org.appng.cli.commands.applicationrole.ListRoles;
import org.appng.cli.commands.group.AddGroup;
import org.appng.cli.commands.group.CreateGroup;
import org.appng.cli.commands.group.DeleteGroup;
import org.appng.cli.commands.group.ListGroups;
import org.appng.cli.commands.heartbeat.HeartBeat;
import org.appng.cli.commands.permission.AddPermission;
import org.appng.cli.commands.permission.ListPermissions;
import org.appng.cli.commands.permission.RemovePermission;
import org.appng.cli.commands.property.CreateProperty;
import org.appng.cli.commands.property.DeleteProperty;
import org.appng.cli.commands.property.ListProperties;
import org.appng.cli.commands.property.UpdateProperty;
import org.appng.cli.commands.repository.CreateRepository;
import org.appng.cli.commands.repository.DeleteRepository;
import org.appng.cli.commands.repository.ListRepositories;
import org.appng.cli.commands.site.CheckSiteRunning;
import org.appng.cli.commands.site.CreateSite;
import org.appng.cli.commands.site.DeleteSite;
import org.appng.cli.commands.site.ListSites;
import org.appng.cli.commands.site.SetSiteActive;
import org.appng.cli.commands.subject.CreateSubject;
import org.appng.cli.commands.subject.DeleteSubject;
import org.appng.cli.commands.subject.ListSubjects;
import org.appng.cli.commands.template.DeleteTemplate;
import org.appng.cli.commands.template.InstallTemplate;
import org.appng.core.service.DatabaseService;
import org.flywaydb.core.api.MigrationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class CliCore {
    private static Logger log = LoggerFactory.getLogger(CliCore.class);
    private static final String PROGRAM_NAME = "appng";
    private static final String COMMAND_BATCH = "batch";
    private ApplicationContext platformContext;
    public static final int STATUS_OK = 0;
    public static final int DATABASE_ERROR = 9;
    public static final int COMMAND_EXECUTION_ERROR = 10;
    public static final int COMMAND_INVALID = 11;
    public static final int OPTION_INVALID = 12;
    public static final int OPTION_MISSING = 13;
    private int status = 0;
    private JCommander jc;
    private CommandMain cm;
    protected CliCommands commands;

    void addCommands() {
        this.commands.add("list-groups", new ListGroups());
        this.commands.add("create-group", new CreateGroup());
        this.commands.add("add-group", new AddGroup());
        this.commands.add("delete-group", new DeleteGroup());
        this.commands.add("list-applications", new ListApplications());
        this.commands.add("install-application", new InstallApplication());
        this.commands.add("activate-application", new ActivateApplication());
        this.commands.add("deactivate-application", new DeactivateApplication());
        this.commands.add("delete-application", new DeleteApplication());
        this.commands.add("list-roles", new ListRoles());
        this.commands.add("add-role", new AddRole());
        this.commands.add("add-permission", new AddPermission());
        this.commands.add("remove-permission", new RemovePermission());
        this.commands.add("list-permissions", new ListPermissions());
        this.commands.add("list-properties", new ListProperties());
        this.commands.add("create-property", new CreateProperty());
        this.commands.add("update-property", new UpdateProperty());
        this.commands.add("delete-property", new DeleteProperty());
        this.commands.add("list-repositories", new ListRepositories());
        this.commands.add("create-repository", new CreateRepository());
        this.commands.add("delete-repository", new DeleteRepository());
        this.commands.add("list-sites", new ListSites());
        this.commands.add("create-site", new CreateSite());
        this.commands.add("delete-site", new DeleteSite());
        this.commands.add("check-site", new CheckSiteRunning());
        this.commands.add("site-setactive", new SetSiteActive());
        this.commands.add("list-subjects", new ListSubjects());
        this.commands.add("create-subject", new CreateSubject());
        this.commands.add("delete-subject", new DeleteSubject());
        this.commands.add("install-template", new InstallTemplate());
        this.commands.add("delete-template", new DeleteTemplate());
        this.commands.add("heartbeat", new HeartBeat());
        this.commands.add(COMMAND_BATCH, new CommandBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int perform(Properties cliConfig) {
        Map<String, String> hibernateParams = this.cm.getHibernateParams();
        if (null != hibernateParams) {
            cliConfig.putAll(hibernateParams);
        }
        CliEnvironment cle = new CliEnvironment(this.platformContext, cliConfig);
        DatabaseService databaseService = (DatabaseService)this.platformContext.getBean(DatabaseService.class);
        String parsedCommand = this.jc.getParsedCommand();
        if (!COMMAND_BATCH.equals(parsedCommand)) {
            MigrationInfo migrationInfo;
            if (this.cm.isInitDatabase()) {
                migrationInfo = this.cm.doInitDatabase(databaseService, cliConfig);
                if (null == migrationInfo) {
                    this.logError("Database could not be initialized, see logs for details.");
                }
            } else {
                migrationInfo = databaseService.status(cliConfig);
                if (null == migrationInfo) {
                    this.logError("Database is not initialized. Use option -i|-initdatabase to initialize database.");
                }
            }
            if (null == migrationInfo || migrationInfo.getState().isFailed()) {
                this.logError("Database is in an erroneous state, see logs for details.");
                return 9;
            }
            String stateName = migrationInfo.getState().name();
            Date installedOn = migrationInfo.getInstalledOn();
            String logMessage = "Database is at version " + migrationInfo.getVersion() + ", state: " + stateName + ", installed on " + installedOn;
            log.info(logMessage);
            cle.initPlatform(cliConfig);
        }
        if (null != parsedCommand || this.cm.isSchemaExport()) {
            try {
                this.commands.getCommand(parsedCommand).execute(cle);
            }
            catch (Exception e) {
                log.error("An error occured.", (Throwable)e);
                String message = e.getMessage();
                if (null != message) {
                    this.logError(message);
                } else {
                    this.logError("Unknown error. Consult the log file for more details.");
                }
                this.status = 10;
            }
            finally {
                this.print(cle.getResult());
            }
        }
        return this.status;
    }

    public void setContext(ApplicationContext platformContext) {
        this.platformContext = platformContext;
    }

    void usage(JCommander jc) {
        if (null == jc) {
            jc = this.createJCommanderInstance(null);
        }
        StringBuilder out = new StringBuilder();
        jc.usage(out);
        this.print(out.toString());
    }

    private JCommander createJCommanderInstance(Object o) {
        JCommander jc = null == o ? new JCommander() : new JCommander(o);
        jc.setProgramName(PROGRAM_NAME);
        return jc;
    }

    private void print(String string) {
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            CliEnvironment.out.println(string);
        }
    }

    public boolean processCommand(String[] args) throws ParameterException {
        this.status = 0;
        this.cm = new CommandMain();
        this.jc = this.createJCommanderInstance(this.cm);
        this.commands = new CliCommands(this.jc);
        this.addCommands();
        if (null == args || args.length == 0) {
            this.usage(this.jc);
            this.print("appng -h for help.");
            return false;
        }
        try {
            this.jc.parse(args);
            if (this.cm.isUsage()) {
                this.usage(this.jc);
                return false;
            }
            return true;
        }
        catch (ParameterException ex) {
            String message = ex.getMessage();
            Object[] splittedArgs = args[0].split(" ");
            String commandName = splittedArgs[0];
            JCommander failedJc = (JCommander)this.jc.getCommands().get(commandName);
            if (failedJc != null) {
                if (ex instanceof MissingCommandException) {
                    Object[] unknownArgs = (String[])ArrayUtils.subarray((Object[])splittedArgs, (int)1, (int)splittedArgs.length);
                    this.logError("Invalid options: " + StringUtils.join((Object[])unknownArgs, (String)" "));
                    this.status = 12;
                } else {
                    this.logError(message);
                    this.status = 13;
                }
                failedJc.setProgramName("appng " + commandName);
                this.usage(failedJc);
            } else {
                this.logError("Invalid command: " + commandName);
                this.usage(this.jc);
                this.status = 11;
            }
            return false;
        }
    }

    public int getStatus() {
        return this.status;
    }

    void logError(String message) {
        CliEnvironment.out.println(LogCategory.ERROR.name() + ": " + message);
    }

    private static enum LogCategory {
        INFO,
        WARN,
        ERROR;

    }
}

