/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.authentication.webform;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.BusinessException;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.auth.PasswordPolicy;
import org.appng.api.model.Application;
import org.appng.api.model.AuthSubject;
import org.appng.api.model.Properties;
import org.appng.api.model.Site;
import org.appng.api.model.UserType;
import org.appng.application.authentication.AbstractLogon;
import org.appng.application.authentication.webform.LoginData;
import org.appng.core.domain.SubjectImpl;
import org.appng.core.security.BCryptPasswordHandler;
import org.appng.core.security.Sha1PasswordHandler;
import org.appng.core.service.CoreService;
import org.appng.mail.Mail;
import org.appng.mail.MailException;
import org.appng.mail.MailTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordReset
extends AbstractLogon {
    protected static final String MSSG_USER_UNKNOWN = "user.unknown";
    private static final Logger logger = LoggerFactory.getLogger(PasswordReset.class);
    private static final String UTF_8 = "UTF-8";
    private static final String PROP_MAIL_FROM = "mailFrom";
    private static final String MSSG_SEND_ERROR = "send.error";
    private static final String MSSG_MAIL_SUBJECT_FORGOT_PASSWORD = "mailSubjectForgotPassword";
    private static final String MSSG_MAIL_SUBJECT_NEW_PASSWORD = "mailSubjectNewPassword";
    private static final String MSSG_RESET_PASSWORD = "mail.content.resetPassword";
    private static final String MSSG_FORGOT_PASSWORD = "mail.content.forgotPassword";
    private static final String MSGG_NO_LOCAL_USER = "user.notLocal";

    public void perform(Site site, Application application, Environment environment, Options options, Request request, LoginData loginData, FieldProcessor fp) {
        CoreService service = (CoreService)application.getBean(CoreService.class);
        SubjectImpl subject = service.getSubjectByName(loginData.getUsername(), false);
        if (null == subject) {
            fp.addErrorMessage(request.getMessage(MSSG_USER_UNKNOWN, new Object[0]));
        } else if (!UserType.LOCAL_USER.equals((Object)subject.getUserType())) {
            fp.addErrorMessage(request.getMessage(MSGG_NO_LOCAL_USER, new Object[]{loginData.getUsername()}));
        } else {
            String email = subject.getEmail();
            PasswordPolicy passwordPolicy = site.getPasswordPolicy();
            boolean reset = this.doReset(site, application, environment, request, fp, service, (AuthSubject)subject, passwordPolicy, subject.getName(), email);
            if (reset) {
                service.updateSubject(subject);
            }
        }
    }

    protected boolean doReset(Site site, Application application, Environment environment, Request request, FieldProcessor fp, CoreService service, AuthSubject subject, PasswordPolicy passwordPolicy, String username, String email) {
        boolean result = false;
        String action = request.getParameter("action");
        String formAction = request.getParameter("form_action");
        Properties properties = application.getProperties();
        Locale locale = new Locale(subject.getLanguage());
        MailTransport mailTransport = (MailTransport)application.getBean(MailTransport.class);
        String from = properties.getString(PROP_MAIL_FROM);
        String errorMessage = null;
        String managerPath = site.getProperties().getString("manager-path");
        try {
            if ("resetPassword".equals(action)) {
                errorMessage = application.getMessage(locale, "password.error", new Object[0]);
                if (StringUtils.isBlank((CharSequence)subject.getSalt())) {
                    fp.addErrorMessage(errorMessage);
                    return false;
                }
                String hash = request.getParameter("hash");
                byte[] newPassword = service.resetPassword(subject, passwordPolicy, email, hash);
                String mailSubject = application.getMessage(locale, MSSG_MAIL_SUBJECT_NEW_PASSWORD, new Object[0]);
                if (null != newPassword) {
                    String content = this.getMessageResetPassword(application, subject, locale, site.getDomain() + managerPath, newPassword);
                    this.sendMail(mailTransport, email, from, mailSubject, content);
                    String message = application.getMessage(locale, "password.sendTo", new Object[]{username});
                    fp.addOkMessage(message);
                    return true;
                }
                fp.addErrorMessage(errorMessage);
            } else if ("forgotPassword".equals(action) || "forgotPassword".equals(formAction)) {
                String hash;
                errorMessage = application.getMessage(locale, MSSG_USER_UNKNOWN, new Object[]{username});
                String mailSubject = application.getMessage(locale, MSSG_MAIL_SUBJECT_FORGOT_PASSWORD, new Object[0]);
                if (subject instanceof SubjectImpl) {
                    hash = service.forgotPassword(subject);
                } else {
                    Object h = !subject.getDigest().startsWith(BCryptPasswordHandler.getPrefix()) ? new Sha1PasswordHandler(subject) : new BCryptPasswordHandler(subject);
                    hash = h.getPasswordResetDigest();
                    subject.setDigest(hash);
                    result = true;
                }
                StringBuilder path = new StringBuilder(site.getDomain());
                path.append(managerPath);
                path.append("?action=resetPassword");
                path.append("&username=" + username);
                path.append("&hash=");
                path.append(URLEncoder.encode(hash, UTF_8));
                String content = this.getMessageForgotPassword(application, subject, locale, path.toString());
                this.sendMail(mailTransport, email, from, mailSubject, content);
                String message = application.getMessage(locale, "link.sendTo", new Object[]{username});
                fp.addOkMessage(message);
            }
        }
        catch (MailException m) {
            logger.error("error while sending mail", (Throwable)m);
            errorMessage = application.getMessage(locale, MSSG_SEND_ERROR, new Object[0]);
            fp.addErrorMessage(errorMessage);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("error during action " + action, (Throwable)e);
            fp.addErrorMessage(errorMessage);
        }
        catch (BusinessException e) {
            logger.error("error during action " + action, (Throwable)e);
            fp.addErrorMessage(errorMessage);
        }
        return result;
    }

    protected String getMessageForgotPassword(Application application, AuthSubject authSubject, Locale locale, String url) {
        return application.getMessage(locale, MSSG_FORGOT_PASSWORD, new Object[]{authSubject.getAuthName(), url});
    }

    protected String getMessageResetPassword(Application application, AuthSubject authSubject, Locale locale, String url, byte[] newPassword) {
        return application.getMessage(locale, MSSG_RESET_PASSWORD, new Object[]{authSubject.getAuthName(), url, new String(newPassword)});
    }

    private void sendMail(MailTransport mailTransport, String email, String from, String mailSubject, String content) throws MailException {
        Mail mail = mailTransport.createMail();
        mail.setFrom(from);
        mail.setSubject(mailSubject);
        mail.addReceiver(email, Mail.RecipientType.TO);
        mail.setTextContent(content);
        mailTransport.send(mail);
    }
}

