/*
 * Decompiled with CFR 0.152.
 */
package org.appng.application.authentication.digest;

import org.apache.commons.lang3.StringUtils;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.api.support.environment.DefaultEnvironment;
import org.appng.application.authentication.AbstractLogon;
import org.appng.application.authentication.webform.LoginData;
import org.appng.core.security.DigestValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class DigestLogin
extends AbstractLogon {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigestLogin.class);
    private static final String PROP_DIGEST_LOGIN_REDIRECT_WITH_SERVLET_PATH = "digestLoginRedirectWithServletPath";
    private static final String PROP_DIGEST_MAX_VALIDITY = "digestMaxValidity";

    public void perform(Site site, Application application, Environment environment, Options options, Request request, LoginData loginData, FieldProcessor fp) {
        String digest = request.getParameter("digest");
        if (StringUtils.isNotBlank((CharSequence)digest)) {
            Integer digestMaxValidity = application.getProperties().getInteger(PROP_DIGEST_MAX_VALIDITY);
            DigestValidator validator = new DigestValidator(digest, digestMaxValidity.intValue());
            String username = validator.getUsername();
            LOGGER.debug("received login digest for user {}", (Object)username);
            boolean success = false;
            if (environment.isSubjectAuthenticated()) {
                String currentUser = environment.getSubject().getAuthName();
                if (StringUtils.isNotBlank((CharSequence)username) && !currentUser.equals(username)) {
                    LOGGER.debug("a different user ({}) is logged in, performing log-out first.", (Object)currentUser);
                    this.getCoreService(application).logoutSubject(environment);
                }
            }
            if (!environment.isSubjectAuthenticated()) {
                success = this.getCoreService(application).login(environment, digest, digestMaxValidity.intValue());
                LOGGER.debug("digest login for user {} " + (success ? "succeeded" : "failed") + ".", (Object)username);
            } else {
                LOGGER.debug("user {} is already logged in", (Object)environment.getSubject().getAuthName());
            }
            String target = request.getParameter("forward");
            String managerPath = site.getProperties().getString("manager-path");
            if (StringUtils.isNotBlank((CharSequence)target)) {
                target = target.substring(managerPath.length());
            } else if (application.getProperties().getBoolean(PROP_DIGEST_LOGIN_REDIRECT_WITH_SERVLET_PATH).booleanValue()) {
                target = ((DefaultEnvironment)environment).getServletRequest().getServletPath();
                target = target.substring(managerPath.length());
            } else {
                target = application.getProperties().getString("successPage");
            }
            this.processLogonResult(site, application, environment, options, fp, success, target, HttpStatus.FOUND, true);
        }
    }

    @Override
    protected Logger log() {
        return LOGGER;
    }
}

