/*
 * Decompiled with CFR 0.152.
 */
package org.appng.appngizer.model;

import java.net.URI;
import java.net.URISyntaxException;
import org.appng.appngizer.model.Link;
import org.appng.appngizer.model.UriAware;
import org.appng.appngizer.model.xml.Links;
import org.appng.appngizer.model.xml.Package;
import org.appng.appngizer.model.xml.RepositoryMode;
import org.appng.appngizer.model.xml.RepositoryType;
import org.appng.core.domain.RepositoryImpl;
import org.springframework.web.util.UriComponentsBuilder;

public class Repository
extends org.appng.appngizer.model.xml.Repository
implements UriAware {
    public static Repository fromDomain(org.appng.core.model.Repository r) {
        Repository repo = new Repository();
        repo.setName(r.getName());
        repo.setEnabled(r.isActive());
        repo.setPublished(r.isPublished());
        repo.setStrict(r.isStrict());
        repo.setDescription(r.getDescription());
        repo.setRemoteName(r.getRemoteRepositoryName());
        repo.setMode(RepositoryMode.valueOf((String)r.getRepositoryMode().name()));
        repo.setType(RepositoryType.valueOf((String)r.getRepositoryType().name()));
        repo.setUri(r.getUri().toString());
        repo.setSelf("/repository/{name}");
        repo.setLinks(new Links());
        repo.getLinks().getLink().add(new Link("install", "/install"));
        if (org.appng.core.model.RepositoryType.LOCAL.equals((Object)r.getRepositoryType())) {
            repo.getLinks().getLink().add(new Link("upload", "/upload"));
        }
        return repo;
    }

    public static RepositoryImpl toDomain(org.appng.appngizer.model.xml.Repository repo) throws URISyntaxException {
        RepositoryImpl r = new RepositoryImpl();
        r.setName(repo.getName());
        r.setActive(repo.isEnabled());
        r.setPublished(repo.isPublished());
        r.setStrict(repo.isStrict());
        r.setDescription(repo.getDescription());
        r.setRemoteRepositoryName(repo.getRemoteName());
        r.setRepositoryMode(org.appng.core.model.RepositoryMode.valueOf((String)repo.getMode().name()));
        r.setRepositoryType(org.appng.core.model.RepositoryType.valueOf((String)repo.getType().name()));
        r.setUri(new URI(repo.getUri()));
        return r;
    }

    public void applyUriComponents(UriComponentsBuilder builder) {
        String uriString = builder.path("/repository/{name}").buildAndExpand(new Object[]{this.encode(this.name)}).toUriString();
        if (null != this.packages) {
            for (Package p : this.packages.getPackage()) {
                ((UriAware)p).setSelf(uriString + "/" + this.encode(p.getName()));
            }
        }
        if (null != this.getLinks()) {
            for (org.appng.appngizer.model.xml.Link link : this.getLinks().getLink()) {
                link.setSelf(uriString + link.getSelf());
            }
        }
        this.setSelf(uriString);
    }
}

