/*
 * Decompiled with CFR 0.152.
 */
package org.appng.appngizer.controller;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.BusinessException;
import org.appng.api.model.AuthSubject;
import org.appng.api.model.Group;
import org.appng.api.model.UserType;
import org.appng.appngizer.controller.ControllerBase;
import org.appng.appngizer.model.Groups;
import org.appng.appngizer.model.Subject;
import org.appng.appngizer.model.Subjects;
import org.appng.core.domain.SubjectImpl;
import org.appng.core.security.BCryptPasswordHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SubjectController
extends ControllerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubjectController.class);

    @GetMapping(value={"/subject"})
    public ResponseEntity<Subjects> listSubjects() {
        ArrayList<Subject> subjects = new ArrayList<Subject>();
        for (org.appng.api.model.Subject g : this.getCoreService().getSubjects()) {
            subjects.add(Subject.fromDomain((org.appng.api.model.Subject)g, (boolean)false));
        }
        Subjects entity = new Subjects(subjects);
        entity.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)entity);
    }

    @GetMapping(value={"/subject/{name}"})
    public ResponseEntity<Subject> getSubject(@PathVariable(value="name") String name) {
        SubjectImpl subject = this.getCoreService().getSubjectByName(name, true);
        if (null == subject) {
            return this.notFound();
        }
        Subject fromDomain = this.addGroups(subject);
        fromDomain.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)fromDomain);
    }

    public Subject addGroups(SubjectImpl subject) {
        Subject fromDomain = Subject.fromDomain((org.appng.api.model.Subject)subject, (boolean)true);
        Groups groups = new Groups();
        fromDomain.setGroups((org.appng.appngizer.model.xml.Groups)groups);
        List subjectGroups = subject.getGroups();
        for (Group group : subjectGroups) {
            org.appng.appngizer.model.Group g = org.appng.appngizer.model.Group.fromDomain((Group)group);
            g.applyUriComponents(this.getUriBuilder());
            fromDomain.getGroups().getGroup().add(g);
        }
        return fromDomain;
    }

    @PostMapping(value={"/subject"})
    public ResponseEntity<Subject> createSubject(@RequestBody org.appng.appngizer.model.xml.Subject subject) throws BusinessException {
        SubjectImpl currentSubject = this.getCoreService().getSubjectByName(subject.getName(), false);
        if (null != currentSubject) {
            return this.conflict();
        }
        SubjectImpl newSubject = Subject.toDomain((org.appng.appngizer.model.xml.Subject)subject);
        this.setDigest(subject.getDigest(), newSubject);
        this.getCoreService().createSubject(newSubject);
        this.assignGroups(subject.getName(), subject);
        return this.created(this.getSubject(subject.getName()).getBody());
    }

    @PutMapping(value={"/subject/{name}"})
    public ResponseEntity<Subject> updateSubject(@PathVariable(value="name") String name, @RequestBody org.appng.appngizer.model.xml.Subject subject) throws BusinessException {
        SubjectImpl subjectByName = this.getCoreService().getSubjectByName(name, true);
        if (null == subjectByName) {
            return this.notFound();
        }
        subjectByName.setRealname(subject.getRealName());
        subjectByName.setEmail(subject.getEmail());
        subjectByName.setDescription(subject.getDescription());
        subjectByName.setTimeZone(subject.getTimeZone());
        subjectByName.setLanguage(subject.getLanguage());
        subjectByName.setUserType(UserType.valueOf((String)subject.getType().name()));
        this.setDigest(subject.getDigest(), subjectByName);
        this.getCoreService().updateSubject(subjectByName);
        this.assignGroups(name, subject);
        SubjectImpl updatedSubject = this.getCoreService().getSubjectByName(name, true);
        Subject fromDomain = this.addGroups(updatedSubject);
        fromDomain.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)fromDomain);
    }

    void setDigest(String digest, SubjectImpl domainSubject) {
        if (StringUtils.isNotBlank((CharSequence)digest)) {
            if (digest.startsWith(BCryptPasswordHandler.getPrefix())) {
                domainSubject.setDigest(digest);
            } else {
                new BCryptPasswordHandler((AuthSubject)domainSubject).savePassword(digest);
            }
        }
    }

    public void assignGroups(String name, org.appng.appngizer.model.xml.Subject subject) throws BusinessException {
        ArrayList<String> groupNames = new ArrayList<String>();
        if (null != subject.getGroups() && null != subject.getGroups().getGroup()) {
            for (org.appng.appngizer.model.xml.Group group : subject.getGroups().getGroup()) {
                groupNames.add(group.getName());
            }
        }
        this.getCoreService().addGroupsToSubject(name, groupNames, true);
    }

    @DeleteMapping(value={"/subject/{name}"})
    public ResponseEntity<Void> deleteSubject(@PathVariable(value="name") String name) {
        SubjectImpl currentSubject = this.getCoreService().getSubjectByName(name, false);
        if (null == currentSubject) {
            return this.notFound();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.getUriBuilder().path("/subject").build().toUri());
        this.getCoreService().deleteSubject((org.appng.api.model.Subject)currentSubject);
        return this.noContent(headers);
    }

    Logger logger() {
        return LOGGER;
    }
}

