/*
 * Decompiled with CFR 0.152.
 */
package org.appng.appngizer.controller;

import java.util.ArrayList;
import org.appng.api.BusinessException;
import org.appng.api.model.Application;
import org.appng.api.model.Permission;
import org.appng.appngizer.controller.ControllerBase;
import org.appng.appngizer.model.Role;
import org.appng.appngizer.model.Roles;
import org.appng.appngizer.model.xml.Permissions;
import org.appng.core.domain.ApplicationImpl;
import org.appng.core.domain.PermissionImpl;
import org.appng.core.domain.RoleImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RoleController
extends ControllerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoleController.class);

    @GetMapping(value={"/application/{app}/role"})
    public ResponseEntity<Roles> listRoles(@PathVariable(value="app") String app) {
        ApplicationImpl appByName = this.getApplicationByName(app);
        if (null == appByName) {
            return this.notFound();
        }
        ArrayList<Role> roleList = new ArrayList<Role>();
        for (RoleImpl r : this.getCoreService().getApplicationRolesForApplication((Integer)appByName.getId())) {
            roleList.add(Role.fromDomain((org.appng.api.model.Role)r));
        }
        Roles roles = new Roles(roleList, app);
        roles.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)roles);
    }

    @GetMapping(value={"/application/{app}/role/{name}"})
    public ResponseEntity<Role> getRole(@PathVariable(value="app") String app, @PathVariable(value="name") String name) {
        RoleImpl role = this.getApplicationRole(app, name);
        if (null == role) {
            return this.notFound();
        }
        Role fromDomain = Role.fromDomain((org.appng.api.model.Role)role);
        fromDomain.setPermissions(new Permissions());
        for (Permission p : role.getPermissions()) {
            fromDomain.getPermissions().getPermission().add(org.appng.appngizer.model.Permission.fromDomain((Permission)p));
        }
        fromDomain.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)fromDomain);
    }

    @PostMapping(value={"/application/{app}/role"})
    public ResponseEntity<Role> createRole(@PathVariable(value="app") String app, @RequestBody org.appng.appngizer.model.xml.Role role) {
        RoleImpl existing = this.getApplicationRole(app, role.getName());
        if (null != existing) {
            return this.conflict();
        }
        RoleImpl roleImpl = Role.toDomain((org.appng.appngizer.model.xml.Role)role);
        ApplicationImpl applicationByName = this.getApplicationByName(app);
        roleImpl.setApplication((Application)applicationByName);
        this.addPermissionsAndSave(app, role, roleImpl);
        return this.created(this.getRole(app, role.getName()).getBody());
    }

    @PutMapping(value={"/application/{app}/role/{name}"})
    public ResponseEntity<Role> updateRole(@PathVariable(value="app") String app, @PathVariable(value="name") String name, @RequestBody org.appng.appngizer.model.xml.Role role) {
        RoleImpl appRole = this.getApplicationRole(app, name);
        if (null == appRole) {
            return this.notFound();
        }
        this.addPermissionsAndSave(app, role, appRole);
        return this.ok(this.getRole(app, name).getBody());
    }

    protected void addPermissionsAndSave(String app, org.appng.appngizer.model.xml.Role role, RoleImpl appRole) {
        if (null != role.getPermissions()) {
            appRole.setDescription(role.getDescription());
            appRole.getPermissions().clear();
            for (org.appng.appngizer.model.xml.Permission permission : role.getPermissions().getPermission()) {
                PermissionImpl p = this.getCoreService().getPermission(app, permission.getName());
                if (null != p) {
                    appRole.getPermissions().add(p);
                    continue;
                }
                LOGGER.info("no such permission: {}", (Object)permission.getName());
            }
        }
        this.getCoreService().saveRole(appRole);
    }

    @DeleteMapping(value={"/application/{app}/role/{name}"})
    public ResponseEntity<Void> deleteRole(@PathVariable(value="app") String app, @PathVariable(value="name") String name) throws BusinessException {
        RoleImpl appRole = this.getApplicationRole(app, name);
        if (null == appRole) {
            return this.notFound();
        }
        this.getCoreService().deleteRole((org.appng.api.model.Role)appRole);
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.getUriBuilder().path("/application/{app}/role").buildAndExpand(new Object[]{app}).toUri());
        return this.noContent(headers);
    }

    private RoleImpl getApplicationRole(String application, String role) {
        return this.getCoreService().getApplicationRoleForApplication(application, role);
    }

    Logger logger() {
        return LOGGER;
    }
}

