/*
 * Decompiled with CFR 0.152.
 */
package org.appng.appngizer.controller;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.appng.api.model.Permission;
import org.appng.appngizer.controller.ControllerBase;
import org.appng.appngizer.model.Permissions;
import org.appng.appngizer.model.xml.Nameable;
import org.appng.core.domain.ApplicationImpl;
import org.appng.core.domain.PermissionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PermissionController
extends ControllerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(PermissionController.class);

    @GetMapping(value={"/application/{app}/permission"})
    public ResponseEntity<Permissions> listPermissions(@PathVariable(value="app") String app) {
        ApplicationImpl appByName = this.getApplicationByName(app);
        if (null == appByName) {
            return this.notFound();
        }
        ArrayList<org.appng.appngizer.model.Permission> permissionList = new ArrayList<org.appng.appngizer.model.Permission>();
        List permissionsForApplication = this.getCoreService().getPermissionsForApplication((Integer)appByName.getId());
        for (Permission p : permissionsForApplication) {
            permissionList.add(org.appng.appngizer.model.Permission.fromDomain((Permission)p));
        }
        Permissions permissions = new Permissions(permissionList, app);
        permissions.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)permissions);
    }

    @GetMapping(value={"/application/{app}/permission/{name}"})
    public ResponseEntity<org.appng.appngizer.model.Permission> getPermission(@PathVariable(value="app") String app, @PathVariable(value="name") String name) {
        ApplicationImpl appByName = this.getApplicationByName(app);
        if (null == appByName) {
            return this.notFound();
        }
        PermissionImpl permission = this.getCoreService().getPermission(app, name);
        if (null == permission) {
            return this.notFound();
        }
        org.appng.appngizer.model.Permission fromDomain = org.appng.appngizer.model.Permission.fromDomain((Permission)permission);
        fromDomain.setApplication(app);
        fromDomain.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)fromDomain);
    }

    @PostMapping(value={"/application/{app}/permission"})
    public ResponseEntity<org.appng.appngizer.model.Permission> createPermission(@PathVariable(value="app") String app, @RequestBody org.appng.appngizer.model.xml.Permission permission) {
        ApplicationImpl appByName = this.getApplicationByName(app);
        if (null == appByName) {
            return this.notFound();
        }
        PermissionImpl existingPermission = this.getCoreService().getPermission(app, permission.getName());
        if (null != existingPermission) {
            return this.conflict();
        }
        PermissionImpl newPermission = org.appng.appngizer.model.Permission.toDomain((org.appng.appngizer.model.xml.Permission)permission);
        newPermission.setApplication(appByName);
        this.getCoreService().savePermission(newPermission);
        this.getCoreService().getPermission(app, permission.getName());
        return this.ok((Object)org.appng.appngizer.model.Permission.fromDomain((Permission)newPermission));
    }

    @PutMapping(value={"/application/{app}/permission/{name}"})
    public ResponseEntity<org.appng.appngizer.model.Permission> updatePermission(@PathVariable(value="app") String app, @PathVariable(value="name") String name, @RequestBody org.appng.appngizer.model.xml.Permission permission) {
        PermissionImpl existingPermission;
        boolean nameChanged = this.nameChanged((Nameable)permission, name);
        if (nameChanged && null != (existingPermission = this.getCoreService().getPermission(app, permission.getName()))) {
            return this.conflict();
        }
        PermissionImpl currentPermission = this.getCoreService().getPermission(app, name);
        if (null == currentPermission) {
            return this.notFound();
        }
        currentPermission.setName(permission.getName());
        currentPermission.setDescription(permission.getDescription());
        this.getCoreService().savePermission(currentPermission);
        org.appng.appngizer.model.Permission fromDomain = org.appng.appngizer.model.Permission.fromDomain((Permission)currentPermission);
        if (nameChanged) {
            URI uri = this.getUriBuilder().path(fromDomain.getSelf()).build().toUri();
            return this.seeOther(uri);
        }
        fromDomain.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)fromDomain);
    }

    @DeleteMapping(value={"/application/{app}/permission/{name}"})
    public ResponseEntity<Void> deletePermission(@PathVariable(value="app") String app, @PathVariable(value="name") String name) {
        PermissionImpl existingPermission = this.getCoreService().getPermission(app, name);
        if (null == existingPermission) {
            return this.notFound();
        }
        this.getCoreService().deletePermission((Permission)existingPermission);
        return this.noContent(null);
    }

    Logger logger() {
        return LOGGER;
    }
}

