/*
 * Decompiled with CFR 0.152.
 */
package org.appng.appngizer.controller;

import java.io.File;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.appng.api.Environment;
import org.appng.api.messaging.Messaging;
import org.appng.api.support.environment.DefaultEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppNGizer
implements ServletContextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppNGizer.class);
    private static final String MANIFEST_MF = "META-INF/MANIFEST.MF";
    static final String APPNG_HOME = "APPNG_HOME";
    static final String APPNG_VERSION = "APPNG_VERSION";

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        try {
            URL resource = this.getClass().getClassLoader().getResource("appNGizer.txt");
            List<String> logoLines = Files.readAllLines(new File(resource.toURI()).toPath(), StandardCharsets.UTF_8);
            logoLines.forEach(l -> LOGGER.info(l));
            Manifest manifest = new Manifest(servletContext.getResourceAsStream(MANIFEST_MF));
            String version = manifest.getMainAttributes().getValue("Implementation-Version");
            LOGGER.info("Starting appNGizer {}", (Object)version);
            String appngHome = servletContext.getServletRegistration("appNGizer").getInitParameter(APPNG_HOME);
            LOGGER.info("{} = {}", (Object)APPNG_HOME, (Object)appngHome);
            servletContext.setAttribute(APPNG_VERSION, (Object)version);
            servletContext.setAttribute(APPNG_HOME, (Object)appngHome);
        }
        catch (Exception e) {
            if (!(e instanceof IllegalArgumentException)) {
                throw new IllegalStateException(e);
            }
            throw (IllegalArgumentException)e;
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        Messaging.shutdown((Environment)DefaultEnvironment.get((ServletContext)sce.getServletContext()));
    }
}

