/*
 * Decompiled with CFR 0.152.
 */
package org.appng.appngizer.model;

import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.appng.appngizer.model.UriAware;
import org.appng.appngizer.model.xml.SchemaVersion;
import org.appng.appngizer.model.xml.Versions;
import org.appng.core.domain.DatabaseConnection;
import org.appng.core.security.BCryptPasswordHandler;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.springframework.security.crypto.bcrypt.BCrypt;

/*
 * Exception performing whole class analysis ignored.
 */
public class Database
extends org.appng.appngizer.model.xml.Database
implements UriAware {
    private static DatatypeFactory dtf;

    public static Database fromDomain(DatabaseConnection dbc, MigrationInfoService status, String salt) {
        return Database.fromDomain((DatabaseConnection)dbc, (MigrationInfoService)status, (String)salt, (boolean)false);
    }

    public static Database fromDomain(DatabaseConnection dbc, MigrationInfoService status, String salt, boolean withManagedState) {
        Database db = new Database();
        StringBuilder dbInfo = new StringBuilder();
        boolean isOK = dbc.testConnection(dbInfo);
        if (isOK) {
            db.setVersions(new Versions());
            MigrationInfo[] all = status.all();
            for (int i = all.length; i > 0; --i) {
                MigrationInfo migrationInfo = all[i - 1];
                SchemaVersion schemaVersion = new SchemaVersion();
                schemaVersion.setDescription(migrationInfo.getDescription());
                schemaVersion.setChecksum(migrationInfo.getChecksum());
                schemaVersion.setVersion(migrationInfo.getVersion().getVersion());
                schemaVersion.setState(migrationInfo.getState().getDisplayName());
                Date installedOn = migrationInfo.getInstalledOn();
                if (null != installedOn) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(installedOn);
                    schemaVersion.setInstalled(dtf.newXMLGregorianCalendar(cal));
                }
                db.getVersions().getVersion().add(schemaVersion);
            }
            db.setDbVersion(dbInfo.toString());
        } else {
            db.setDbVersion("-unknown-");
        }
        db.setOk(isOK);
        db.setId(dbc.getId());
        db.setUser(dbc.getUserName());
        String realSalt = BCryptPasswordHandler.getPrefix() + "13$" + DigestUtils.sha256Hex((String)salt);
        db.setPassword(BCrypt.hashpw((String)dbc.getPasswordPlain(), (String)realSalt));
        db.setDriver(dbc.getDriverClass());
        db.setUrl(dbc.getJdbcUrl());
        db.setType(dbc.getType().name());
        if (withManagedState) {
            db.setManaged(Boolean.valueOf(dbc.isManaged()));
        }
        if (null != dbc.getDatabaseSize()) {
            db.setSize(dbc.getDatabaseSize());
        }
        return db;
    }

    public static void applyChanges(org.appng.appngizer.model.xml.Database database, DatabaseConnection dbc) {
        dbc.setUserName(database.getUser());
        dbc.setJdbcUrl(database.getUrl());
        dbc.setDriverClass(database.getDriver());
        if (StringUtils.isNotBlank((CharSequence)database.getPassword())) {
            dbc.setPasswordPlain(database.getPassword());
        }
    }

    static {
        try {
            dtf = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalStateException("error creating DatatypeFactory", e);
        }
    }
}

