/*
 * Decompiled with CFR 0.152.
 */
package org.appng.appngizer.controller;

import java.util.ArrayList;
import java.util.List;
import org.appng.api.model.Site;
import org.appng.appngizer.controller.PropertyBase;
import org.appng.appngizer.model.Properties;
import org.appng.appngizer.model.xml.Property;
import org.appng.core.domain.SiteImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SitePropertyController
extends PropertyBase {
    private static final Logger log = LoggerFactory.getLogger(SitePropertyController.class);

    @RequestMapping(value={"/site/{site}/property", "/site/{site}/properties"}, method={RequestMethod.GET})
    public ResponseEntity<Properties> listProperties(@PathVariable(value="site") String site) {
        SiteImpl siteByName = this.getSiteByName(site);
        if (null == siteByName) {
            return this.notFound();
        }
        return this.getProperties((Site)siteByName, null);
    }

    @RequestMapping(value={"/site/{site}/properties"}, method={RequestMethod.PUT})
    public ResponseEntity<Properties> updateProperties(@PathVariable(value="site") String site, @RequestBody org.appng.appngizer.model.xml.Properties properties) {
        SiteImpl siteByName = this.getSiteByName(site);
        if (null == siteByName) {
            return this.notFound();
        }
        ArrayList propsList = new ArrayList();
        for (Property property : properties.getProperty()) {
            ResponseEntity updated = this.updateProperty(property, (Site)siteByName, null);
            this.collectProperties(propsList, updated, property.getName(), HttpStatus.OK);
        }
        return new ResponseEntity((Object)new Properties(propsList, site, null), HttpStatus.OK);
    }

    private void collectProperties(List<org.appng.appngizer.model.Property> propsList, ResponseEntity<org.appng.appngizer.model.Property> updatedProperty, String name, HttpStatus expected) {
        org.appng.appngizer.model.Property prop;
        if (expected.equals((Object)updatedProperty.getStatusCode())) {
            prop = (org.appng.appngizer.model.Property)updatedProperty.getBody();
        } else {
            prop = new org.appng.appngizer.model.Property();
            prop.setName(name);
        }
        prop.setStatusCode(Integer.valueOf(updatedProperty.getStatusCode().value()));
        prop.setStatusMessage(updatedProperty.getStatusCode().getReasonPhrase());
        propsList.add(prop);
    }

    @RequestMapping(value={"/site/{site}/properties"}, method={RequestMethod.POST})
    public ResponseEntity<Properties> createProperties(@PathVariable(value="site") String site, @RequestBody org.appng.appngizer.model.xml.Properties properties) {
        SiteImpl siteByName = this.getSiteByName(site);
        if (null == siteByName) {
            return this.notFound();
        }
        ArrayList propsList = new ArrayList();
        for (Property property : properties.getProperty()) {
            ResponseEntity created = this.createProperty(property, (Site)siteByName, null);
            this.collectProperties(propsList, created, property.getName(), HttpStatus.CREATED);
        }
        return new ResponseEntity((Object)new Properties(propsList, site, null), HttpStatus.OK);
    }

    @RequestMapping(value={"/site/{site}/properties"}, method={RequestMethod.DELETE})
    public ResponseEntity<Properties> deleteProperties(@PathVariable(value="site") String site, @RequestBody org.appng.appngizer.model.xml.Properties properties) {
        SiteImpl siteByName = this.getSiteByName(site);
        if (null == siteByName) {
            return this.notFound();
        }
        ArrayList propsList = new ArrayList();
        for (Property property : properties.getProperty()) {
            ResponseEntity deleted = this.deleteProperty(property.getName(), (Site)siteByName, null);
            this.collectProperties(propsList, deleted, property.getName(), HttpStatus.OK);
        }
        return new ResponseEntity((Object)new Properties(propsList, site, null), HttpStatus.OK);
    }

    @RequestMapping(value={"/site/{site}/property/{prop}"}, method={RequestMethod.GET})
    public ResponseEntity<org.appng.appngizer.model.Property> getProperty(@PathVariable(value="site") String site, @PathVariable(value="prop") String prop) {
        SiteImpl siteByName = this.getSiteByName(site);
        if (null == siteByName) {
            return this.notFound();
        }
        return this.getPropertyResponse(prop, (Site)siteByName, null);
    }

    @RequestMapping(value={"/site/{site}/property"}, method={RequestMethod.POST})
    public ResponseEntity<org.appng.appngizer.model.Property> createProperty(@PathVariable(value="site") String site, @RequestBody Property property) {
        SiteImpl siteByName = this.getSiteByName(site);
        if (null == siteByName) {
            return this.notFound();
        }
        return this.createProperty(property, (Site)siteByName, null);
    }

    @RequestMapping(value={"/site/{site}/property/{prop}"}, method={RequestMethod.PUT})
    public ResponseEntity<org.appng.appngizer.model.Property> updateProperty(@PathVariable(value="site") String site, @RequestBody Property property) {
        SiteImpl siteByName = this.getSiteByName(site);
        if (null == siteByName) {
            return this.notFound();
        }
        return this.updateProperty(property, (Site)siteByName, null);
    }

    @RequestMapping(value={"/site/{site}/property/{prop}"}, method={RequestMethod.DELETE})
    public ResponseEntity<org.appng.appngizer.model.Property> deleteProperty(@PathVariable(value="site") String site, @PathVariable(value="prop") String property) {
        SiteImpl siteByName = this.getSiteByName(site);
        if (null == siteByName) {
            return this.notFound();
        }
        return this.deleteProperty(property, (Site)siteByName, null);
    }

    Logger logger() {
        return log;
    }
}

