/*
 * Decompiled with CFR 0.152.
 */
package org.appng.appngizer.controller;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.BusinessException;
import org.appng.api.model.Identifier;
import org.appng.api.support.PropertyHolder;
import org.appng.appngizer.controller.ControllerBase;
import org.appng.appngizer.model.Repositories;
import org.appng.appngizer.model.Repository;
import org.appng.appngizer.model.xml.Nameable;
import org.appng.appngizer.model.xml.Package;
import org.appng.appngizer.model.xml.PackageType;
import org.appng.appngizer.model.xml.Packages;
import org.appng.core.domain.ApplicationImpl;
import org.appng.core.domain.RepositoryImpl;
import org.appng.core.domain.Template;
import org.appng.core.model.InstallablePackage;
import org.appng.core.model.PackageArchive;
import org.appng.core.model.RepositoryCacheFactory;
import org.appng.core.model.RepositoryMode;
import org.appng.core.model.RepositoryType;
import org.appng.core.model.RepositoryUtils;
import org.appng.core.xml.repository.PackageVersions;
import org.appng.xml.application.PackageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class RepositoryController
extends ControllerBase {
    private static final Logger log = LoggerFactory.getLogger(RepositoryController.class);

    @RequestMapping(value={"/repository"}, method={RequestMethod.GET})
    public ResponseEntity<Repositories> listRepositories() {
        ArrayList<Repository> repoList = new ArrayList<Repository>();
        for (RepositoryImpl r : this.getCoreService().getApplicationRepositories()) {
            repoList.add(Repository.fromDomain((org.appng.core.model.Repository)r));
        }
        Repositories entity = new Repositories(repoList);
        entity.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)entity);
    }

    @RequestMapping(value={"/repository/{name}"}, method={RequestMethod.GET})
    public ResponseEntity<Repository> getRepository(@PathVariable(value="name") String name) throws BusinessException {
        org.appng.core.model.Repository r = this.getCoreService().getApplicationRepositoryByName(name);
        if (null == r) {
            return this.notFound();
        }
        Repository fromDomain = Repository.fromDomain((org.appng.core.model.Repository)r);
        fromDomain.setPackages((Packages)new org.appng.appngizer.model.Packages());
        ArrayList provisionedPackages = new ArrayList();
        provisionedPackages.addAll(this.getCoreService().getApplications());
        provisionedPackages.addAll(this.getTemplateService().getInstalledTemplates());
        List installablePackages = r.getInstallablePackages(provisionedPackages);
        for (InstallablePackage pkg : installablePackages) {
            org.appng.appngizer.model.Package p = new org.appng.appngizer.model.Package();
            p.setName(pkg.getName());
            p.setDisplayName(pkg.getDisplayName());
            p.setSnapshot(pkg.getLatestSnapshot());
            p.setRelease(pkg.getLatestRelease());
            p.setInstalled(StringUtils.isNotBlank((CharSequence)pkg.getInstalledVersion()));
            p.setType(PackageType.valueOf((String)pkg.getType().name()));
            fromDomain.getPackages().getPackage().add(p);
        }
        fromDomain.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)fromDomain);
    }

    @RequestMapping(value={"/repository/{name}/{package}"}, method={RequestMethod.GET})
    public ResponseEntity<org.appng.appngizer.model.Packages> getRepositoryPackages(@PathVariable(value="name") String name, @PathVariable(value="package") String packageName) {
        org.appng.core.model.Repository r = this.getCoreService().getApplicationRepositoryByName(name);
        if (null == r) {
            return this.notFound();
        }
        try {
            PackageVersions packageVersions = r.getPackageVersions(packageName);
            ApplicationImpl installedApp = this.getApplicationByName(packageName);
            Template installedTemplate = this.templateService.getTemplateByName(packageName);
            org.appng.appngizer.model.Packages packages = new org.appng.appngizer.model.Packages();
            for (PackageInfo pkg : packageVersions.getPackage()) {
                org.appng.appngizer.model.Package p = this.getPackage((Identifier)installedApp, (Identifier)installedTemplate, pkg);
                packages.getPackage().add(p);
            }
            PropertyComparator propertyComparator = new PropertyComparator("timestamp", false, false);
            Collections.sort(packages.getPackage(), propertyComparator);
            packages.setSelf("/repository/" + packages.encode(name) + "/" + packageName);
            packages.applyUriComponents(this.getUriBuilder());
            return this.ok((Object)packages);
        }
        catch (BusinessException e) {
            return this.notFound();
        }
    }

    protected org.appng.appngizer.model.Package getPackage(Identifier installedApp, Identifier installedTemplate, PackageInfo pkg) {
        org.appng.appngizer.model.Package p = org.appng.appngizer.model.Package.fromDomain((PackageInfo)pkg, (boolean)false);
        if (PackageType.APPLICATION.equals((Object)p.getType())) {
            p.setInstalled(this.isInstalled(installedApp, pkg));
        } else {
            p.setInstalled(this.isInstalled(installedTemplate, pkg));
        }
        return p;
    }

    @RequestMapping(value={"/repository/{name}/{package}/{version}/{timestamp}"}, method={RequestMethod.GET})
    public ResponseEntity<org.appng.appngizer.model.Package> getRepositoryPackage(@PathVariable(value="name") String name, @PathVariable(value="package") String packageName, @PathVariable(value="version") String packageVersion, @PathVariable(value="timestamp") String packageTimestamp) {
        org.appng.core.model.Repository r = this.getCoreService().getApplicationRepositoryByName(name);
        if (null == r) {
            return this.notFound();
        }
        try {
            PackageArchive packageArchive = r.getPackageArchive(packageName, packageVersion, packageTimestamp);
            if (null == packageArchive) {
                return this.notFound();
            }
            ApplicationImpl installedApp = this.getApplicationByName(packageName);
            Template installedTemplate = this.templateService.getTemplateByName(packageName);
            org.appng.appngizer.model.Package pkg = this.getPackage((Identifier)installedApp, (Identifier)installedTemplate, packageArchive.getPackageInfo());
            URI uri = this.getUriBuilder().path("/repository/{name}/{package}/{version}/{timestamp}").buildAndExpand(new Object[]{name, pkg.getName(), pkg.getVersion(), pkg.getTimestamp()}).toUri();
            pkg.setSelf(uri.toString());
            return this.ok((Object)pkg);
        }
        catch (BusinessException e) {
            return this.notFound();
        }
    }

    @RequestMapping(value={"/repository/{name}/{package}/{version}/{timestamp}"}, method={RequestMethod.DELETE})
    public ResponseEntity<org.appng.appngizer.model.Packages> deleteRepositoryPackage(@PathVariable(value="name") String name, @PathVariable(value="package") String packageName, @PathVariable(value="version") String packageVersion, @PathVariable(value="timestamp") String packageTimestamp) throws BusinessException {
        RepositoryImpl r = (RepositoryImpl)this.getCoreService().getApplicationRepositoryByName(name);
        if (null == r) {
            return this.notFound();
        }
        if (r.isActive() && RepositoryType.LOCAL.equals((Object)r.getRepositoryType())) {
            try {
                r.deletePackageVersion(packageName, packageVersion, packageTimestamp);
            }
            catch (BusinessException be) {
                return this.notFound();
            }
            catch (Exception e) {
                throw new BusinessException((Throwable)e);
            }
            return this.getRepositoryPackages(name, packageName);
        }
        return this.reply(HttpStatus.METHOD_NOT_ALLOWED);
    }

    protected boolean isInstalled(Identifier installed, PackageInfo pkg) {
        return null != installed && installed.getPackageVersion().equals(pkg.getVersion()) && installed.getTimestamp().equals(pkg.getTimestamp());
    }

    @RequestMapping(value={"/repository"}, method={RequestMethod.POST})
    public ResponseEntity<Repository> createRepository(@RequestBody org.appng.appngizer.model.xml.Repository repository) throws BusinessException, URISyntaxException {
        org.appng.core.model.Repository r = this.getCoreService().getApplicationRepositoryByName(repository.getName());
        if (null != r) {
            return this.conflict();
        }
        RepositoryImpl repo = Repository.toDomain((org.appng.appngizer.model.xml.Repository)repository);
        RepositoryCacheFactory.validateRepositoryURI((org.appng.core.model.Repository)repo);
        this.getCoreService().createRepository(repo);
        return this.created(this.getRepository(repository.getName()).getBody());
    }

    @RequestMapping(value={"/repository/{name}"}, method={RequestMethod.PUT})
    public ResponseEntity<Repository> updateRepository(@PathVariable(value="name") String name, @RequestBody org.appng.appngizer.model.xml.Repository repository) throws URISyntaxException {
        RepositoryImpl existingRepo;
        boolean nameChanged = this.nameChanged((Nameable)repository, name);
        if (nameChanged && null != (existingRepo = (RepositoryImpl)this.getCoreService().getApplicationRepositoryByName(repository.getName()))) {
            return this.conflict();
        }
        RepositoryImpl r = (RepositoryImpl)this.getCoreService().getApplicationRepositoryByName(name);
        if (null == r) {
            return this.notFound();
        }
        r.setDescription(repository.getDescription());
        r.setUri(new URI(repository.getUri()));
        r.setName(repository.getName());
        r.setRepositoryMode(RepositoryMode.valueOf((String)repository.getMode().name()));
        r.setActive(repository.isEnabled());
        r.setStrict(repository.isStrict());
        r.setPublished(repository.isPublished());
        this.getCoreService().saveRepository(r);
        Repository fromDomain = Repository.fromDomain((org.appng.core.model.Repository)r);
        fromDomain.applyUriComponents(this.getUriBuilder());
        if (nameChanged) {
            URI uri = this.getUriBuilder().path(fromDomain.getSelf()).build().toUri();
            return this.seeOther(uri);
        }
        return this.ok((Object)fromDomain);
    }

    @RequestMapping(value={"/repository/{name}/install"}, method={RequestMethod.PUT})
    public ResponseEntity<org.appng.appngizer.model.Package> installPackage(@PathVariable(value="name") String name, @RequestBody Package pkg) throws BusinessException {
        RepositoryImpl r = (RepositoryImpl)this.getCoreService().getApplicationRepositoryByName(name);
        if (null == r) {
            return this.notFound();
        }
        PropertyHolder platformCfg = this.getCoreService().getPlatformProperties();
        boolean isFileBased = platformCfg.getBoolean("filebasedDeployment");
        PackageInfo installedPackage = this.getCoreService().installPackage(r.getId(), pkg.getName(), pkg.getVersion(), pkg.getTimestamp(), false, false, isFileBased);
        if (null == installedPackage) {
            return this.notFound();
        }
        return this.getRepositoryPackage(name, pkg.getName(), pkg.getVersion(), pkg.getTimestamp());
    }

    @RequestMapping(value={"/repository/{name}/upload"}, method={RequestMethod.POST})
    public ResponseEntity<org.appng.appngizer.model.Package> uploadPackage(@PathVariable(value="name") String name, @RequestParam(value="file") MultipartFile file) throws BusinessException {
        org.appng.core.model.Repository r = this.getCoreService().getApplicationRepositoryByName(name);
        if (null == r) {
            return this.notFound();
        }
        if (!RepositoryType.LOCAL.equals((Object)r.getRepositoryType())) {
            return this.reply(HttpStatus.METHOD_NOT_ALLOWED);
        }
        try {
            File outFile = new File(new File(r.getUri()), file.getOriginalFilename());
            FileUtils.writeByteArrayToFile((File)outFile, (byte[])file.getBytes());
            PackageArchive packageArchive = RepositoryUtils.getPackage((org.appng.core.model.Repository)r, (File)outFile, (String)file.getOriginalFilename());
            if (null != packageArchive) {
                RepositoryCacheFactory.instance().getCache(r).reload();
                PackageInfo packageInfo = packageArchive.getPackageInfo();
                return this.getRepositoryPackage(name, packageInfo.getName(), packageInfo.getVersion(), packageInfo.getTimestamp());
            }
            FileUtils.deleteQuietly((File)outFile);
            return this.reply(HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    @RequestMapping(value={"/repository/{name}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteRepository(@PathVariable(value="name") String name) {
        RepositoryImpl repository = (RepositoryImpl)this.getCoreService().getApplicationRepositoryByName(name);
        if (null == repository) {
            return this.notFound();
        }
        this.getCoreService().deleteApplicationRepository((org.appng.core.model.Repository)repository);
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.getUriBuilder().path("/repository").build().toUri());
        return this.noContent(headers);
    }

    Logger logger() {
        return log;
    }
}

