/*
 * Decompiled with CFR 0.152.
 */
package org.appng.appngizer.controller;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.appng.api.BusinessException;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.messaging.Event;
import org.appng.api.messaging.Messaging;
import org.appng.api.messaging.Sender;
import org.appng.api.support.FieldProcessorImpl;
import org.appng.api.support.environment.DefaultEnvironment;
import org.appng.appngizer.controller.ControllerBase;
import org.appng.appngizer.model.Sites;
import org.appng.appngizer.model.xml.Link;
import org.appng.appngizer.model.xml.Site;
import org.appng.core.controller.messaging.ReloadSiteEvent;
import org.appng.core.domain.SiteImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Controller
@RestController
public class SiteController
extends ControllerBase {
    private static final Logger log = LoggerFactory.getLogger(SiteController.class);

    @RequestMapping(value={"/site"}, method={RequestMethod.GET})
    public ResponseEntity<Sites> listSites() {
        ArrayList<org.appng.appngizer.model.Site> siteList = new ArrayList<org.appng.appngizer.model.Site>();
        for (SiteImpl site : this.getCoreService().getSites()) {
            org.appng.appngizer.model.Site fromDomain = org.appng.appngizer.model.Site.fromDomain((SiteImpl)site);
            fromDomain.applyUriComponents(this.getUriBuilder());
            siteList.add(fromDomain);
        }
        Sites sites = new Sites(siteList);
        sites.applyUriComponents(this.getUriBuilder());
        return new ResponseEntity((Object)sites, HttpStatus.OK);
    }

    @RequestMapping(value={"/site/{name}"}, method={RequestMethod.GET})
    public ResponseEntity<org.appng.appngizer.model.Site> getSite(@PathVariable(value="name") String name) {
        SiteImpl site = this.getSiteByName(name);
        if (null == site) {
            return this.notFound();
        }
        org.appng.appngizer.model.Site fromDomain = org.appng.appngizer.model.Site.fromDomain((SiteImpl)site);
        if (null != this.getSender((Environment)DefaultEnvironment.get((ServletContext)this.context)) || this.supportsReloadFile((org.appng.api.model.Site)site)) {
            fromDomain.addLink((Link)new org.appng.appngizer.model.Link("reload", "/site/" + name + "/reload"));
        }
        fromDomain.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)fromDomain);
    }

    @RequestMapping(value={"/site/{name}/reload"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> reloadSite(@PathVariable(value="name") String name) throws BusinessException {
        SiteImpl site = this.getSiteByName(name);
        if (null == site) {
            return this.notFound();
        }
        Sender sender = this.getSender((Environment)DefaultEnvironment.get((ServletContext)this.context));
        if (null != sender) {
            log.debug("messaging is active, sending ReloadSiteEvent");
            sender.send((Event)new ReloadSiteEvent(name));
        } else if (this.supportsReloadFile((org.appng.api.model.Site)site)) {
            String rootDir = site.getProperties().getString("siteRootDir");
            File reloadFile = new File(rootDir, ".reload");
            try {
                log.debug("Created reload marker {}", (Object)reloadFile.getAbsolutePath());
                FileUtils.touch((File)reloadFile);
            }
            catch (IOException e) {
                throw new BusinessException((Throwable)e);
            }
        } else {
            return this.reply(HttpStatus.METHOD_NOT_ALLOWED);
        }
        return this.ok(null);
    }

    private Sender getSender(Environment env) {
        return Messaging.getMessageSender((Environment)env);
    }

    private boolean supportsReloadFile(org.appng.api.model.Site site) {
        return Boolean.TRUE.equals(site.getProperties().getBoolean("supportReloadFile"));
    }

    @RequestMapping(value={"/site"}, method={RequestMethod.POST})
    public ResponseEntity<org.appng.appngizer.model.Site> createSite(@RequestBody Site site) {
        SiteImpl currentSite = this.getSiteByName(site.getName());
        if (null != currentSite) {
            return this.conflict();
        }
        this.getCoreService().createSite(org.appng.appngizer.model.Site.toDomain((Site)site));
        return this.created(this.getSite(site.getName()).getBody());
    }

    @RequestMapping(value={"/site/{name}"}, method={RequestMethod.PUT})
    public ResponseEntity<org.appng.appngizer.model.Site> updateSite(@PathVariable(value="name") String name, @RequestBody Site site) {
        SiteImpl siteByName = this.getSiteByName(name);
        if (null == siteByName) {
            return this.notFound();
        }
        siteByName.setHost(site.getHost());
        siteByName.setDomain(site.getDomain());
        siteByName.setDescription(site.getDescription());
        siteByName.setActive(site.isActive());
        this.getCoreService().saveSite(siteByName);
        return this.ok(this.getSite(name).getBody());
    }

    @RequestMapping(value={"/site/{name}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteSite(@PathVariable(value="name") String name) throws BusinessException {
        SiteImpl currentSite = this.getSiteByName(name);
        if (null == currentSite) {
            return this.notFound();
        }
        this.getCoreService().deleteSite(name, (FieldProcessor)new FieldProcessorImpl("delete-site"));
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.getUriBuilder().path("/site").build().toUri());
        return this.noContent(headers);
    }

    Logger logger() {
        return log;
    }
}

