/*
 * Decompiled with CFR 0.152.
 */
package org.appng.appngizer.controller;

import java.net.URI;
import java.util.ArrayList;
import org.appng.api.model.Group;
import org.appng.appngizer.controller.ControllerBase;
import org.appng.appngizer.model.Groups;
import org.appng.appngizer.model.Role;
import org.appng.appngizer.model.xml.Nameable;
import org.appng.appngizer.model.xml.Roles;
import org.appng.core.domain.GroupImpl;
import org.appng.core.domain.RoleImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class GroupController
extends ControllerBase {
    private static final Logger log = LoggerFactory.getLogger(GroupController.class);

    @RequestMapping(value={"/group"}, method={RequestMethod.GET})
    public ResponseEntity<Groups> listGroups() {
        ArrayList<org.appng.appngizer.model.Group> groupList = new ArrayList<org.appng.appngizer.model.Group>();
        for (Group g : this.getCoreService().getGroups()) {
            groupList.add(org.appng.appngizer.model.Group.fromDomain((Group)g));
        }
        Groups groups = new Groups(groupList);
        groups.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)groups);
    }

    @RequestMapping(value={"/group/{name}"}, method={RequestMethod.GET})
    public ResponseEntity<org.appng.appngizer.model.Group> getGroup(@PathVariable(value="name") String name) {
        GroupImpl group = this.getCoreService().getGroupByName(name, true);
        if (null == group) {
            return this.notFound();
        }
        org.appng.appngizer.model.Group fromDomain = org.appng.appngizer.model.Group.fromDomain((Group)group);
        this.addRoles(group, fromDomain);
        fromDomain.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)fromDomain);
    }

    public void addRoles(GroupImpl group, org.appng.appngizer.model.Group fromDomain) {
        fromDomain.setRoles((Roles)new org.appng.appngizer.model.Roles());
        for (org.appng.api.model.Role r : group.getRoles()) {
            fromDomain.getRoles().getRole().add(Role.fromDomain((org.appng.api.model.Role)r));
        }
    }

    @RequestMapping(value={"/group"}, method={RequestMethod.POST})
    public ResponseEntity<org.appng.appngizer.model.Group> createGroup(@RequestBody org.appng.appngizer.model.xml.Group group) {
        GroupImpl currentGroup = this.getCoreService().getGroupByName(group.getName());
        if (null != currentGroup) {
            return this.conflict();
        }
        GroupImpl groupImpl = org.appng.appngizer.model.Group.toDomain((org.appng.appngizer.model.xml.Group)group);
        this.updateRoles(group.getRoles(), groupImpl);
        this.getCoreService().createGroup(groupImpl);
        return this.created(this.getGroup(group.getName()).getBody());
    }

    @RequestMapping(value={"/group/{name}"}, method={RequestMethod.PUT})
    public ResponseEntity<org.appng.appngizer.model.Group> updateGroup(@PathVariable(value="name") String name, @RequestBody org.appng.appngizer.model.xml.Group group) {
        GroupImpl existingGroup;
        boolean nameChanged = this.nameChanged((Nameable)group, name);
        if (nameChanged && null != (existingGroup = this.getCoreService().getGroupByName(group.getName(), false))) {
            return this.conflict();
        }
        GroupImpl currentGroup = this.getCoreService().getGroupByName(name, true);
        if (null == currentGroup) {
            return this.notFound();
        }
        currentGroup.setName(group.getName());
        currentGroup.setDescription(group.getDescription());
        this.updateRoles(group.getRoles(), currentGroup);
        this.getCoreService().updateGroup(currentGroup);
        org.appng.appngizer.model.Group fromDomain = org.appng.appngizer.model.Group.fromDomain((Group)currentGroup);
        if (nameChanged) {
            URI uri = this.getUriBuilder().path(fromDomain.getSelf()).build().toUri();
            return this.seeOther(uri);
        }
        this.addRoles(currentGroup, fromDomain);
        fromDomain.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)fromDomain);
    }

    public void updateRoles(Roles roles, GroupImpl group) {
        if (null != roles) {
            group.getRoles().clear();
            if (null != roles.getRole()) {
                for (org.appng.appngizer.model.xml.Role r : roles.getRole()) {
                    RoleImpl role = this.getCoreService().getApplicationRoleForApplication(r.getApplication(), r.getName());
                    if (null == role) continue;
                    group.getRoles().add(role);
                }
            }
        }
    }

    @RequestMapping(value={"/group/{name}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteGroup(@PathVariable(value="name") String name) {
        GroupImpl currentGroup = this.getCoreService().getGroupByName(name);
        if (null == currentGroup) {
            return this.notFound();
        }
        if (currentGroup.isDefaultAdmin()) {
            return this.conflict();
        }
        this.getCoreService().deleteGroup(currentGroup);
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.getUriBuilder().path("/group").build().toUri());
        return this.noContent(headers);
    }

    Logger logger() {
        return log;
    }
}

