/*
 * Decompiled with CFR 0.152.
 */
package org.appng.appngizer.controller;

import java.util.ArrayList;
import org.appng.api.BusinessException;
import org.appng.api.FieldProcessor;
import org.appng.api.support.FieldProcessorImpl;
import org.appng.appngizer.controller.PropertyBase;
import org.appng.appngizer.model.Application;
import org.appng.appngizer.model.Applications;
import org.appng.appngizer.model.Properties;
import org.appng.appngizer.model.xml.Property;
import org.appng.core.domain.ApplicationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ApplicationController
extends PropertyBase {
    private static final Logger log = LoggerFactory.getLogger(ApplicationController.class);

    @RequestMapping(value={"/application"}, method={RequestMethod.GET})
    public ResponseEntity<Applications> listApplications() {
        ArrayList<Application> appList = new ArrayList<Application>();
        for (ApplicationImpl application : this.getCoreService().getApplications()) {
            appList.add(Application.fromDomain((ApplicationImpl)application));
        }
        Applications applications = new Applications(appList);
        applications.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)applications);
    }

    @RequestMapping(value={"/application/{name}"}, method={RequestMethod.GET})
    public ResponseEntity<Application> getApplication(@PathVariable(value="name") String name) {
        ApplicationImpl application = this.getApplicationByName(name);
        if (null == application) {
            return this.notFound();
        }
        Application fromDomain = Application.fromDomain((ApplicationImpl)application);
        fromDomain.addLinks();
        fromDomain.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)fromDomain);
    }

    @RequestMapping(value={"/application/{name}"}, method={RequestMethod.PUT})
    public ResponseEntity<Application> updateApplication(@PathVariable(value="name") String name, @RequestBody org.appng.appngizer.model.xml.Application application) throws BusinessException {
        ApplicationImpl applicationByName = this.getApplicationByName(name);
        if (null == applicationByName) {
            return this.notFound();
        }
        applicationByName.setHidden(application.isHidden());
        applicationByName.setPrivileged(application.isPrivileged());
        applicationByName.setDisplayName(application.getDisplayName());
        this.getCoreService().updateApplication(applicationByName, application.isFileBased());
        return this.ok((Object)Application.fromDomain((ApplicationImpl)applicationByName));
    }

    @RequestMapping(value={"/application/{name}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteApplication(@PathVariable(value="name") String name) throws BusinessException {
        ApplicationImpl currentApplication = this.getApplicationByName(name);
        if (null == currentApplication) {
            return this.notFound();
        }
        this.getCoreService().deleteApplication(name, (FieldProcessor)new FieldProcessorImpl("delete-application"));
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.getUriBuilder().path("/application").build().toUri());
        return this.noContent(headers);
    }

    @RequestMapping(value={"/application/{name}/property"}, method={RequestMethod.GET})
    public ResponseEntity<Properties> listProperties(@PathVariable(value="name") String name) {
        return this.getProperties(null, (org.appng.api.model.Application)this.getApplicationByName(name));
    }

    @RequestMapping(value={"/application/{name}/property/{prop}"}, method={RequestMethod.GET})
    public ResponseEntity<org.appng.appngizer.model.Property> getProperty(@PathVariable(value="name") String name, @PathVariable(value="prop") String prop) {
        return this.getPropertyResponse(prop, null, (org.appng.api.model.Application)this.getApplicationByName(name));
    }

    @RequestMapping(value={"/application/{name}/property"}, method={RequestMethod.POST})
    public ResponseEntity<org.appng.appngizer.model.Property> createProperty(@PathVariable(value="name") String name, @RequestBody Property property) {
        return this.createProperty(property, null, (org.appng.api.model.Application)this.getApplicationByName(name));
    }

    @RequestMapping(value={"/application/{name}/property/{prop}"}, method={RequestMethod.PUT})
    public ResponseEntity<org.appng.appngizer.model.Property> updateProperty(@PathVariable(value="name") String name, @RequestBody Property property) {
        return this.updateProperty(property, null, (org.appng.api.model.Application)this.getApplicationByName(name));
    }

    @RequestMapping(value={"/application/{name}/property/{prop}"}, method={RequestMethod.DELETE})
    public ResponseEntity<org.appng.appngizer.model.Property> deleteProperty(@PathVariable(value="name") String name, @PathVariable(value="prop") String property) {
        return this.deleteProperty(property, null, (org.appng.api.model.Application)this.getApplicationByName(name));
    }

    Logger logger() {
        return log;
    }
}

