/*
 * Decompiled with CFR 0.152.
 */
package org.appng.appngizer.controller;

import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.appngizer.controller.PropertyBase;
import org.appng.appngizer.model.Properties;
import org.appng.appngizer.model.xml.Property;
import org.appng.core.domain.SiteImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SiteApplicationPropertyController
extends PropertyBase {
    private static final Logger log = LoggerFactory.getLogger(SiteApplicationPropertyController.class);

    @RequestMapping(value={"/site/{site}/application/{app}/property"}, method={RequestMethod.GET})
    public ResponseEntity<Properties> listProperties(@PathVariable(value="site") String site, @PathVariable(value="app") String app) {
        SiteImpl siteByName = this.getSiteByName(site);
        if (null == siteByName) {
            return this.notFound();
        }
        Application appByName = siteByName.getApplication(app);
        if (null == appByName) {
            return this.notFound();
        }
        return this.getProperties((Site)siteByName, appByName);
    }

    @RequestMapping(value={"/site/{site}/application/{app}/property/{prop}"}, method={RequestMethod.GET})
    public ResponseEntity<org.appng.appngizer.model.Property> getProperty(@PathVariable(value="site") String site, @PathVariable(value="app") String app, @PathVariable(value="prop") String prop) {
        SiteImpl siteByName = this.getSiteByName(site);
        if (null == siteByName) {
            return this.notFound();
        }
        Application appByName = siteByName.getApplication(app);
        if (null == appByName) {
            return this.notFound();
        }
        return this.getPropertyResponse(prop, (Site)siteByName, appByName);
    }

    @RequestMapping(value={"/site/{site}/application/{app}/property"}, method={RequestMethod.POST})
    public ResponseEntity<org.appng.appngizer.model.Property> createProperty(@PathVariable(value="site") String site, @PathVariable(value="app") String app, @RequestBody Property property) {
        SiteImpl siteByName = this.getSiteByName(site);
        if (null == siteByName) {
            return this.notFound();
        }
        Application appByName = siteByName.getApplication(app);
        if (null == appByName) {
            return this.notFound();
        }
        return this.createProperty(property, (Site)siteByName, appByName);
    }

    @RequestMapping(value={"/site/{site}/application/{app}/property/{prop}"}, method={RequestMethod.PUT})
    public ResponseEntity<org.appng.appngizer.model.Property> updateProperty(@PathVariable(value="site") String site, @PathVariable(value="app") String app, @RequestBody Property property) {
        SiteImpl siteByName = this.getSiteByName(site);
        if (null == siteByName) {
            return this.notFound();
        }
        Application appByName = siteByName.getApplication(app);
        if (null == appByName) {
            return this.notFound();
        }
        return this.updateProperty(property, (Site)siteByName, appByName);
    }

    @RequestMapping(value={"/site/{site}/application/{app}/property/{prop}"}, method={RequestMethod.DELETE})
    public ResponseEntity<org.appng.appngizer.model.Property> deleteProperty(@PathVariable(value="site") String site, @PathVariable(value="app") String app, @PathVariable(value="prop") String property) {
        SiteImpl siteByName = this.getSiteByName(site);
        if (null == siteByName) {
            return this.notFound();
        }
        Application appByName = siteByName.getApplication(app);
        if (null == appByName) {
            return this.notFound();
        }
        return this.deleteProperty(property, (Site)siteByName, appByName);
    }

    Logger logger() {
        return log;
    }
}

