/*
 * Decompiled with CFR 0.152.
 */
package org.appng.appngizer.controller;

import java.util.ArrayList;
import org.appng.api.model.Application;
import org.appng.api.model.Property;
import org.appng.api.model.Site;
import org.appng.appngizer.controller.ControllerBase;
import org.appng.appngizer.model.Properties;
import org.appng.core.domain.PropertyImpl;
import org.appng.core.service.PropertySupport;
import org.springframework.http.ResponseEntity;

abstract class PropertyBase
extends ControllerBase {
    PropertyBase() {
    }

    ResponseEntity<Properties> getProperties(Site site, Application app) {
        ArrayList<org.appng.appngizer.model.Property> propsList = new ArrayList<org.appng.appngizer.model.Property>();
        String siteName = null == site ? null : site.getName();
        String applicationName = null == app ? null : app.getName();
        for (PropertyImpl prop : this.getCoreService().getProperties(siteName, applicationName)) {
            propsList.add(org.appng.appngizer.model.Property.fromDomain((Property)prop, (Site)site, (Application)app));
        }
        Properties properties = new Properties(propsList, siteName, applicationName);
        properties.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)properties);
    }

    ResponseEntity<org.appng.appngizer.model.Property> getPropertyResponse(String property, Site site, Application app) {
        PropertyImpl propertyImpl = this.getProperty(property, site, app);
        if (null == propertyImpl) {
            return this.notFound();
        }
        org.appng.appngizer.model.Property fromDomain = org.appng.appngizer.model.Property.fromDomain((Property)propertyImpl, (Site)site, (Application)app);
        fromDomain.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)fromDomain);
    }

    ResponseEntity<org.appng.appngizer.model.Property> createProperty(org.appng.appngizer.model.xml.Property property, Site site, Application application) {
        PropertyImpl existingProperty = this.getProperty(property.getName(), site, application);
        if (null != existingProperty) {
            return this.conflict();
        }
        PropertyImpl propertyImpl = org.appng.appngizer.model.Property.toDomain((org.appng.appngizer.model.xml.Property)property);
        Integer siteId = site == null ? null : (Integer)site.getId();
        Integer applicationId = application == null ? null : (Integer)application.getId();
        this.getCoreService().createProperty(siteId, applicationId, propertyImpl);
        return this.created(this.getPropertyResponse(property.getName(), site, application).getBody());
    }

    ResponseEntity<org.appng.appngizer.model.Property> updateProperty(org.appng.appngizer.model.xml.Property property, Site site, Application app) {
        PropertyImpl propertyImpl = this.getProperty(property.getName(), site, app);
        if (null == propertyImpl) {
            return this.notFound();
        }
        PropertyImpl domainProp = org.appng.appngizer.model.Property.toDomain((org.appng.appngizer.model.xml.Property)property);
        propertyImpl.setString(domainProp.getActualString());
        propertyImpl.setDescription(domainProp.getDescription());
        propertyImpl.setClob(domainProp.getClob());
        this.getCoreService().saveProperty(propertyImpl);
        org.appng.appngizer.model.Property fromDomain = org.appng.appngizer.model.Property.fromDomain((Property)propertyImpl, (Site)site, (Application)app);
        fromDomain.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)fromDomain);
    }

    PropertyImpl getProperty(String property, Site site, Application application) {
        String prefix = PropertySupport.getPropertyPrefix((Site)site, (Application)application);
        return this.getCoreService().getProperty(prefix + property);
    }

    ResponseEntity<org.appng.appngizer.model.Property> deleteProperty(String property, Site site, Application app) {
        PropertyImpl propertyImpl = this.getProperty(property, site, app);
        if (null == propertyImpl) {
            return this.notFound();
        }
        this.getCoreService().deleteProperty(propertyImpl);
        return this.noContent(null);
    }
}

