/*
 * Decompiled with CFR 0.152.
 */
package org.appng.appngizer.controller;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.appng.api.Environment;
import org.appng.api.Scope;
import org.appng.api.messaging.EventHandler;
import org.appng.api.messaging.Messaging;
import org.appng.api.support.PropertyHolder;
import org.appng.api.support.SiteClassLoader;
import org.appng.api.support.environment.DefaultEnvironment;
import org.appng.appngizer.controller.ControllerBase;
import org.appng.appngizer.controller.Home;
import org.appng.core.domain.SiteImpl;
import org.appng.core.model.RepositoryCacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class Home
extends ControllerBase
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(Home.class);
    static final String AUTHORIZED = "authorized";
    static final String ROOT = "/";
    ExecutorService executor;

    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public ResponseEntity<org.appng.appngizer.model.xml.Home> login(@RequestBody String sharedSecret, HttpServletRequest request) {
        String platformSecret = this.getSharedSecret();
        if (!platformSecret.equals(sharedSecret)) {
            log.info("invalid shared secret for session {}", (Object)this.session.getId());
            return this.reply(HttpStatus.FORBIDDEN);
        }
        this.session.setAttribute(AUTHORIZED, (Object)true);
        log.info("session {} has been authorized (user-agent: {})", (Object)this.session.getId(), (Object)request.getHeader("User-Agent"));
        return this.welcome();
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public ResponseEntity<org.appng.appngizer.model.xml.Home> welcome() {
        String appngVersion = (String)this.context.getAttribute("APPNG_VERSION");
        boolean dbInitialized = this.getDatabaseStatus() != null;
        org.appng.appngizer.model.Home entity = new org.appng.appngizer.model.Home(appngVersion, dbInitialized, this.getUriBuilder());
        entity.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)entity);
    }

    Logger logger() {
        return log;
    }

    public void afterPropertiesSet() throws Exception {
        Properties props = this.configurer.getProps();
        if (null == this.getDatabaseStatus()) {
            this.logger().info("database is not initialized, must initialize first");
            this.databaseService.initDatabase(props);
        }
        DefaultEnvironment env = DefaultEnvironment.get((ServletContext)this.context);
        org.appng.api.model.Properties platformConfig = this.initPlatform(props, (Environment)env);
        this.initMessaging((Environment)env);
        RepositoryCacheFactory.init((org.appng.api.model.Properties)platformConfig);
    }

    protected void initMessaging(Environment env) {
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder();
        ThreadFactory threadFactory = tfb.setDaemon(true).setNameFormat("appng-messaging").build();
        this.executor = Executors.newSingleThreadExecutor(threadFactory);
        1 defaultHandler = new /* Unavailable Anonymous Inner Class!! */;
        String nodeId = System.getProperty("appng.node.id") + "_appGNizer";
        Messaging.createMessageSender((Environment)env, (ExecutorService)this.executor, (String)nodeId, (EventHandler)defaultHandler, null);
    }

    protected org.appng.api.model.Properties initPlatform(Properties defaultOverrides, Environment env) {
        String rootPath = (String)this.context.getAttribute("APPNG_HOME");
        PropertyHolder platformConfig = this.coreService.initPlatformConfig(defaultOverrides, rootPath, Boolean.valueOf(false), true, true);
        env.setAttribute(Scope.PLATFORM, "platformConfig", (Object)platformConfig);
        HashMap<String, SiteImpl> siteMap = new HashMap<String, SiteImpl>();
        for (SiteImpl site : this.getCoreService().getSites()) {
            if (!site.isActive()) continue;
            SiteImpl s = this.getCoreService().getSite(site.getId());
            SiteClassLoader siteClassLoader = new SiteClassLoader(new URL[0], this.getClass().getClassLoader(), site.getName());
            s.setSiteClassLoader(siteClassLoader);
            siteMap.put(site.getName(), s);
        }
        env.setAttribute(Scope.PLATFORM, "sites", siteMap);
        return platformConfig;
    }

    public void destroy() throws Exception {
        List<Runnable> shutdownNow = this.executor.shutdownNow();
        for (Runnable runnable : shutdownNow) {
            this.logger().info(runnable.toString());
        }
    }
}

