/*
 * Decompiled with CFR 0.152.
 */
package org.appng.appngizer.controller;

import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import org.appng.api.model.Application;
import org.appng.appngizer.controller.ControllerBase;
import org.appng.appngizer.model.Databases;
import org.appng.appngizer.model.xml.Database;
import org.appng.appngizer.model.xml.Link;
import org.appng.appngizer.model.xml.Links;
import org.appng.core.domain.DatabaseConnection;
import org.appng.core.domain.SiteApplication;
import org.appng.core.domain.SiteImpl;
import org.flywaydb.core.api.MigrationInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DatabaseController
extends ControllerBase {
    private static final Logger log = LoggerFactory.getLogger(DatabaseController.class);

    @RequestMapping(value={"/platform/database"}, method={RequestMethod.GET})
    public ResponseEntity<org.appng.appngizer.model.Database> info() throws Exception {
        DatabaseConnection platformConnection = this.databaseService.getPlatformConnection(this.configurer.getProps());
        return this.info(platformConnection);
    }

    @RequestMapping(value={"/platform/database/initialize"}, method={RequestMethod.POST})
    public ResponseEntity<org.appng.appngizer.model.Database> initialize() throws Exception {
        return this.info(this.databaseService.initDatabase(this.configurer.getProps()));
    }

    protected ResponseEntity<org.appng.appngizer.model.Database> info(DatabaseConnection platformConnection) throws DatatypeConfigurationException {
        MigrationInfoService statusComplete = this.databaseService.statusComplete(platformConnection);
        org.appng.appngizer.model.Database db = org.appng.appngizer.model.Database.fromDomain((DatabaseConnection)platformConnection, (MigrationInfoService)statusComplete, (String)this.getSharedSecret());
        db.setSelf("/platform/database");
        db.setLinks(new Links());
        db.getLinks().getLink().add(new org.appng.appngizer.model.Link("initialize", db.getSelf() + "/initialize"));
        db.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)db);
    }

    @RequestMapping(value={"/site/{name}/database"}, method={RequestMethod.GET})
    public ResponseEntity<Databases> getDatabaseConnections(@PathVariable(value="name") String name) {
        SiteImpl site = this.getSiteByName(name);
        if (null == site) {
            return this.notFound();
        }
        Databases databases = new Databases(name);
        List databaseConnections = this.coreService.getDatabaseConnectionsForSite(site.getId());
        for (DatabaseConnection dbc : databaseConnections) {
            org.appng.appngizer.model.Database fromDomain = org.appng.appngizer.model.Database.fromDomain((DatabaseConnection)dbc, (MigrationInfoService)this.databaseService.statusComplete(dbc), (String)this.getSharedSecret());
            this.addApplicationLink(name, dbc, fromDomain);
            fromDomain.setSelf("/site/" + name + "/database/" + dbc.getId());
            fromDomain.applyUriComponents(this.getUriBuilder());
            databases.getDatabase().add(fromDomain);
        }
        return this.ok((Object)databases);
    }

    protected void addApplicationLink(String site, DatabaseConnection dbc, org.appng.appngizer.model.Database fromDomain) {
        Application application = this.coreService.getApplicationForConnection(dbc);
        if (null != application) {
            fromDomain.addLink((Link)new org.appng.appngizer.model.Link("application", "/site/" + site + "/application/" + application.getName()));
        }
    }

    @RequestMapping(value={"/site/{site}/application/{app}/database"}, method={RequestMethod.GET})
    public ResponseEntity<org.appng.appngizer.model.Database> getDatabaseConnectionForApplication(@PathVariable(value="site") String site, @PathVariable(value="app") String app) {
        SiteApplication siteApplication = this.coreService.getSiteApplication(site, app);
        if (null == siteApplication) {
            return this.notFound();
        }
        DatabaseConnection dbc = siteApplication.getDatabaseConnection();
        if (null == dbc) {
            return this.notFound();
        }
        org.appng.appngizer.model.Database fromDomain = org.appng.appngizer.model.Database.fromDomain((DatabaseConnection)dbc, (MigrationInfoService)this.databaseService.statusComplete(dbc), (String)this.getSharedSecret());
        this.addApplicationLink(site, dbc, fromDomain);
        fromDomain.setSelf("/site/" + site + "/application/" + app + "/database/");
        fromDomain.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)fromDomain);
    }

    @RequestMapping(value={"/site/{site}/application/{app}/database"}, method={RequestMethod.PUT})
    public ResponseEntity<org.appng.appngizer.model.Database> updateDatabaseConnectionforApplication(@PathVariable(value="site") String site, @PathVariable(value="app") String app, @RequestBody Database database) {
        SiteApplication siteApplication = this.coreService.getSiteApplication(site, app);
        if (null == siteApplication) {
            return this.notFound();
        }
        DatabaseConnection dbc = siteApplication.getDatabaseConnection();
        if (null == dbc) {
            return this.notFound();
        }
        org.appng.appngizer.model.Database.applyChanges((Database)database, (DatabaseConnection)dbc);
        this.databaseService.save(dbc);
        ResponseEntity updated = this.getDatabaseConnectionForApplication(site, app);
        return this.ok(updated.getBody());
    }

    @RequestMapping(value={"/site/{name}/database/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<org.appng.appngizer.model.Database> getDatabaseConnection(@PathVariable(value="name") String name, @PathVariable(value="id") Integer id) {
        SiteImpl site = this.getSiteByName(name);
        if (null == site) {
            return this.notFound();
        }
        DatabaseConnection dbc = this.coreService.getDatabaseConnection(id, false);
        if (null == dbc) {
            return this.notFound();
        }
        org.appng.appngizer.model.Database fromDomain = org.appng.appngizer.model.Database.fromDomain((DatabaseConnection)dbc, (MigrationInfoService)this.databaseService.statusComplete(dbc), (String)this.getSharedSecret());
        this.addApplicationLink(name, dbc, fromDomain);
        fromDomain.setSelf("/site/" + name + "/database/" + dbc.getId());
        fromDomain.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)fromDomain);
    }

    @RequestMapping(value={"/site/{name}/database/{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<org.appng.appngizer.model.Database> updateDatabaseConnection(@PathVariable(value="name") String name, @PathVariable(value="id") Integer id, @RequestBody Database database) {
        SiteImpl site = this.getSiteByName(name);
        if (null == site) {
            return this.notFound();
        }
        DatabaseConnection dbc = this.coreService.getDatabaseConnection(id, false);
        if (null == dbc) {
            return this.notFound();
        }
        org.appng.appngizer.model.Database.applyChanges((Database)database, (DatabaseConnection)dbc);
        this.databaseService.save(dbc);
        ResponseEntity updated = this.getDatabaseConnection(name, id);
        return this.ok(updated.getBody());
    }

    Logger logger() {
        return log;
    }
}

