/*
 * Decompiled with CFR 0.152.
 */
package org.appng.appngizer.controller;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.appng.appngizer.controller.ControllerBase;
import org.appng.appngizer.model.Application;
import org.appng.appngizer.model.Applications;
import org.appng.appngizer.model.xml.Link;
import org.appng.core.domain.ApplicationImpl;
import org.appng.core.domain.DatabaseConnection;
import org.appng.core.domain.SiteImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SiteApplicationController
extends ControllerBase {
    private static final Logger log = LoggerFactory.getLogger(SiteApplicationController.class);

    @RequestMapping(value={"/site/{site}/application"}, method={RequestMethod.GET})
    public ResponseEntity<Applications> listApplications(@PathVariable(value="site") String site) {
        SiteImpl siteByName = this.getSiteByName(site);
        ArrayList<Application> applicationList = new ArrayList<Application>();
        ArrayList sortedNames = new ArrayList(siteByName.getApplicationMap().keySet());
        Collections.sort(sortedNames);
        for (String appName : sortedNames) {
            ApplicationImpl application = (ApplicationImpl)siteByName.getApplication(appName);
            Application fromDomain = Application.fromDomain((ApplicationImpl)application, (String)site);
            fromDomain.addLinks();
            applicationList.add(fromDomain);
        }
        Applications applications = new Applications(applicationList);
        applications.setSelf("/site/" + site + "/application");
        applications.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)applications);
    }

    @RequestMapping(value={"/site/{site}/application/{app}"}, method={RequestMethod.GET})
    public ResponseEntity<Application> getApplication(@PathVariable(value="site") String site, @PathVariable(value="app") String app) {
        SiteImpl siteByName = this.getSiteByName(site);
        if (null == siteByName) {
            return this.notFound();
        }
        ApplicationImpl application = (ApplicationImpl)siteByName.getApplication(app);
        if (null == application) {
            return this.notFound();
        }
        Application fromDomain = Application.fromDomain((ApplicationImpl)application, (String)site);
        fromDomain.addLinks();
        DatabaseConnection dbc = this.getCoreService().getDatabaseConnection(siteByName, application);
        if (null != dbc) {
            fromDomain.addLink((Link)new org.appng.appngizer.model.Link("database", fromDomain.getSelf() + "/database"));
        }
        fromDomain.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)fromDomain);
    }

    @RequestMapping(value={"/site/{site}/application/{app}"}, method={RequestMethod.POST})
    public ResponseEntity<Void> activateApplication(@PathVariable(value="site") String site, @PathVariable(value="app") String app) {
        SiteImpl siteByName = this.getSiteByName(site);
        if (null == siteByName) {
            return this.notFound();
        }
        ApplicationImpl appByName = this.getApplicationByName(app);
        if (null == appByName) {
            return this.notFound();
        }
        boolean isAssigned = siteByName.getApplications().contains(appByName);
        if (isAssigned) {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.setAllow(new HashSet<HttpMethod>(Arrays.asList(HttpMethod.GET)));
            return this.reply(httpHeaders, HttpStatus.METHOD_NOT_ALLOWED);
        }
        this.getCoreService().assignApplicationToSite(siteByName, (org.appng.api.model.Application)appByName, true);
        URI location = this.getUriBuilder().path("/site/{site}/application/{app}").buildAndExpand(new Object[]{site, app}).toUri();
        return this.seeOther(location);
    }

    @RequestMapping(value={"/site/{site}/application/{app}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deactivateApplication(@PathVariable(value="site") String site, @PathVariable(value="app") String app) {
        SiteImpl siteByName = this.getSiteByName(site);
        if (null == siteByName) {
            return this.notFound();
        }
        ApplicationImpl appByName = (ApplicationImpl)siteByName.getApplication(app);
        if (null == appByName) {
            return this.notFound();
        }
        this.getCoreService().unlinkApplicationFromSite(siteByName.getId(), appByName.getId());
        URI location = this.getUriBuilder().path("/site/{site}/application").buildAndExpand(new Object[]{site}).toUri();
        return this.seeOther(location);
    }

    Logger logger() {
        return log;
    }
}

