/*
 * Decompiled with CFR 0.152.
 */
package org.appng.appngizer.controller;

import java.util.Collections;
import java.util.Map;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleState;
import org.appng.appngizer.controller.ControllerBase;
import org.appng.appngizer.model.Platform;
import org.appng.appngizer.model.Properties;
import org.appng.appngizer.model.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PlatformController
extends ControllerBase {
    private static final Logger log = LoggerFactory.getLogger(PlatformController.class);

    Logger logger() {
        return log;
    }

    @RequestMapping(value={"/platform"}, method={RequestMethod.GET})
    public ResponseEntity<Platform> showPlatform() {
        boolean dbInitialized = this.getDatabaseStatus() != null;
        boolean platformReloadAvailable = this.getAppNGContext() != null;
        Platform platform = new Platform(dbInitialized, platformReloadAvailable);
        platform.applyUriComponents(this.getUriBuilder());
        return this.ok((Object)platform);
    }

    @RequestMapping(value={"/platform/system"}, method={RequestMethod.GET})
    public ResponseEntity<Properties> listSystemProperties() {
        Properties response = this.mapProps((Map)System.getProperties());
        response.setSelf("/platform/system");
        return this.ok((Object)response);
    }

    @RequestMapping(value={"/platform/environment"}, method={RequestMethod.GET})
    public ResponseEntity<Properties> listEnvironment() {
        Properties response = this.mapProps(System.getenv());
        response.setSelf("/platform/environment");
        return this.ok((Object)response);
    }

    @RequestMapping(value={"/platform/reload"}, method={RequestMethod.POST})
    public ResponseEntity<Platform> reloadPlatform() {
        Context appNGContext = this.getAppNGContext();
        if (null == appNGContext) {
            this.logger().info("no appNG context found!");
            return this.notFound();
        }
        this.logger().info("reloading {}", (Object)appNGContext);
        appNGContext.reload();
        if (LifecycleState.STARTED.equals((Object)appNGContext.getState())) {
            return this.showPlatform();
        }
        return this.internalServerError();
    }

    protected Context getAppNGContext() {
        Host host = (Host)this.context.getAttribute("host");
        return (Context)host.findChild("");
    }

    protected Properties mapProps(Map<?, ?> properties) {
        Properties response = new Properties();
        for (Object key : properties.keySet()) {
            Property prop = new Property();
            prop.setName(key.toString());
            prop.setValue(properties.get((String)key).toString());
            response.getProperty().add(prop);
        }
        Collections.sort(response.getProperty(), new PropertyComparator("name", true, true));
        return response;
    }
}

