/*
 * Decompiled with CFR 0.152.
 */
package org.appng.appngizer.controller;

import java.net.URI;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.appng.api.BusinessException;
import org.appng.api.support.PropertyHolder;
import org.appng.appngizer.controller.AppNGizerConfigurer;
import org.appng.appngizer.model.xml.Nameable;
import org.appng.core.domain.ApplicationImpl;
import org.appng.core.domain.DatabaseConnection;
import org.appng.core.domain.SiteImpl;
import org.appng.core.service.CoreService;
import org.appng.core.service.DatabaseService;
import org.appng.core.service.TemplateService;
import org.flywaydb.core.api.MigrationInfo;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class ControllerBase {
    @Autowired
    ServletContext context;
    @Autowired
    HttpSession session;
    @Autowired
    CoreService coreService;
    @Autowired
    TemplateService templateService;
    @Autowired
    DatabaseService databaseService;
    @Autowired
    AppNGizerConfigurer configurer;
    @Autowired
    ApplicationContext appCtx;

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={BusinessException.class})
    public void onBusinessException(HttpServletRequest request, BusinessException e) {
        String message = String.format("%s error while processing [%s] %s", request.getSession().getId(), request.getMethod(), request.getServletPath());
        this.logger().error(message, (Throwable)e);
    }

    abstract Logger logger();

    CoreService getCoreService() {
        return this.coreService;
    }

    TemplateService getTemplateService() {
        return this.templateService;
    }

    ApplicationImpl getApplicationByName(String name) {
        return (ApplicationImpl)this.getCoreService().findApplicationByName(name);
    }

    SiteImpl getSiteByName(String name) {
        return this.getCoreService().getSiteByName(name);
    }

    boolean nameChanged(Nameable nameable, String name) {
        return !nameable.getName().equals(name);
    }

    UriComponentsBuilder getUriBuilder() {
        return ServletUriComponentsBuilder.fromCurrentContextPath();
    }

    <T> ResponseEntity<T> ok(T entity) {
        return new ResponseEntity(entity, HttpStatus.OK);
    }

    <T> ResponseEntity<T> notFound() {
        return this.reply(HttpStatus.NOT_FOUND);
    }

    <T> ResponseEntity<T> seeOther(URI location) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setLocation(location);
        return this.reply(httpHeaders, HttpStatus.SEE_OTHER);
    }

    <T> ResponseEntity<T> movedPermanently(URI location) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setLocation(location);
        return this.reply(httpHeaders, HttpStatus.MOVED_PERMANENTLY);
    }

    <T> ResponseEntity<T> created(T entity) {
        return this.reply(entity, HttpStatus.CREATED);
    }

    <T> ResponseEntity<T> conflict() {
        return this.reply(HttpStatus.CONFLICT);
    }

    <T> ResponseEntity<T> internalServerError() {
        return this.reply(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    <T> ResponseEntity<T> noContent(HttpHeaders headers) {
        return this.reply(headers, HttpStatus.NO_CONTENT);
    }

    <T> ResponseEntity<T> reply(HttpStatus status) {
        return new ResponseEntity(status);
    }

    <T> ResponseEntity<T> reply(HttpHeaders headers, HttpStatus status) {
        return new ResponseEntity((MultiValueMap)headers, status);
    }

    <T> ResponseEntity<T> reply(T entity, HttpStatus status) {
        return new ResponseEntity(entity, status);
    }

    protected MigrationInfo getDatabaseStatus() {
        DatabaseConnection platformConnection = this.databaseService.getPlatformConnection(this.configurer.getProps());
        return this.databaseService.statusComplete(platformConnection).current();
    }

    public String getSharedSecret() {
        PropertyHolder platformCfg = this.getCoreService().getPlatformProperties();
        return platformCfg.getString("sharedSecret");
    }
}

