/*
 * Decompiled with CFR 0.152.
 */
package org.apifocal.activemix.tools.ping;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.commons.lang3.RandomStringUtils;

public class Pinger {
    private final int DEFAULT_TTL = 120000;
    private final int DEFAULT_THROTTLE = 20;
    private final String url;
    private final String dn;
    private String user;
    private String pass;
    private ConnectionFactory factory;
    private Connection connection;
    private String data;
    private boolean async = false;
    private int interval = 0;
    private int count = 1;
    private int ttl = 120000;
    private int throttle = 20;
    private int rx = 0;
    private CountDownLatch counter = new CountDownLatch(1);
    private AtomicBoolean green = new AtomicBoolean(true);
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public Pinger(String url, String dn) {
        this.url = url;
        this.dn = dn + "." + RandomStringUtils.randomAlphabetic((int)6);
    }

    public Pinger credentials(String user, String password) {
        if (user != null && password != null && !user.isEmpty() && !password.isEmpty()) {
            this.user = user;
            this.pass = password;
        }
        return this;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void randomData(int length) {
        this.data = RandomStringUtils.randomAlphanumeric((int)length);
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setCount(int count) {
        this.count = count;
        this.counter = new CountDownLatch(this.count);
    }

    public void setTtl(int ttl) {
        this.ttl = ttl * 1000;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void noThrottle(boolean nothrottle) {
        if (nothrottle) {
            this.async = true;
            this.throttle = 0;
        }
    }

    public void start() throws Exception {
        this.factory = new ActiveMQConnectionFactory(this.url);
        this.connection = Pinger.createConnection(this.factory, this.user, this.pass);
        Session session = this.connection.createSession(false, 1);
        Destination d = Pinger.createDestination(session, this.dn);
        MessageConsumer consumer = session.createConsumer(d);
        consumer.setMessageListener(this.pingListener());
        this.connection.start();
    }

    public void run() throws Exception {
        final Session session = this.connection.createSession(false, 1);
        Destination d = Pinger.createDestination(session, this.dn);
        final MessageProducer producer = session.createProducer(d);
        producer.setTimeToLive((long)this.ttl);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    int tx = 0;
                    long delay = Pinger.this.interval > 0 ? (long)(Pinger.this.interval * 1000) : (long)Pinger.this.throttle;
                    tx = 0;
                    while (tx == 0 || !Pinger.this.counter.await(delay, TimeUnit.MILLISECONDS)) {
                        if (!Pinger.this.async && !Pinger.this.green.get()) continue;
                        Pinger.this.green.set(false);
                        TextMessage message = session.createTextMessage(Pinger.this.data);
                        message.setJMSTimestamp(System.currentTimeMillis());
                        producer.send((Message)message);
                        if (++tx < Pinger.this.count) continue;
                    }
                    System.out.println("Completed: " + tx + " messages sent");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.counter.await();
        System.out.println("Completed: " + this.rx + " messages received");
    }

    public void stop() throws Exception {
        this.executor.shutdown();
        this.connection.stop();
        this.connection.close();
    }

    protected MessageListener pingListener() {
        return new MessageListener(){

            public void onMessage(Message message) {
                try {
                    if (message instanceof TextMessage) {
                        long time = message.getJMSTimestamp();
                        System.out.printf("ping: destination=%s, size=%d bytes, time=%d ms\n", Pinger.this.dn, Pinger.this.data.length(), System.currentTimeMillis() - time);
                        Pinger.this.green.set(true);
                    }
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                Pinger.this.rx++;
                Pinger.this.counter.countDown();
            }
        };
    }

    protected static Connection createConnection(ConnectionFactory cf, String user, String pass) throws JMSException {
        return user != null && !user.isEmpty() ? cf.createConnection(user, pass) : cf.createConnection();
    }

    protected static Destination createDestination(Session s, String dn) throws JMSException {
        if (dn == null) {
            throw new IllegalArgumentException("Destination name cannot be 'null'");
        }
        if (dn.startsWith("queue:")) {
            dn = dn.substring("queue:".length());
            dn = Pinger.trimDoubleSlash(dn);
            return s.createQueue(Pinger.trimDoubleSlash(dn));
        }
        if (dn.startsWith("topic:")) {
            dn = dn.substring("topic:".length());
            dn = Pinger.trimDoubleSlash(dn);
            return s.createTopic(Pinger.trimDoubleSlash(dn));
        }
        return null;
    }

    protected static String trimDoubleSlash(String s) {
        return s.startsWith("//") ? s.substring("//".length()) : s;
    }
}

