/*
 * Decompiled with CFR 0.152.
 */
package org.apifocal.activemix.tools.ping;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apifocal.activemix.tools.ping.Pinger;

public class PingApp {
    private static final String DEFAULT_PING_DESTINATION = "queue://jms.ping";
    private static final Option OPTION_HELP = Option.builder((String)"h").longOpt("help").build();
    private static final Option OPTION_USER = Option.builder((String)"u").longOpt("user").desc("User for JMS connection").hasArg(true).argName("user").build();
    private static final Option OPTION_PASS = Option.builder((String)"p").longOpt("password").desc("Password for JMS connection").hasArg(true).argName("pass").build();
    private static final Option OPTION_LEN = Option.builder((String)"l").longOpt("length").desc("Send message of 'len' bytes with random content").hasArg(true).argName("len").build();
    private static final Option OPTION_COUNT = Option.builder((String)"c").desc("Stop after sending 'count' messages.").hasArg(true).argName("count").build();
    private static final Option OPTION_INTERVAL = Option.builder((String)"i").desc("Wait 'interval' seconds between sending messages").hasArg(true).argName("interval").build();
    private static final Option OPTION_ASYNC = Option.builder((String)"a").longOpt("async").desc("Send next ping before receiving reply").hasArg(false).build();
    private static final Option OPTION_NOTHROTTLE = Option.builder().longOpt("no-throttle").desc("[NO HELP] Saturate broker; use with care!").build();
    private static final Option OPTION_TTL = Option.builder().longOpt("ttl").desc("[NO HELP] Message expiration time").hasArg(true).argName("ttl").build();
    private static final Options OPTIONS = new Options();
    private static final Option[] OPTIONS_LIST = new Option[]{OPTION_HELP, OPTION_USER, OPTION_PASS, OPTION_LEN, OPTION_COUNT, OPTION_INTERVAL, OPTION_ASYNC, OPTION_NOTHROTTLE, OPTION_TTL};
    private static final String OPTIONS_FOOTER = "\n broker-url             JMS connection URL\n destination            JMS destination (either queue or topic) as url\n                        (e.g. \"queue://queue.name\" \"topic://topic.name\")\n                        default: \"queue://jms.ping.<random>\"\n\nFor more information visit https://docs.silkmq.com";

    public static void main(String[] args) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
            }
        });
        CommandLine cli = null;
        try {
            boolean missingArgs;
            cli = PingApp.parse(args);
            boolean bl = missingArgs = cli.getArgList().size() < 1 || cli.getArgList().size() > 2;
            if (missingArgs && !cli.hasOption("h")) {
                throw new ParseException("Missing provider url");
            }
        }
        catch (ParseException e) {
            PingApp.usage(e.getLocalizedMessage());
            return;
        }
        if (cli.hasOption("h")) {
            PingApp.help(System.out);
            return;
        }
        List params = cli.getArgList();
        String dn = params.size() > 1 ? (String)params.get(1) : DEFAULT_PING_DESTINATION;
        Pinger pinger = new Pinger((String)params.get(0), dn);
        pinger.credentials(cli.getOptionValue("u"), cli.getOptionValue("p"));
        int len = 100;
        if (cli.hasOption("l")) {
            len = Integer.parseInt(cli.getOptionValue("l"));
        }
        pinger.randomData(len);
        if (cli.hasOption("c")) {
            pinger.setCount(Integer.parseInt(cli.getOptionValue("c")));
        }
        if (cli.hasOption("i")) {
            pinger.setInterval(Integer.parseInt(cli.getOptionValue("i")));
        }
        if (cli.hasOption("ttl")) {
            pinger.setTtl(Integer.parseInt(cli.getOptionValue("ttl")));
        }
        pinger.setAsync(cli.hasOption("a"));
        pinger.noThrottle(cli.hasOption("no-throttle"));
        try {
            pinger.start();
            pinger.run();
            pinger.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static CommandLine parse(String[] args) throws ParseException {
        DefaultParser parser = new DefaultParser();
        return parser.parse(OPTIONS, args);
    }

    public static void usage() {
        PingApp.usage(null);
    }

    public static void usage(String message) {
        if (message != null && !message.isEmpty()) {
            System.out.println(message);
        }
        PingApp.help(System.out);
    }

    private static void help(PrintStream out) {
        out.println();
        PrintWriter pw = new PrintWriter(out);
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator((Comparator)new CustomComparator());
        formatter.printHelp(pw, 74, "amx-ping [options] <broker-url> [destination]", "\nOptions:", PingApp.filterOptions(OPTIONS), 1, 3, OPTIONS_FOOTER, false);
        pw.flush();
    }

    private static Options filterOptions(Options options) {
        Options result = new Options();
        options.getOptions().forEach(o -> {
            String desc = o.getDescription();
            if (desc == null || !o.getDescription().startsWith("[NO HELP]")) {
                result.addOption(o);
            }
        });
        return result;
    }

    static {
        Arrays.asList(OPTIONS_LIST).forEach(o -> OPTIONS.addOption(o));
    }

    private static class CustomComparator
    implements Comparator<Option>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private CustomComparator() {
        }

        @Override
        public int compare(Option o1, Option o2) {
            return this.index(o1.getId()) - this.index(o2.getId());
        }

        private int index(int opt) {
            int result = 0;
            switch (opt) {
                case 104: {
                    result = 1;
                    break;
                }
                case 117: {
                    result = 2;
                    break;
                }
                case 112: {
                    result = 3;
                    break;
                }
                case 108: {
                    result = 4;
                    break;
                }
                case 99: {
                    result = 5;
                    break;
                }
                case 105: {
                    result = 6;
                    break;
                }
                case 97: {
                    result = 7;
                    break;
                }
                default: {
                    result = 16;
                }
            }
            return result;
        }
    }
}

