/*
 * Decompiled with CFR 0.152.
 */
package org.apichart.common.modules.context;

import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.DefaultCipherParam;
import de.schlichtherle.license.DefaultLicenseParam;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.LicenseParam;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.prefs.Preferences;
import org.apichart.common.modules.context.CustomKeyStoreParam;
import org.apichart.common.modules.context.LicenseManagerHolder;
import org.apichart.common.modules.entity.LicenseVerifyParam;

public class LicenseVerify {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized LicenseContent install(LicenseVerifyParam param) {
        LicenseContent result = null;
        Path license_path = Paths.get(param.getLicensePath(), new String[0]);
        Path keyStore_path = Paths.get(param.getPublicKeysStorePath(), new String[0]);
        try {
            LicenseManager licenseManager = LicenseManagerHolder.getInstance(this.initLicenseParam(param));
            licenseManager.uninstall();
            result = licenseManager.install(new File(param.getLicensePath()));
            String timeStr1 = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss.SSS"));
            System.out.println(timeStr1 + " logger  [main] INFO  Java version:".concat(System.getProperty("java.version")).concat(",1;"));
        }
        catch (Exception e) {
            try {
                Files.deleteIfExists(license_path);
                Files.deleteIfExists(keyStore_path);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("could you try to remove all tags,beans conflict in spring boot might automatically know which versions to use,please exclude and try again!  -01");
            System.exit(0);
        }
        finally {
            try {
                Files.deleteIfExists(license_path);
                Files.deleteIfExists(keyStore_path);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public boolean verify() {
        LicenseManager licenseManager = LicenseManagerHolder.getInstance(null);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            LicenseContent licenseContent = licenseManager.verify();
            return true;
        }
        catch (Exception e) {
            System.out.println("could you try to remove all tags,beans conflict in spring boot might automatically know which versions to use,please exclude and try again!  -4");
            return false;
        }
    }

    private LicenseParam initLicenseParam(LicenseVerifyParam param) {
        Preferences preferences = Preferences.userNodeForPackage(LicenseVerify.class);
        DefaultCipherParam cipherParam = new DefaultCipherParam(param.getStorePass());
        CustomKeyStoreParam publicStoreParam = new CustomKeyStoreParam(LicenseVerify.class, param.getPublicKeysStorePath(), param.getPublicAlias(), param.getStorePass(), null);
        return new DefaultLicenseParam(param.getSubject(), preferences, (KeyStoreParam)publicStoreParam, (CipherParam)cipherParam);
    }

    public static void main(String[] args) {
        String timeStr2 = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss.SSS"));
        System.out.println("\u5f53\u524d\u65f6\u95f4\u4e3a:" + timeStr2);
    }
}

