/*
 * Decompiled with CFR 0.152.
 */
package org.apichart.common;

import java.io.File;
import java.io.IOException;
import org.apichart.common.modules.context.LicenseVerify;
import org.apichart.common.modules.entity.LicenseVerifyParam;
import org.apichart.common.modules.origin.HttpServer;
import org.apichart.common.modules.util.BaseUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class AbstractApplicationRunListener
implements SpringApplicationRunListener {
    private final SpringApplication application;
    private final String[] args;
    private final String fp = File.separator;
    private String user_root = System.getProperty("user.dir").concat(this.fp);
    private String source_kyscert_dir = "/certs/pdp_public_certs.keystore";
    private String cert_file = "pdp_certs.keystore";
    private String source_license_dir = "/certs/Apache-2.0.lic";
    private String license_file = "Apache-2.0.lic";
    private String tmp_dir = this.user_root.concat("tmp").concat(this.fp);

    public AbstractApplicationRunListener(SpringApplication sa, String[] args) {
        this.application = sa;
        this.args = args;
    }

    public void starting() {
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
    }

    public void contextPrepared(ConfigurableApplicationContext context) {
        LicenseVerifyParam param = new LicenseVerifyParam();
        BaseUtils utils = new BaseUtils();
        String private_license_path = utils.InputStreamAsSave(this.source_license_dir, this.tmp_dir, this.license_file);
        String public_keysStore_path = utils.InputStreamAsSave(this.source_kyscert_dir, this.tmp_dir, this.cert_file);
        try {
            param.setSubject("pdp_license_local");
            param.setPublicAlias("pdp_public_cert");
            param.setStorePass("public_pswd8353");
            param.setLicensePath(private_license_path);
            param.setPublicKeysStorePath(public_keysStore_path);
        }
        catch (Exception e) {
            System.out.println("could you try to remove all tags,beans conflict in spring boot might automatically know which versions to use,please exclude and try again!  0");
            System.exit(0);
        }
        LicenseVerify licenseVerify = new LicenseVerify();
        licenseVerify.install(param);
    }

    public void contextLoaded(ConfigurableApplicationContext context) {
    }

    public void failed(ConfigurableApplicationContext context, Throwable exception) {
    }

    public void started(ConfigurableApplicationContext context) {
        try {
            new HttpServer();
            System.out.println("published root WebApplicationContext as Servlet http service exec with classes [HTTPD]");
        }
        catch (IOException ioe) {
            System.out.println("couldn't start server:" + ioe.getMessage());
        }
    }

    public void running(ConfigurableApplicationContext context) {
    }
}

