/*
 * Decompiled with CFR 0.152.
 */
package org.apichart.common.modules.context;

import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseContentException;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.LicenseNotary;
import de.schlichtherle.license.LicenseParam;
import de.schlichtherle.license.NoLicenseInstalledException;
import de.schlichtherle.xml.GenericCertificate;
import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apichart.common.modules.context.AbstractServerInfos;
import org.apichart.common.modules.context.LinuxServerInfos;
import org.apichart.common.modules.context.WindowsServerInfos;
import org.apichart.common.modules.entity.LicenseCheckModel;

public class CustomLicenseManager
extends LicenseManager {
    private static final String XML_CHARSET = "UTF-8";
    private static final int DEFAULT_BUFSIZE = 8192;

    public CustomLicenseManager() {
    }

    public CustomLicenseManager(LicenseParam param) {
        super(param);
    }

    protected synchronized byte[] create(LicenseContent content, LicenseNotary notary) throws Exception {
        this.initialize(content);
        this.validateCreate(content);
        GenericCertificate certificate = notary.sign((Object)content);
        return this.getPrivacyGuard().cert2key(certificate);
    }

    protected synchronized LicenseContent install(byte[] key, LicenseNotary notary) throws Exception {
        GenericCertificate certificate = this.getPrivacyGuard().key2cert(key);
        notary.verify(certificate);
        LicenseContent content = (LicenseContent)this.load(certificate.getEncoded());
        this.validate(content);
        this.setLicenseKey(key);
        this.setCertificate(certificate);
        return content;
    }

    protected synchronized LicenseContent verify(LicenseNotary notary) throws Exception {
        GenericCertificate certificate = this.getCertificate();
        byte[] key = this.getLicenseKey();
        if (null == key) {
            throw new NoLicenseInstalledException(this.getLicenseParam().getSubject());
        }
        certificate = this.getPrivacyGuard().key2cert(key);
        notary.verify(certificate);
        LicenseContent content = (LicenseContent)this.load(certificate.getEncoded());
        this.validate(content);
        this.setCertificate(certificate);
        return content;
    }

    protected synchronized void validateCreate(LicenseContent content) throws LicenseContentException {
        LicenseParam param = this.getLicenseParam();
        Date now = new Date();
        Date notBefore = content.getNotBefore();
        Date notAfter = content.getNotAfter();
        if (null != notAfter && now.after(notAfter)) {
            throw new LicenseContentException("could you try to remove all tags,beans conflict in spring boot might automatically know which versions to use,please exclude and try again!  -5");
        }
        if (null != notBefore && null != notAfter && notAfter.before(notBefore)) {
            throw new LicenseContentException("could you try to remove all tags,beans conflict in spring boot might automatically know which versions to use,please exclude and try again!  -6");
        }
        String consumerType = content.getConsumerType();
        if (null == consumerType) {
            throw new LicenseContentException("could you try to remove all tags,beans conflict in spring boot might automatically know which versions to use,please exclude and try again!  -7");
        }
    }

    protected synchronized void validate(LicenseContent content) throws LicenseContentException {
        super.validate(content);
        LicenseCheckModel expectedCheckModel = (LicenseCheckModel)content.getExtra();
        if (expectedCheckModel != null) {
            LicenseCheckModel serverCheckModel = this.getServerInfos();
            if (serverCheckModel != null) {
                if (!this.checkIpAddress(expectedCheckModel.getIpAddress(), serverCheckModel.getIpAddress())) {
                    throw new LicenseContentException("could you try to remove all tags,beans conflict in spring boot might automatically know which versions to use,please exclude and try again!  -8");
                }
                if (!this.checkIpAddress(expectedCheckModel.getMacAddress(), serverCheckModel.getMacAddress())) {
                    throw new LicenseContentException("could you try to remove all tags,beans conflict in spring boot might automatically know which versions to use,please exclude and try again!  -9");
                }
                if (!this.checkSerial(expectedCheckModel.getMainBoardSerial(), serverCheckModel.getMainBoardSerial())) {
                    throw new LicenseContentException("could you try to remove all tags,beans conflict in spring boot might automatically know which versions to use,please exclude and try again!  -10");
                }
                if (!this.checkSerial(expectedCheckModel.getCpuSerial(), serverCheckModel.getCpuSerial())) {
                    throw new LicenseContentException("could you try to remove all tags,beans conflict in spring boot might automatically know which versions to use,please exclude and try again!  -11");
                }
            } else {
                throw new LicenseContentException("could you try to remove all tags,beans conflict in spring boot might automatically know which versions to use,please exclude and try again!  -12");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object load(String encoded) {
        BufferedInputStream inputStream = null;
        XMLDecoder decoder = null;
        try {
            inputStream = new BufferedInputStream(new ByteArrayInputStream(encoded.getBytes(XML_CHARSET)));
            decoder = new XMLDecoder(new BufferedInputStream(inputStream, 8192), null, null);
            Object object = decoder.readObject();
            return object;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (decoder != null) {
                    decoder.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                System.out.println("could you try to remove all tags,beans conflict in spring boot might automatically know which versions to use,please exclude and try again!  -13");
            }
        }
        return null;
    }

    private LicenseCheckModel getServerInfos() {
        String osName = System.getProperty("os.name").toLowerCase();
        AbstractServerInfos abstractServerInfos = null;
        abstractServerInfos = osName.startsWith("windows") ? new WindowsServerInfos() : (osName.startsWith("linux") ? new LinuxServerInfos() : new LinuxServerInfos());
        return abstractServerInfos.getServerInfos();
    }

    private boolean checkIpAddress(List<String> expectedList, List<String> serverList) {
        if (expectedList != null && expectedList.size() > 0) {
            if (serverList != null && serverList.size() > 0) {
                for (String expected : expectedList) {
                    if (!serverList.contains(expected.trim())) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean checkSerial(String expectedSerial, String serverSerial) {
        if (StringUtils.isNotBlank((CharSequence)expectedSerial)) {
            return StringUtils.isNotBlank((CharSequence)serverSerial) && expectedSerial.equals(serverSerial);
        }
        return true;
    }
}

