/*
 * Decompiled with CFR 0.152.
 */
package org.apichart.common.modules.context;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apichart.common.modules.entity.LicenseCheckModel;

public abstract class AbstractServerInfos {
    public LicenseCheckModel getServerInfos() {
        LicenseCheckModel result = new LicenseCheckModel();
        try {
            result.setIpAddress(this.getIpAddress());
            result.setMacAddress(this.getMacAddress());
            result.setCpuSerial(this.getCPUSerial());
            result.setMainBoardSerial(this.getMainBoardSerial());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected abstract List<String> getIpAddress() throws Exception;

    protected abstract List<String> getMacAddress() throws Exception;

    protected abstract String getCPUSerial() throws Exception;

    protected abstract String getMainBoardSerial() throws Exception;

    protected List<InetAddress> getLocalAllInetAddress() throws Exception {
        ArrayList<InetAddress> result = new ArrayList<InetAddress>(4);
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface iface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = iface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddr = inetAddresses.nextElement();
                if (inetAddr.isLoopbackAddress() || inetAddr.isLinkLocalAddress() || inetAddr.isMulticastAddress()) continue;
                result.add(inetAddr);
            }
        }
        return result;
    }

    protected String getMacByInetAddress(InetAddress inetAddr) {
        try {
            byte[] mac = NetworkInterface.getByInetAddress(inetAddr).getHardwareAddress();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < mac.length; ++i) {
                String temp;
                if (i != 0) {
                    stringBuffer.append("-");
                }
                if ((temp = Integer.toHexString(mac[i] & 0xFF)).length() == 1) {
                    stringBuffer.append("0" + temp);
                    continue;
                }
                stringBuffer.append(temp);
            }
            return stringBuffer.toString().toUpperCase();
        }
        catch (SocketException e) {
            e.printStackTrace();
            System.out.println("\u83b7\u53d6\u67d0\u4e2a\u7f51\u7edc\u63a5\u53e3\u7684Mac\u5730\u5740\u5f02\u5e38" + e.getMessage());
            return null;
        }
    }
}

