/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.batik.test.AssertEqualsException;
import org.apache.batik.test.AssertNullException;
import org.apache.batik.test.AssertTrueException;
import org.apache.batik.test.DefaultTestReport;
import org.apache.batik.test.Messages;
import org.apache.batik.test.Test;
import org.apache.batik.test.TestErrorConditionException;
import org.apache.batik.test.TestReport;
import org.apache.batik.test.TestSuite;

public abstract class AbstractTest
implements Test {
    protected String id = "";
    protected TestSuite parent;
    protected String name;
    private DefaultTestReport report = new DefaultTestReport(this){
        {
            this.setErrorCode("TestReport.error.internal.test.failure");
            this.setPassed(false);
        }
    };

    @Override
    public String getName() {
        if (this.name == null) {
            if (this.id != null && !"".equals(this.id)) {
                return this.id;
            }
            return this.getClass().getName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getQualifiedId() {
        if (this.parent == null) {
            return this.getId();
        }
        return this.getParent().getQualifiedId() + "." + this.getId();
    }

    @Override
    public void setId(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
    }

    @Override
    public TestSuite getParent() {
        return this.parent;
    }

    @Override
    public void setParent(TestSuite parent) {
        this.parent = parent;
    }

    @Override
    public TestReport run() {
        try {
            return this.runImpl();
        }
        catch (TestErrorConditionException e) {
            return e.getTestReport(this);
        }
        catch (Exception e) {
            try {
                StringWriter trace = new StringWriter();
                e.printStackTrace(new PrintWriter(trace));
                TestReport.Entry[] entries = new TestReport.Entry[]{new TestReport.Entry(Messages.formatMessage("TestReport.entry.key.internal.test.failure.exception.class", null), e.getClass().getName()), new TestReport.Entry(Messages.formatMessage("TestReport.entry.key.internal.test.failure.exception.message", null), e.getMessage()), new TestReport.Entry(Messages.formatMessage("TestReport.entry.key.internal.test.failure.exception.stack.trace", null), trace.toString())};
                this.report.setDescription(entries);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            e.printStackTrace();
            System.out.println("SERIOUS ERROR");
            return this.report;
        }
    }

    public TestReport runImpl() throws Exception {
        boolean passed = this.runImplBasic();
        DefaultTestReport report = new DefaultTestReport(this);
        if (!passed) {
            report.setErrorCode("TestReport.error.test.failed");
        }
        report.setPassed(passed);
        return report;
    }

    public boolean runImplBasic() throws Exception {
        return true;
    }

    public TestReport reportSuccess() {
        DefaultTestReport report = new DefaultTestReport(this);
        report.setPassed(true);
        return report;
    }

    public TestReport reportError(String errorCode) {
        DefaultTestReport report = new DefaultTestReport(this);
        report.setErrorCode(errorCode);
        report.setPassed(false);
        return report;
    }

    public void error(String errorCode) throws TestErrorConditionException {
        throw new TestErrorConditionException(errorCode);
    }

    public void assertNull(Object ref) throws AssertNullException {
        if (ref != null) {
            throw new AssertNullException();
        }
    }

    public void assertTrue(boolean b) throws AssertTrueException {
        if (!b) {
            throw new AssertTrueException();
        }
    }

    public void assertEquals(Object ref, Object cmp) throws AssertEqualsException {
        if (ref == null && cmp != null) {
            throw new AssertEqualsException(ref, cmp);
        }
        if (ref != null && !ref.equals(cmp)) {
            throw new AssertEqualsException(ref, cmp);
        }
    }

    public void assertEquals(int ref, int cmp) throws AssertEqualsException {
        this.assertEquals(new Integer(ref), new Integer(cmp));
    }

    public TestReport reportException(String errorCode, Exception e) {
        DefaultTestReport report = new DefaultTestReport(this);
        StringWriter trace = new StringWriter();
        e.printStackTrace(new PrintWriter(trace));
        report.setErrorCode(errorCode);
        TestReport.Entry[] entries = new TestReport.Entry[]{new TestReport.Entry(Messages.formatMessage("TestReport.entry.key.reported.test.failure.exception.class", null), e.getClass().getName()), new TestReport.Entry(Messages.formatMessage("TestReport.entry.key.reported.test.failure.exception.message", null), e.getMessage()), new TestReport.Entry(Messages.formatMessage("TestReport.entry.key.reported.test.failure.exception.stack.trace", null), trace.toString())};
        report.setDescription(entries);
        report.setPassed(false);
        return report;
    }
}

