/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.docpath;

import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import org.apache.ws.commons.schema.docpath.XmlSchemaDocumentNode;
import org.apache.ws.commons.schema.docpath.XmlSchemaPathNode;
import org.apache.ws.commons.schema.docpath.XmlSchemaStateMachineNode;

final class XmlSchemaPathManager<U, V> {
    private ArrayList<XmlSchemaPathNode<U, V>> unusedPathNodes = new ArrayList();
    private ArrayList<XmlSchemaDocumentNode<U>> unusedDocNodes = new ArrayList();

    XmlSchemaPathManager() {
    }

    XmlSchemaPathNode<U, V> createStartPathNode(XmlSchemaPathNode.Direction direction, XmlSchemaStateMachineNode state) {
        return this.createPathNode(direction, null, state);
    }

    XmlSchemaPathNode<U, V> addParentSiblingOrContentNodeToPath(XmlSchemaPathNode<U, V> startNode, XmlSchemaPathNode.Direction direction) {
        XmlSchemaDocumentNode<U> position = startNode.getDocumentNode();
        switch (direction) {
            case PARENT: {
                if (position != null) {
                    position = position.getParent();
                }
            }
            case SIBLING: 
            case CONTENT: {
                if (position != null) break;
                throw new IllegalStateException("When calling addParentSiblingOrContentNodeToPath(), the startNode's document node (and its parent) cannot be null.");
            }
            default: {
                throw new IllegalStateException("This method cannot be called if following a child.  Use addChildNodeToPath(startNode, direction, stateIndex).");
            }
        }
        XmlSchemaPathNode<U, V> node = null;
        if (!this.unusedPathNodes.isEmpty()) {
            node = this.unusedPathNodes.remove(this.unusedPathNodes.size() - 1);
            node.update(direction, startNode, position);
        } else {
            node = new XmlSchemaPathNode<U, V>(direction, startNode, position);
        }
        if (direction.equals((Object)XmlSchemaPathNode.Direction.SIBLING)) {
            node.setIteration(position.getIteration() + 1);
        } else {
            node.setIteration(position.getIteration());
        }
        return node;
    }

    XmlSchemaPathNode<U, V> addChildNodeToPath(XmlSchemaPathNode<U, V> startNode, int branchIndex) {
        XmlSchemaStateMachineNode stateMachine = startNode.getStateMachineNode();
        if (stateMachine.getPossibleNextStates() == null) {
            throw new IllegalStateException("Cannot follow the branch index; no possible next states.");
        }
        if (stateMachine.getPossibleNextStates().size() <= branchIndex) {
            throw new IllegalArgumentException("Cannot follow the branch index; branch " + branchIndex + " was requested when there are only " + stateMachine.getPossibleNextStates().size() + " branches to follow.");
        }
        XmlSchemaPathNode<U, V> next = this.createPathNode(XmlSchemaPathNode.Direction.CHILD, startNode, stateMachine.getPossibleNextStates().get(branchIndex));
        XmlSchemaDocumentNode<U> docNode = startNode.getDocumentNode();
        if (startNode.getDocumentNode() != null && docNode.getChildren(startNode.getIteration()) != null && docNode.getChildren().containsKey(branchIndex)) {
            next.setDocumentNode((XmlSchemaDocumentNode)docNode.getChildren(startNode.getIteration()).get(branchIndex));
            next.setIteration(next.getDocIteration() + 1);
        } else {
            next.setIteration(1);
        }
        return next;
    }

    void recyclePathNode(XmlSchemaPathNode<U, V> toRecycle) {
        if (toRecycle.getPrevious() != null) {
            toRecycle.getPrevious().setNextNode(-1, null);
            toRecycle.setPreviousNode(null);
        }
        if (toRecycle.getNext() != null) {
            this.recyclePathNode(toRecycle.getNext());
        }
        this.unusedPathNodes.add(toRecycle);
    }

    XmlSchemaPathNode<U, V> clone(XmlSchemaPathNode<U, V> original) {
        XmlSchemaPathNode<U, V> clone = this.createPathNode(original.getDirection(), original.getPrevious(), original.getStateMachineNode());
        clone.setIteration(original.getIteration());
        if (original.getDocumentNode() != null) {
            clone.setDocumentNode(original.getDocumentNode());
        }
        return clone;
    }

    void followPath(XmlSchemaPathNode<U, V> startNode) {
        if (startNode.getDocumentNode() == null) {
            if (!startNode.getDirection().equals((Object)XmlSchemaPathNode.Direction.CHILD)) {
                throw new IllegalStateException("The startNode may only have a null XmlSchemaDocumentNode if it represents the root node, and likewise its only valid direction is CHILD, not " + (Object)((Object)startNode.getDirection()));
            }
            XmlSchemaDocumentNode<U> rootDoc = this.createDocumentNode(null, startNode.getStateMachineNode());
            startNode.setDocumentNode(rootDoc);
            rootDoc.addVisitor(startNode);
        }
        XmlSchemaPathNode<U, V> prev = startNode;
        for (XmlSchemaPathNode<U, V> iter = prev.getNext(); iter != null; iter = iter.getNext()) {
            if (iter.getDocumentNode() == null) {
                if (!iter.getDirection().equals((Object)XmlSchemaPathNode.Direction.CHILD)) {
                    throw new IllegalStateException("XmlSchemaPathNode has a direction of " + (Object)((Object)iter.getDirection()) + " but it does not have an XmlSchemaDocumentNode to represent" + " its state machine (" + iter.getStateMachineNode() + ").");
                }
                XmlSchemaDocumentNode<U> newDocNode = this.createDocumentNode(prev.getDocumentNode(), iter.getStateMachineNode());
                iter.setDocumentNode(newDocNode);
                SortedMap<Integer, XmlSchemaDocumentNode<U>> siblings = prev.getDocumentNode().getChildren();
                if (prev.getIndexOfNextNodeState() < 0) {
                    throw new IllegalStateException("Creating a new document node for a node represented by " + iter.getStateMachineNode() + " but its previous state does not know how to reach me.");
                }
                siblings.put(prev.getIndexOfNextNodeState(), iter.getDocumentNode());
            }
            switch (iter.getDirection()) {
                case SIBLING: 
                case CHILD: {
                    iter.getDocumentNode().addVisitor(iter);
                    break;
                }
            }
            if (iter.getIteration() != iter.getDocIteration()) {
                throw new IllegalStateException("The current path node (representing " + iter.getStateMachineNode() + ") has an iteration of " + iter.getIteration() + ", which does not match the document node iteration of " + iter.getDocIteration() + '.');
            }
            prev = iter;
        }
    }

    void unfollowPath(XmlSchemaPathNode<U, V> startNode) {
        XmlSchemaPathNode<U, V> iter;
        XmlSchemaPathNode<U, V> prev = null;
        for (iter = startNode; iter != null; iter = iter.getNext()) {
            prev = iter;
        }
        while (prev != startNode) {
            iter = prev;
            prev = iter.getPrevious();
            if (iter.getDocumentNode() != null) {
                iter.getDocumentNode().removeVisitor(iter);
                if (iter.getDocIteration() == 0) {
                    this.recycleDocumentNode(iter.getDocumentNode());
                }
            }
            this.recyclePathNode(iter);
        }
    }

    void clear() {
        this.unusedPathNodes.clear();
        this.unusedDocNodes.clear();
    }

    private XmlSchemaPathNode<U, V> createPathNode(XmlSchemaPathNode.Direction direction, XmlSchemaPathNode<U, V> previous, XmlSchemaStateMachineNode state) {
        if (!this.unusedPathNodes.isEmpty()) {
            XmlSchemaPathNode<U, V> node = this.unusedPathNodes.remove(this.unusedPathNodes.size() - 1);
            node.update(direction, previous, state);
            return node;
        }
        return new XmlSchemaPathNode<U, V>(direction, previous, state);
    }

    private XmlSchemaDocumentNode<U> createDocumentNode(XmlSchemaDocumentNode<U> parent, XmlSchemaStateMachineNode state) {
        if (!this.unusedDocNodes.isEmpty()) {
            XmlSchemaDocumentNode<U> node = this.unusedDocNodes.remove(this.unusedDocNodes.size() - 1);
            node.set(parent, state);
            return node;
        }
        return new XmlSchemaDocumentNode<U>(parent, state);
    }

    void recycleDocumentNode(XmlSchemaDocumentNode<U> node) {
        if (node.getParent() != null) {
            SortedMap<Integer, XmlSchemaDocumentNode<U>> siblings = node.getParent().getChildren();
            for (Map.Entry entry : siblings.entrySet()) {
                if (entry.getValue() != node) continue;
                siblings.remove(entry.getKey());
                break;
            }
            if (node.getChildren() != null) {
                for (Map.Entry<Object, Object> entry : node.getChildren().entrySet()) {
                    this.recycleDocumentNode((XmlSchemaDocumentNode)entry.getValue());
                }
            }
        }
        this.unusedDocNodes.add(node);
    }
}

