/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.docpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import javax.xml.bind.ValidationException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.docpath.XmlSchemaDocumentNode;
import org.apache.ws.commons.schema.docpath.XmlSchemaElementValidator;
import org.apache.ws.commons.schema.docpath.XmlSchemaNamespaceContext;
import org.apache.ws.commons.schema.docpath.XmlSchemaPathManager;
import org.apache.ws.commons.schema.docpath.XmlSchemaPathNode;
import org.apache.ws.commons.schema.docpath.XmlSchemaStateMachineNode;
import org.apache.ws.commons.schema.walker.XmlSchemaTypeInfo;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlSchemaPathFinder<U, V>
extends DefaultHandler {
    private static final int MAX_DEPTH = 256;
    private final XmlSchemaNamespaceContext nsContext;
    private XmlSchemaPathNode<U, V> rootPathNode;
    private XmlSchemaPathNode<U, V> currentPath;
    private ArrayList<TraversedElement> traversedElements;
    private ArrayList<DecisionPoint<U, V>> decisionPoints;
    private ArrayList<QName> elementStack;
    private ArrayList<QName> anyStack;
    private XmlSchemaPathManager<U, V> pathMgr = new XmlSchemaPathManager();

    public XmlSchemaPathFinder(XmlSchemaStateMachineNode root) {
        this.nsContext = new XmlSchemaNamespaceContext();
        this.rootPathNode = this.pathMgr.createStartPathNode(XmlSchemaPathNode.Direction.CHILD, root);
        this.rootPathNode.setIteration(1);
        this.traversedElements = new ArrayList();
        this.elementStack = new ArrayList();
        this.currentPath = null;
        this.decisionPoints = null;
    }

    @Override
    public void startDocument() throws SAXException {
        this.currentPath = null;
        this.traversedElements.clear();
        this.elementStack.clear();
        if (this.decisionPoints != null) {
            this.decisionPoints.clear();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.nsContext.addNamespace(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.nsContext.removeNamespace(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        QName elemQName = new QName(uri, localName);
        try {
            if (this.currentPath == null) {
                this.currentPath = this.rootPathNode;
            } else if (this.currentPath.getStateMachineNode().getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ANY) && this.anyStack != null && !this.anyStack.isEmpty()) {
                this.elementStack.add(elemQName);
                this.anyStack.add(elemQName);
                return;
            }
            List<PathSegment<U, V>> possiblePaths = this.find(this.currentPath, elemQName);
            PathSegment<U, V> nextPath = null;
            if (possiblePaths != null && !possiblePaths.isEmpty()) {
                if (possiblePaths.size() > 1) {
                    DecisionPoint<U, V> decisionPoint = new DecisionPoint<U, V>(this.currentPath, possiblePaths, this.traversedElements.size(), this.elementStack, this.anyStack);
                    if (this.decisionPoints == null) {
                        this.decisionPoints = new ArrayList(4);
                    }
                    this.decisionPoints.add(decisionPoint);
                    nextPath = decisionPoint.tryNextPath();
                } else {
                    nextPath = possiblePaths.get(0);
                }
                if (nextPath == null) {
                    throw new IllegalStateException("When searching for " + elemQName + ", received a set of path choices of size " + possiblePaths.size() + ", but the next path is null.");
                }
                this.followPath(nextPath);
            } else {
                while (this.decisionPoints != null && !this.decisionPoints.isEmpty()) {
                    int index;
                    DecisionPoint<U, V> priorPoint = this.decisionPoints.get(this.decisionPoints.size() - 1);
                    nextPath = priorPoint.tryNextPath();
                    if (nextPath == null) {
                        this.decisionPoints.remove(this.decisionPoints.size() - 1);
                        continue;
                    }
                    this.pathMgr.unfollowPath(priorPoint.getDecisionPoint());
                    this.elementStack = priorPoint.getElementStack();
                    this.anyStack = priorPoint.getAnyStack();
                    this.followPath(nextPath);
                    QName traversedQName = this.traversedElements.get((int)((DecisionPoint)priorPoint).traversedElementIndex).elemName;
                    this.elementStack.add(traversedQName);
                    if (this.currentPath.getStateMachineNode().getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ANY)) {
                        if (this.anyStack == null) {
                            this.anyStack = new ArrayList();
                        }
                        this.anyStack.add(traversedQName);
                    }
                    for (index = ((DecisionPoint)priorPoint).traversedElementIndex + 1; index < this.traversedElements.size(); ++index) {
                        nextPath = null;
                        TraversedElement te = this.traversedElements.get(index);
                        if (te.traversal.equals((Object)TraversedElement.Traversal.START)) {
                            possiblePaths = this.find(this.currentPath, te.elemName);
                            if (possiblePaths == null || possiblePaths.isEmpty()) break;
                            if (possiblePaths.size() > 1) {
                                DecisionPoint<U, V> decisionPoint = new DecisionPoint<U, V>(this.currentPath, possiblePaths, index, this.elementStack, this.anyStack);
                                this.decisionPoints.add(decisionPoint);
                                nextPath = decisionPoint.tryNextPath();
                            } else {
                                nextPath = possiblePaths.get(0);
                            }
                            if (nextPath == null) {
                                throw new IllegalStateException("Somehow after finding a new path to follow, that path is null.");
                            }
                            this.followPath(nextPath);
                            if (this.currentPath.getStateMachineNode().getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ANY)) {
                                if (this.anyStack == null) {
                                    this.anyStack = new ArrayList();
                                }
                                this.anyStack.add(te.elemName);
                            }
                            this.elementStack.add(te.elemName);
                            continue;
                        }
                        if (te.traversal.equals((Object)TraversedElement.Traversal.END)) {
                            boolean isAny;
                            boolean bl = isAny = this.currentPath.getStateMachineNode().getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ANY) && this.anyStack != null && !this.anyStack.isEmpty();
                            if (!isAny) {
                                this.walkUpToElement(te.elemName);
                            }
                            this.walkUpTree(te.elemName);
                            QName endingElemName = this.elementStack.remove(this.elementStack.size() - 1);
                            if (!te.elemName.equals(endingElemName)) {
                                throw new IllegalStateException("Attempted to end element " + te.elemName + " but found " + endingElemName + " on the stack instead!");
                            }
                            if (!isAny) continue;
                            this.anyStack.remove(this.anyStack.size() - 1);
                            continue;
                        }
                        if (te.traversal.equals((Object)TraversedElement.Traversal.CONTENT)) {
                            XmlSchemaPathNode<U, V> contentPath = this.pathMgr.addParentSiblingOrContentNodeToPath(this.currentPath, XmlSchemaPathNode.Direction.CONTENT);
                            this.currentPath.setNextNode(-1, contentPath);
                            this.currentPath = contentPath;
                            continue;
                        }
                        throw new IllegalStateException("Unrecognized element traversal direction for " + te.elemName + " of " + (Object)((Object)te.traversal) + '.');
                    }
                    if (index < this.traversedElements.size() || (possiblePaths = this.find(this.currentPath, elemQName)) == null) continue;
                    if (possiblePaths.size() > 1) {
                        DecisionPoint<U, V> decisionPoint = new DecisionPoint<U, V>(this.currentPath, possiblePaths, this.traversedElements.size(), this.elementStack, this.anyStack);
                        this.decisionPoints.add(decisionPoint);
                        nextPath = decisionPoint.tryNextPath();
                    } else {
                        nextPath = possiblePaths.get(0);
                    }
                    if (nextPath == null) continue;
                    this.followPath(nextPath);
                    break;
                }
            }
            if (nextPath == null) {
                throw new IllegalStateException("Walked through XML Schema and could not find a traversal that represented this XML Document.");
            }
            this.validateAttributes(atts);
            this.traversedElements.add(new TraversedElement(elemQName, TraversedElement.Traversal.START));
            this.elementStack.add(elemQName);
            if (this.currentPath.getStateMachineNode().getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ANY)) {
                if (this.anyStack == null) {
                    this.anyStack = new ArrayList();
                }
                this.anyStack.add(elemQName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred while starting element " + elemQName + "; traversed path is " + this.getElementsTraversedAsString(), e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            boolean elemExpectsContent;
            if (this.currentPath.getStateMachineNode().getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ANY) && this.anyStack != null && !this.anyStack.isEmpty()) {
                return;
            }
            XmlSchemaStateMachineNode state = this.getStateMachineOfOwningElement();
            XmlSchemaElement element = state.getElement();
            XmlSchemaTypeInfo elemTypeInfo = state.getElementType();
            String text = new String(ch, start, length).trim();
            boolean bl = elemExpectsContent = elemTypeInfo != null && (!elemTypeInfo.getType().equals((Object)XmlSchemaTypeInfo.Type.COMPLEX) || elemTypeInfo.isMixed());
            if (!elemExpectsContent && text.length() == 0) {
                return;
            }
            if (!elemExpectsContent && text.length() > 0) {
                throw new IllegalStateException("Element " + state.getElement().getQName() + " has no content, but we received \"" + text + "\" for it.");
            }
            if (elemExpectsContent && text.length() == 0 && !state.getElement().isNillable() && !elemTypeInfo.isMixed() && element.getDefaultValue() == null && element.getFixedValue() == null) {
                throw new IllegalStateException("Received empty text for element " + state.getElement().getQName() + " when content was expected.");
            }
            XmlSchemaElementValidator.validateContent(state, text, (NamespaceContext)((Object)this.nsContext));
            this.currentPath.getDocumentNode().setReceivedContent(true);
            XmlSchemaPathNode<U, V> contentPath = this.pathMgr.addParentSiblingOrContentNodeToPath(this.currentPath, XmlSchemaPathNode.Direction.CONTENT);
            this.currentPath.setNextNode(-1, contentPath);
            this.currentPath = contentPath;
            this.traversedElements.add(new TraversedElement(element.getQName(), TraversedElement.Traversal.CONTENT));
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred while processing characters; traversed path was " + this.getElementsTraversedAsString(), e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        QName elemQName = new QName(uri, localName);
        try {
            XmlSchemaStateMachineNode state;
            boolean isAny;
            boolean bl = isAny = this.currentPath.getStateMachineNode().getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ANY) && this.anyStack != null && !this.anyStack.isEmpty();
            if (!isAny && !this.elementStack.get(this.elementStack.size() - 1).equals(elemQName)) {
                throw new IllegalStateException("Attempting to end element " + elemQName + " but the stack is expecting " + this.elementStack.get(this.elementStack.size() - 1));
            }
            if (!isAny) {
                this.walkUpToElement(elemQName);
            }
            if ((state = this.currentPath.getStateMachineNode()).getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ELEMENT)) {
                boolean elemExpectsContent;
                if (!state.getElement().getQName().equals(elemQName)) {
                    throw new IllegalStateException("We are ending element " + elemQName + " but our current position is for element " + state.getElement().getQName() + '.');
                }
                XmlSchemaTypeInfo elemTypeInfo = state.getElementType();
                boolean bl2 = elemExpectsContent = elemTypeInfo != null && !elemTypeInfo.getType().equals((Object)XmlSchemaTypeInfo.Type.COMPLEX);
                if (elemExpectsContent && !state.getElement().isNillable() && state.getElement().getDefaultValue() == null && state.getElement().getFixedValue() == null && !this.currentPath.getDocumentNode().getReceivedContent()) {
                    throw new IllegalStateException("We are ending element " + elemQName + "; it expected to receive content but did not.");
                }
            }
            this.traversedElements.add(new TraversedElement(elemQName, TraversedElement.Traversal.END));
            this.elementStack.remove(this.elementStack.size() - 1);
            if (isAny) {
                this.anyStack.remove(this.anyStack.size() - 1);
            }
            if (this.anyStack == null || this.anyStack.isEmpty()) {
                this.walkUpTree(elemQName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred while ending element " + elemQName + "; traversed path was " + this.getElementsTraversedAsString(), e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (!this.elementStack.isEmpty()) {
            throw new IllegalStateException("Ended the document but " + this.elementStack.size() + " elements have not been closed.");
        }
        this.pathMgr.clear();
        if (this.decisionPoints != null) {
            this.decisionPoints.clear();
        }
    }

    public XmlSchemaPathNode<U, V> getXmlSchemaTraversal() {
        return this.rootPathNode;
    }

    private static <U, V> Fulfillment isPositionFulfilled(XmlSchemaPathNode<U, V> currentPath, List<Integer> possiblePaths) {
        boolean completelyFulfilled = true;
        boolean partiallyFulfilled = true;
        XmlSchemaStateMachineNode state = currentPath.getStateMachineNode();
        partiallyFulfilled = currentPath.getDocumentNode() == null ? false : (long)currentPath.getDocIteration() >= state.getMinOccurs();
        if (currentPath.getDocumentNode() == null) {
            completelyFulfilled = false;
        } else if ((long)currentPath.getDocIteration() == state.getMaxOccurs()) {
            completelyFulfilled = true;
        } else {
            if ((long)currentPath.getDocIteration() > state.getMaxOccurs()) {
                throw new IllegalStateException("Current path's document iteration of " + currentPath.getDocIteration() + " is greater than the maximum number of occurrences (" + state.getMaxOccurs() + ").");
            }
            completelyFulfilled = false;
        }
        List<XmlSchemaStateMachineNode> nextStates = state.getPossibleNextStates();
        SortedMap<Integer, XmlSchemaDocumentNode<U>> children = null;
        if (currentPath.getDocumentNode() != null) {
            children = currentPath.getDocumentNode().getChildren();
        }
        switch (state.getNodeType()) {
            case ELEMENT: 
            case ANY: {
                break;
            }
            case CHOICE: 
            case SUBSTITUTION_GROUP: {
                boolean groupPartiallyFulfilled = false;
                boolean groupCompletelyFulfilled = false;
                for (int stateIndex = 0; stateIndex < nextStates.size(); ++stateIndex) {
                    XmlSchemaStateMachineNode nextState = nextStates.get(stateIndex);
                    if (children != null && children.containsKey(stateIndex)) {
                        XmlSchemaDocumentNode child = (XmlSchemaDocumentNode)children.get(stateIndex);
                        int iteration = child.getIteration();
                        if ((long)iteration >= nextState.getMinOccurs()) {
                            groupPartiallyFulfilled = true;
                            if (possiblePaths == null) break;
                            possiblePaths.clear();
                            if ((long)iteration < nextState.getMaxOccurs()) {
                                possiblePaths.add(stateIndex);
                                break;
                            }
                            groupCompletelyFulfilled = true;
                            break;
                        }
                        if (possiblePaths == null) continue;
                        possiblePaths.add(stateIndex);
                        continue;
                    }
                    if (nextState.getMinOccurs() == 0L) {
                        groupPartiallyFulfilled = true;
                    }
                    if (nextState.getMaxOccurs() == 0L) {
                        groupCompletelyFulfilled = true;
                        continue;
                    }
                    if (possiblePaths == null) continue;
                    possiblePaths.add(stateIndex);
                }
                partiallyFulfilled &= groupPartiallyFulfilled;
                completelyFulfilled &= groupCompletelyFulfilled;
                break;
            }
            case ALL: {
                int stateIndex;
                for (stateIndex = 0; stateIndex < nextStates.size(); ++stateIndex) {
                    XmlSchemaStateMachineNode nextState = nextStates.get(stateIndex);
                    if (children != null && children.containsKey(stateIndex)) {
                        XmlSchemaDocumentNode child = (XmlSchemaDocumentNode)children.get(stateIndex);
                        int iteration = child.getIteration();
                        if ((long)iteration < nextState.getMinOccurs()) {
                            partiallyFulfilled = false;
                        }
                        if ((long)iteration >= nextState.getMaxOccurs()) continue;
                        completelyFulfilled = false;
                        if (possiblePaths == null) continue;
                        possiblePaths.add(stateIndex);
                        continue;
                    }
                    if (nextState.getMinOccurs() > 0L) {
                        partiallyFulfilled = false;
                    }
                    if (nextState.getMaxOccurs() <= 0L) continue;
                    completelyFulfilled = false;
                    if (possiblePaths == null) continue;
                    possiblePaths.add(stateIndex);
                }
                break;
            }
            case SEQUENCE: {
                int stateIndex = currentPath.getDocSequencePosition();
                if (stateIndex < 0) {
                    stateIndex = 0;
                }
                while (stateIndex < nextStates.size()) {
                    XmlSchemaStateMachineNode nextState = nextStates.get(stateIndex);
                    if (children != null && children.containsKey(stateIndex)) {
                        XmlSchemaDocumentNode child = (XmlSchemaDocumentNode)children.get(stateIndex);
                        if ((long)child.getIteration() < nextState.getMinOccurs()) {
                            partiallyFulfilled = false;
                        }
                        if ((long)child.getIteration() < nextState.getMaxOccurs()) {
                            completelyFulfilled = false;
                            if (possiblePaths != null) {
                                possiblePaths.add(stateIndex);
                            }
                        }
                    } else {
                        if (nextState.getMinOccurs() > 0L) {
                            partiallyFulfilled = false;
                        }
                        if (nextState.getMaxOccurs() > 0L) {
                            completelyFulfilled = false;
                            if (possiblePaths != null) {
                                possiblePaths.add(stateIndex);
                            }
                        }
                    }
                    ++stateIndex;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Current position has a node of unrecognized type \"" + (Object)((Object)currentPath.getStateMachineNode().getNodeType()) + '\"');
            }
        }
        Fulfillment fulfillment = Fulfillment.NOT;
        if (completelyFulfilled) {
            fulfillment = Fulfillment.COMPLETE;
        } else if (partiallyFulfilled) {
            fulfillment = Fulfillment.PARTIAL;
        }
        return fulfillment;
    }

    private List<PathSegment<U, V>> find(XmlSchemaPathNode<U, V> startNode, QName elemQName) {
        List<PathSegment<U, V>> choices;
        XmlSchemaPathNode<U, V> startOfPath = startNode;
        if (startNode.getStateMachineNode().getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ELEMENT) && !this.elementStack.isEmpty() && startNode.getStateMachineNode().getElement().getQName().equals(this.elementStack.get(this.elementStack.size() - 1))) {
            this.verifyCurrentPositionIsAtElement("Started element " + elemQName);
            if (startNode.getStateMachineNode().getPossibleNextStates() == null) {
                String elemName = this.getLeafNodeName(startNode.getStateMachineNode());
                throw new IllegalStateException("Element " + elemName + " has null children!  Exactly one is expected.");
            }
            if (startNode.getStateMachineNode().getPossibleNextStates().isEmpty()) {
                String elemName = this.getLeafNodeName(startNode.getStateMachineNode());
                throw new IllegalStateException("Element " + elemName + " has zero children!  Exactly one is expected.");
            }
            if (this.currentPath.getStateMachineNode().getPossibleNextStates().size() > 1) {
                String elemName = this.getLeafNodeName(this.currentPath.getStateMachineNode());
                throw new IllegalStateException("Element " + elemName + " has " + this.currentPath.getStateMachineNode().getPossibleNextStates().size() + " children!  Only one was expected.");
            }
            if (startNode.getDocumentNode() != null && startNode.getDocumentNode().getChildren() != null && !startNode.getDocumentNode().getChildren().isEmpty() && startNode.getDocumentNode().getChildren().size() > 1) {
                throw new IllegalStateException("There are multiple children in the document node for element " + this.currentPath.getStateMachineNode().getElement().getQName());
            }
            XmlSchemaPathNode<U, V> childPath = this.pathMgr.addChildNodeToPath(startNode, 0);
            startNode.setNextNode(0, childPath);
            startNode = childPath;
        }
        if ((choices = this.find(startNode, elemQName, null)) != null && startOfPath != startNode) {
            for (PathSegment<U, V> choice : choices) {
                choice.prepend(startOfPath, 0);
            }
        }
        return choices;
    }

    private List<PathSegment<U, V>> find(XmlSchemaPathNode<U, V> startNode, QName elemQName, XmlSchemaStateMachineNode doNotFollow) {
        ArrayList<Integer> childrenNodes = new ArrayList<Integer>();
        boolean isFulfilled = !XmlSchemaPathFinder.isPositionFulfilled(startNode, childrenNodes).equals((Object)Fulfillment.NOT);
        List<PathSegment<U, V>> choices = null;
        List<PathSegment<U, V>> currChoices = null;
        if (startNode.getIteration() > startNode.getDocIteration()) {
            choices = this.find(startNode, elemQName, 0);
        } else {
            for (Integer childPath : childrenNodes) {
                XmlSchemaPathNode<U, V> currPath;
                if (doNotFollow == startNode.getStateMachineNode().getPossibleNextStates().get(childPath) || (currChoices = this.find(currPath = this.pathMgr.addChildNodeToPath(startNode, childPath), elemQName, 0)) == null) continue;
                for (PathSegment<U, V> choice : currChoices) {
                    choice.prepend(startNode, childPath);
                }
                if (choices == null) {
                    choices = currChoices;
                    continue;
                }
                choices.addAll(currChoices);
            }
        }
        if (isFulfilled) {
            if ((long)startNode.getIteration() < startNode.getMaxOccurs()) {
                XmlSchemaPathNode<U, V> siblingPath = this.pathMgr.addParentSiblingOrContentNodeToPath(startNode, XmlSchemaPathNode.Direction.SIBLING);
                siblingPath.setIteration(startNode.getIteration() + 1);
                currChoices = this.find(siblingPath, elemQName, 0);
                if (currChoices != null) {
                    for (PathSegment<U, V> choice : currChoices) {
                        choice.prepend(startNode, -1);
                    }
                    if (choices == null) {
                        choices = currChoices;
                    } else {
                        choices.addAll(currChoices);
                    }
                }
            }
            if (startNode.getDocumentNode().getParent() == null) {
                return choices;
            }
            XmlSchemaPathNode<U, V> path = this.pathMgr.addParentSiblingOrContentNodeToPath(startNode, XmlSchemaPathNode.Direction.PARENT);
            if (path.getStateMachineNode().getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ELEMENT) && path.getStateMachineNode().getElement().getQName().equals(this.elementStack.get(this.elementStack.size() - 1))) {
                return choices;
            }
            List<PathSegment<U, V>> pathsOfParent = this.find(path, elemQName, startNode.getStateMachineNode());
            if (pathsOfParent != null) {
                for (PathSegment<U, V> choice : pathsOfParent) {
                    choice.prepend(startNode, -1);
                }
                if (choices == null) {
                    choices = pathsOfParent;
                } else {
                    choices.addAll(pathsOfParent);
                }
            } else {
                this.pathMgr.recyclePathNode(path);
            }
        }
        return choices;
    }

    private List<PathSegment<U, V>> find(XmlSchemaPathNode<U, V> startNode, QName elemQName, int currDepth) {
        XmlSchemaStateMachineNode state = startNode.getStateMachineNode();
        if (currDepth > 256) {
            return null;
        }
        if (startNode.getStateMachineNode() != state) {
            throw new IllegalStateException("While searching for " + elemQName + ", the DocumentPathNode state machine (" + (Object)((Object)startNode.getStateMachineNode().getNodeType()) + ") does not match the tree node (" + (Object)((Object)state.getNodeType()) + ").");
        }
        if (startNode.getIteration() <= startNode.getDocIteration()) {
            throw new IllegalStateException("While searching for " + elemQName + ", the DocumentPathNode iteration (" + startNode.getIteration() + ") should be greater than the tree node's iteration (" + startNode.getDocIteration() + ").  Current state machine position is " + (Object)((Object)state.getNodeType()));
        }
        if (state.getMaxOccurs() < (long)startNode.getIteration()) {
            return null;
        }
        if (!(state.getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ELEMENT) || state.getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ANY) || state.getPossibleNextStates() != null && !state.getPossibleNextStates().isEmpty())) {
            throw new IllegalStateException("Group " + (Object)((Object)state.getNodeType()) + " has no children.  Found when processing " + elemQName);
        }
        List<PathSegment<U, V>> choices = null;
        block0 : switch (state.getNodeType()) {
            case ELEMENT: {
                if (!state.getElement().getQName().equals(elemQName) || (long)startNode.getIteration() > state.getMaxOccurs()) break;
                choices = new ArrayList(1);
                choices.add(new PathSegment<U, V>(this.pathMgr, startNode));
                break;
            }
            case SEQUENCE: {
                int position = startNode.getDocSequencePosition();
                if ((long)startNode.getDocIteration() > startNode.getMaxOccurs()) {
                    throw new IllegalStateException("Somehow the document iteration for " + startNode.getStateMachineNode() + " of " + startNode.getDocIteration() + " exceeds the maximum number of occurrences of " + startNode.getMaxOccurs());
                }
                if ((long)startNode.getDocIteration() == startNode.getMaxOccurs()) {
                    ++position;
                }
                for (int stateIndex = position; stateIndex < startNode.getStateMachineNode().getPossibleNextStates().size(); ++stateIndex) {
                    XmlSchemaPathNode<U, V> nextPath = this.pathMgr.addChildNodeToPath(startNode, stateIndex);
                    if ((long)nextPath.getIteration() > nextPath.getMaxOccurs()) {
                        throw new IllegalStateException("Reached a sequence group when searching for " + elemQName + " whose iteration at the current position (" + nextPath.getIteration() + ") was already maxed out (" + nextPath.getMaxOccurs() + ").  Was at position " + stateIndex + "; tree node's starting position was " + startNode.getDocSequencePosition());
                    }
                    boolean reachedMinOccurs = (long)nextPath.getDocIteration() >= nextPath.getMinOccurs();
                    List<PathSegment<U, V>> seqPaths = this.find(nextPath, elemQName, currDepth + 1);
                    if (seqPaths != null) {
                        for (PathSegment<U, V> seqPath : seqPaths) {
                            seqPath.prepend(startNode, stateIndex);
                        }
                        this.pathMgr.recyclePathNode(nextPath);
                        if (choices == null) {
                            choices = seqPaths;
                        } else {
                            choices.addAll(seqPaths);
                        }
                    }
                    if (!reachedMinOccurs) break block0;
                }
                break;
            }
            case CHOICE: 
            case SUBSTITUTION_GROUP: 
            case ALL: {
                for (int stateIndex = 0; stateIndex < state.getPossibleNextStates().size(); ++stateIndex) {
                    XmlSchemaStateMachineNode nextState = state.getPossibleNextStates().get(stateIndex);
                    if (state.getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ALL) && !nextState.getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ELEMENT) && !nextState.getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.SUBSTITUTION_GROUP) && !nextState.getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ANY)) {
                        throw new IllegalStateException("While searching for " + elemQName + ", encountered an All group which contained a child of type " + (Object)((Object)nextState.getNodeType()) + '.');
                    }
                    XmlSchemaPathNode<U, V> nextPath = this.pathMgr.addChildNodeToPath(startNode, stateIndex);
                    List<PathSegment<U, V>> choicePaths = this.find(nextPath, elemQName, currDepth + 1);
                    if (choicePaths == null) continue;
                    for (PathSegment<U, V> choicePath : choicePaths) {
                        choicePath.prepend(startNode, stateIndex);
                    }
                    this.pathMgr.recyclePathNode(nextPath);
                    if (choices == null) {
                        choices = choicePaths;
                        continue;
                    }
                    choices.addAll(choicePaths);
                }
                break;
            }
            case ANY: {
                if (this.traversedElements.size() < 2) {
                    throw new IllegalStateException("Reached a wildcard element while searching for " + elemQName + ", but we've only seen " + this.traversedElements.size() + " element(s)!");
                }
                XmlSchemaAny any = state.getAny();
                if (any.getNamespace() == null) {
                    choices = new ArrayList<PathSegment<U, V>>(1);
                    choices.add(new PathSegment<U, V>(this.pathMgr, startNode));
                    break;
                }
                boolean needTargetNamespace = false;
                boolean matches = false;
                boolean matchOnNotTargetNamespace = false;
                ArrayList<String> validNamespaces = null;
                if (any.getNamespace().equals("##any")) {
                    matches = true;
                } else if (any.getNamespace().equals("##other")) {
                    needTargetNamespace = true;
                    matchOnNotTargetNamespace = true;
                    validNamespaces = new ArrayList<String>(1);
                } else {
                    String[] namespaces = any.getNamespace().trim().split(" ");
                    validNamespaces = new ArrayList(namespaces.length);
                    for (String namespace : namespaces) {
                        if ("##targetNamespace".equals(namespace)) {
                            needTargetNamespace = true;
                            continue;
                        }
                        if ("##local".equals(namespace) && elemQName.getNamespaceURI() == null) {
                            matches = true;
                            continue;
                        }
                        validNamespaces.add(namespace);
                    }
                }
                if (!matches) {
                    if (needTargetNamespace) {
                        validNamespaces.add(any.getTargetNamespace());
                    }
                    matches = validNamespaces.contains(elemQName.getNamespaceURI());
                    if (matchOnNotTargetNamespace) {
                        boolean bl = matches = !matches;
                    }
                }
                if (!matches) break;
                choices = new ArrayList(1);
                choices.add(new PathSegment<U, V>(this.pathMgr, startNode));
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized node type " + (Object)((Object)state.getNodeType()) + " when processing element " + elemQName);
            }
        }
        if (choices == null && currDepth > 0) {
            this.pathMgr.recyclePathNode(startNode);
        }
        return choices;
    }

    private void walkUpTree(QName currElem) {
        XmlSchemaStateMachineNode state = this.currentPath.getStateMachineNode();
        switch (state.getNodeType()) {
            case ANY: {
                break;
            }
            case ELEMENT: {
                if (state.getElement().getQName().equals(currElem)) break;
                throw new IllegalStateException("We expected to walk upwards from element " + currElem + ", but our current element is " + state.getElement().getQName());
            }
            default: {
                throw new IllegalStateException("We expected to walk upwards from element " + currElem + ", but our current position is in a node of type " + (Object)((Object)state.getNodeType()));
            }
        }
        XmlSchemaDocumentNode<U> iter = this.currentPath.getDocumentNode();
        XmlSchemaPathNode<U, V> path = this.currentPath;
        while ((long)iter.getIteration() >= iter.getStateMachineNode().getMaxOccurs() && XmlSchemaPathFinder.isPositionFulfilled(path, null).equals((Object)Fulfillment.COMPLETE) && (iter = iter.getParent()) != null) {
            XmlSchemaPathNode<U, V> nextPath = this.pathMgr.addParentSiblingOrContentNodeToPath(path, XmlSchemaPathNode.Direction.PARENT);
            path.setNextNode(-1, nextPath);
            path = nextPath;
            if (!iter.getStateMachineNode().getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ELEMENT)) continue;
        }
        this.currentPath = path;
    }

    private void walkUpToElement(QName element) {
        XmlSchemaDocumentNode<U> iter = this.currentPath.getDocumentNode();
        if (iter.getStateMachineNode().getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ELEMENT) && iter.getStateMachineNode().getElement().getQName().equals(element)) {
            return;
        }
        do {
            if ((iter = iter.getParent()) == null) continue;
            XmlSchemaPathNode<U, V> nextPath = this.pathMgr.addParentSiblingOrContentNodeToPath(this.currentPath, XmlSchemaPathNode.Direction.PARENT);
            this.currentPath.setNextNode(-1, nextPath);
            this.currentPath = nextPath;
        } while (iter != null && !iter.getStateMachineNode().getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ELEMENT));
        if (!this.currentPath.getStateMachineNode().getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ELEMENT) || !this.currentPath.getStateMachineNode().getElement().getQName().equals(element)) {
            throw new IllegalStateException("Walked up tree and stopped at node " + this.currentPath.getStateMachineNode() + ", which does not represent element " + element);
        }
    }

    private void followPath(PathSegment<U, V> path) {
        switch (path.getEnd().getStateMachineNode().getNodeType()) {
            case ELEMENT: 
            case ANY: {
                break;
            }
            default: {
                throw new IllegalStateException("Path does not end in an element or a wildcard element.");
            }
        }
        XmlSchemaPathNode<U, V> startNode = path.getStart();
        if (path.getAfterStart() != null) {
            startNode.setNextNode(path.getAfterStartPathIndex(), path.getAfterStart());
        }
        this.pathMgr.followPath(startNode);
        this.currentPath = path.getEnd();
    }

    private String getElementsTraversedAsString() {
        StringBuilder traversed = new StringBuilder("[");
        if (this.traversedElements != null && !this.traversedElements.isEmpty()) {
            for (int i = 0; i < this.traversedElements.size() - 1; ++i) {
                traversed.append(this.traversedElements.get(i)).append(" | ");
            }
            traversed.append(this.traversedElements.get(this.traversedElements.size() - 1));
        }
        traversed.append(" ]");
        return traversed.toString();
    }

    private void verifyCurrentPositionIsAtElement(String errMsgPrefix) {
        if (!this.currentPath.getStateMachineNode().getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ELEMENT) && !this.currentPath.getStateMachineNode().getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ANY)) {
            throw new IllegalStateException(errMsgPrefix + " when our current position in the tree is a " + (Object)((Object)this.currentPath.getStateMachineNode().getNodeType()) + '.');
        }
    }

    private String getLeafNodeName(XmlSchemaStateMachineNode node) {
        if (!node.getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ELEMENT) && !node.getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ANY)) {
            throw new IllegalStateException("State machine node needs to be an element or a wildcard element, not a " + (Object)((Object)this.currentPath.getStateMachineNode().getNodeType()) + '.');
        }
        String elemName = "a wildcard element";
        if (node.getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ELEMENT)) {
            elemName = node.getElement().getQName().toString();
        }
        return elemName;
    }

    private XmlSchemaStateMachineNode getStateMachineOfOwningElement() {
        QName element = this.elementStack.get(this.elementStack.size() - 1);
        XmlSchemaDocumentNode<U> iter = this.currentPath.getDocumentNode();
        if (iter.getStateMachineNode().getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ELEMENT) && iter.getStateMachineNode().getElement().getQName().equals(element)) {
            return this.currentPath.getStateMachineNode();
        }
        while ((iter = iter.getParent()) != null && !iter.getStateMachineNode().getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ELEMENT)) {
        }
        if (!iter.getStateMachineNode().getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ELEMENT) || !iter.getStateMachineNode().getElement().getQName().equals(element)) {
            throw new IllegalStateException("Walked up tree and stopped at node " + this.currentPath.getStateMachineNode() + ", which does not represent element " + element);
        }
        return iter.getStateMachineNode();
    }

    private void validateAttributes(Attributes attrs) {
        if (this.currentPath.getStateMachineNode().getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ANY)) {
            return;
        }
        try {
            XmlSchemaElementValidator.validateAttributes(this.currentPath.getStateMachineNode(), attrs, (NamespaceContext)((Object)this.nsContext));
        }
        catch (ValidationException ve) {
            throw new IllegalStateException("Cannot validate attributes of " + this.currentPath.getStateMachineNode().getElement().getQName() + '.', ve);
        }
    }

    private static enum Fulfillment {
        NOT,
        PARTIAL,
        COMPLETE;

    }

    private static class TraversedElement {
        QName elemName;
        Traversal traversal;

        TraversedElement(QName elemName, Traversal traversal) {
            this.elemName = elemName;
            this.traversal = traversal;
        }

        public String toString() {
            StringBuilder str = new StringBuilder(this.elemName.toString());
            str.append(" : ").append((Object)this.traversal);
            return str.toString();
        }

        static enum Traversal {
            START,
            CONTENT,
            END;

        }
    }

    private static class DecisionPoint<U, V> {
        private final XmlSchemaPathNode<U, V> decisionPoint;
        private final List<PathSegment<U, V>> choices;
        private final int traversedElementIndex;
        private final ArrayList<QName> elementStack;
        private final ArrayList<QName> anyStack;

        DecisionPoint(XmlSchemaPathNode<U, V> decisionPoint, List<PathSegment<U, V>> choices, int traversedElementIndex, ArrayList<QName> elementStack, ArrayList<QName> anyStack) {
            if (decisionPoint == null) {
                throw new IllegalArgumentException("The decision point path node cannot be null.");
            }
            if (choices == null) {
                throw new IllegalArgumentException("The set of choice paths to follow cannot be null.");
            }
            if (choices.size() < 2) {
                throw new IllegalArgumentException("There must be at least two choices to constitute a decision point, not " + choices.size());
            }
            this.decisionPoint = decisionPoint;
            this.choices = choices;
            this.traversedElementIndex = traversedElementIndex;
            this.elementStack = new ArrayList<QName>(elementStack);
            this.anyStack = anyStack == null ? null : new ArrayList<QName>(anyStack);
            Collections.sort(choices);
        }

        PathSegment<U, V> tryNextPath() {
            if (this.choices.isEmpty()) {
                return null;
            }
            return this.choices.remove(0);
        }

        XmlSchemaPathNode<U, V> getDecisionPoint() {
            return this.decisionPoint;
        }

        ArrayList<QName> getElementStack() {
            return new ArrayList<QName>(this.elementStack);
        }

        ArrayList<QName> getAnyStack() {
            return this.anyStack == null ? null : new ArrayList<QName>(this.anyStack);
        }

        public String toString() {
            String nl = System.getProperty("line.separator");
            StringBuilder str = new StringBuilder("Decision Point: ");
            str.append((Object)this.decisionPoint.getDirection()).append(" | ");
            str.append(this.decisionPoint.getStateMachineNode());
            str.append(" ]").append(nl);
            for (PathSegment<U, V> choice : this.choices) {
                str.append('\t').append(choice).append(nl);
            }
            return str.toString();
        }
    }

    private static final class PathSegment<U, V>
    implements Comparable<PathSegment<U, V>> {
        private XmlSchemaPathManager<U, V> pathMgr;
        private XmlSchemaPathNode<U, V> start;
        private XmlSchemaPathNode<U, V> end;
        private XmlSchemaPathNode<U, V> afterStart;
        private int length;
        private int afterStartPathIndex;

        PathSegment(XmlSchemaPathManager<U, V> pathMgr, XmlSchemaPathNode<U, V> node) {
            this.pathMgr = pathMgr;
            this.set(node);
        }

        @Override
        public int compareTo(PathSegment<U, V> o) {
            if (this == o) {
                return 0;
            }
            if (!this.end.getStateMachineNode().getNodeType().equals((Object)o.getEnd().getStateMachineNode().getNodeType())) {
                if (this.end.getStateMachineNode().getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ANY)) {
                    return 1;
                }
                if (o.getEnd().getStateMachineNode().getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ANY)) {
                    return -1;
                }
                throw new IllegalStateException("The end nodes do not have the same machine node type, so one should be an ELEMENT and the other should be an ANY.  However, this end node is a " + (Object)((Object)this.end.getStateMachineNode().getNodeType()) + " while the other has an end node of type " + (Object)((Object)o.getEnd().getStateMachineNode().getNodeType()) + ".");
            }
            int thisLength = this.getLength();
            int thatLength = o.getLength();
            if (thisLength > 0 && thatLength > 0) {
                XmlSchemaPathNode<U, V> thatIter;
                XmlSchemaPathNode<U, V> thisIter = this.afterStart;
                for (thatIter = o.getAfterStart(); thisIter != null && thatIter != null; thisIter = thisIter.getNext(), thatIter = thatIter.getNext()) {
                    if (thisIter.getDirection().getRank() < thatIter.getDirection().getRank()) {
                        return -1;
                    }
                    if (thisIter.getDirection().getRank() > thatIter.getDirection().getRank()) {
                        return 1;
                    }
                    if (thisIter.getIndexOfNextNodeState() < thatIter.getIndexOfNextNodeState()) {
                        return -1;
                    }
                    if (thisIter.getIndexOfNextNodeState() <= thatIter.getIndexOfNextNodeState()) continue;
                    return 1;
                }
                if (thisIter == null && thatIter != null) {
                    return -1;
                }
                if (thisIter != null && thatIter == null) {
                    return 1;
                }
            } else {
                if (thisLength == 0 && thatLength > 0) {
                    return -1;
                }
                if (thisLength > 0 && thatLength == 0) {
                    return 1;
                }
                if (this.end.getIndexOfNextNodeState() < o.getEnd().getIndexOfNextNodeState()) {
                    return -1;
                }
                if (this.end.getIndexOfNextNodeState() > o.getEnd().getIndexOfNextNodeState()) {
                    return 1;
                }
            }
            return 0;
        }

        int getLength() {
            if (this.length == 0 && this.start != this.end) {
                for (XmlSchemaPathNode<U, V> iter = this.afterStart; iter != this.end; iter = iter.getNext()) {
                    ++this.length;
                }
                ++this.length;
            }
            return this.length;
        }

        void prepend(XmlSchemaPathNode<U, V> newStart, int pathIndexToNextNode) {
            XmlSchemaPathNode<U, V> clonedStartNode = this.pathMgr.clone(this.start);
            if (this.afterStart != null) {
                this.afterStart.setPreviousNode(clonedStartNode);
                clonedStartNode.setNextNode(this.afterStartPathIndex, this.afterStart);
                this.afterStart = clonedStartNode;
            } else {
                this.end = clonedStartNode;
                this.afterStart = clonedStartNode;
            }
            this.start = newStart;
            this.afterStartPathIndex = pathIndexToNextNode;
            this.length = 0;
        }

        XmlSchemaPathNode<U, V> getStart() {
            return this.start;
        }

        XmlSchemaPathNode<U, V> getEnd() {
            return this.end;
        }

        XmlSchemaPathNode<U, V> getAfterStart() {
            return this.afterStart;
        }

        int getAfterStartPathIndex() {
            return this.afterStartPathIndex;
        }

        void set(XmlSchemaPathNode<U, V> node) {
            if (node == null) {
                throw new IllegalArgumentException("DocumentPathNode cannot be null.");
            }
            this.start = node;
            this.end = node;
            this.afterStart = null;
            this.afterStartPathIndex = -1;
            this.length = 0;
        }

        public String toString() {
            StringBuilder str = new StringBuilder("Path Segment: [ ");
            str.append((Object)this.start.getDirection()).append(" | ");
            str.append(this.start.getStateMachineNode()).append(" ]");
            if (this.afterStart != null) {
                XmlSchemaPathNode<U, V> path = this.afterStart;
                do {
                    str.append(" [").append((Object)path.getDirection()).append(" | ");
                    str.append(path.getStateMachineNode()).append(" ]");
                } while ((path = path.getNext()) != null);
            } else {
                str.append(" [").append((Object)this.end.getDirection()).append(" | ");
                str.append(this.end.getStateMachineNode()).append(" ]");
            }
            return str.toString();
        }
    }
}

