/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.maven.plugins;

import org.apache.maven.plugin.logging.Log;
import org.apache.ws.jaxme.logging.Logger;

class MavenProjectLogger
implements Logger {
    private final Log log;
    private final String name;

    MavenProjectLogger(Log pLog, String pName) {
        this.log = pLog;
        this.name = pName;
    }

    private String asName(String pName) {
        return String.valueOf(this.name) + "." + pName;
    }

    private String asString(Object[] pArgs) {
        StringBuffer sb = new StringBuffer();
        if (pArgs != null) {
            int i = 0;
            while (i < pArgs.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(pArgs[i]);
                ++i;
            }
        }
        return sb.toString();
    }

    public void entering(String pName, Object[] pArgs) {
        this.entering(pName, this.asString(pArgs));
    }

    public void entering(String pName) {
        this.entering(pName, "");
    }

    public void entering(String pName, Object pArg) {
        this.log.debug((CharSequence)(String.valueOf(this.asName(pName)) + " -> " + pArg));
    }

    public void exiting(String pName, Object[] pArgs) {
        this.exiting(pName, this.asString(pArgs));
    }

    public void exiting(String pName) {
        this.exiting(pName, "");
    }

    public void exiting(String pName, Object pArg) {
        this.log.debug((CharSequence)(String.valueOf(this.asName(pName)) + " <- " + pArg));
    }

    public void throwing(String pName, Throwable pError) {
        this.log.error((CharSequence)this.asName(pName), pError);
    }

    public boolean isFinestEnabled() {
        return true;
    }

    public void finest(String pName, String pArg, Object[] pArgs) {
        this.finest(pName, String.valueOf(pArg) + ", " + this.asString(pArgs));
    }

    public void finest(String pName, String pArg) {
        this.log.debug((CharSequence)(String.valueOf(this.asName(pName)) + ": " + pArg));
    }

    public void finest(String pName, String pArg1, Object pArg2) {
        this.finest(pName, String.valueOf(pArg1) + ", " + pArg2);
    }

    public void finer(String pName, String pArg, Object[] pArgs) {
        this.finer(pName, String.valueOf(pArg) + ", " + this.asString(pArgs));
    }

    public boolean isFinerEnabled() {
        return true;
    }

    public void finer(String pName, String pArg) {
        this.log.debug((CharSequence)(String.valueOf(this.asName(pName)) + ": " + pArg));
    }

    public void finer(String pName, String pArg1, Object pArg2) {
        this.finer(pName, String.valueOf(pArg1) + ", " + pArg2);
    }

    public boolean isFineEnabled() {
        return true;
    }

    public void fine(String pName, String pArg, Object[] pArgs) {
        this.fine(pName, String.valueOf(pArg) + ", " + this.asString(pArgs));
    }

    public void fine(String pName, String pArg) {
        this.log.debug((CharSequence)(String.valueOf(this.asName(pName)) + ": " + pArg));
    }

    public void fine(String pName, String pArg1, Object pArg2) {
        this.fine(pName, String.valueOf(pArg1) + ", " + pArg2);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(String pName, String pArg, Object[] pArgs) {
        this.info(pName, String.valueOf(pArg) + ", " + this.asString(pArgs));
    }

    public void info(String pName, String pArg) {
        this.log.info((CharSequence)(String.valueOf(this.asName(pName)) + ": " + pArg));
    }

    public void info(String pName, String pArg1, Object pArg2) {
        this.info(pName, String.valueOf(pArg1) + ", " + pArg2);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String pName, String pArg, Object[] pArgs) {
        this.warn(pName, String.valueOf(pArg) + ", " + this.asString(pArgs));
    }

    public void warn(String pName, String pArg) {
        this.log.warn((CharSequence)(String.valueOf(pName) + ": " + pArg));
    }

    public void warn(String pName, String pArg1, Object pArg2) {
        this.warn(pName, String.valueOf(pArg1) + ", " + pArg2);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String pName, String pArg, Object[] pArgs) {
        this.error(pName, String.valueOf(pArg) + ", " + this.asString(pArgs));
    }

    public void error(String pName, String pArg) {
        this.log.error((CharSequence)(String.valueOf(this.asName(pName)) + ": " + pArg));
    }

    public void error(String pName, String pArg1, Object pArg2) {
        this.error(pName, String.valueOf(pArg1) + ", " + pArg2);
    }
}

