/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.ws.jaxme.generator.SchemaReader;
import org.apache.ws.jaxme.generator.impl.GeneratorImpl;
import org.apache.ws.jaxme.generator.sg.SGFactoryChain;
import org.apache.ws.jaxme.generator.sg.impl.JAXBSchemaReader;
import org.apache.ws.jaxme.generator.sg.impl.JaxMeSchemaReader;
import org.apache.ws.jaxme.logging.Logger;
import org.apache.ws.jaxme.logging.LoggerAccess;
import org.apache.ws.jaxme.logging.LoggerFactory;
import org.apache.ws.jaxme.maven.plugins.MavenProjectLogger;
import org.codehaus.plexus.util.DirectoryScanner;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JaxMeGoal
extends AbstractMojo {
    private String[] bindings;
    private List classpathElements;
    private String[] depends;
    private boolean extension;
    private boolean force;
    private String packageName;
    private String[] produces;
    private MavenProject project;
    private Map properties;
    private boolean readOnly;
    private boolean removingOldOutput;
    private String schemaReader;
    private String[] schemas;
    private String[] sgFactoryChain;
    private String srcTarget;
    private String resourceTarget;
    private boolean validating;

    protected String[] getBindings() {
        return this.bindings;
    }

    protected List getClasspathElements() {
        return this.classpathElements;
    }

    protected String[] getDepends() {
        return this.depends;
    }

    protected boolean isExtension() {
        return this.extension;
    }

    protected boolean isForce() {
        return this.force;
    }

    protected String getPackageName() {
        return this.packageName;
    }

    protected String[] getProduces() {
        return this.produces;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Map getProperties() {
        return this.properties;
    }

    protected boolean isReadOnly() {
        return this.readOnly;
    }

    protected boolean isRemovingOldOutput() {
        return this.removingOldOutput;
    }

    protected String getSchemaReader() {
        return this.schemaReader;
    }

    protected String[] getSgFactoryChain() {
        return this.sgFactoryChain;
    }

    protected String getSrcTarget() {
        return this.srcTarget;
    }

    protected String getResourceTarget() {
        return this.resourceTarget;
    }

    protected boolean isValidating() {
        return this.validating;
    }

    private File[] getProducedFiles() {
        String[] prdcs = this.getProduces();
        if (prdcs == null) {
            String t1 = this.getSrcTarget();
            String t2 = this.getResourceTarget();
            prdcs = t2 == null ? new String[]{t1} : new String[]{t1, t2};
        }
        return this.getFiles(prdcs);
    }

    private File[] getFiles(String[] pSpec) {
        if (pSpec == null || pSpec.length == 0) {
            return new File[0];
        }
        DirectoryScanner ds = new DirectoryScanner();
        File baseDir = this.getProject().getBasedir();
        ds.setBasedir(baseDir);
        ds.setIncludes(pSpec);
        ds.scan();
        String[] files = ds.getIncludedFiles();
        File[] result = new File[files.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new File(baseDir, files[i]);
            ++i;
        }
        return result;
    }

    private File[] getSchemaFiles() {
        File[] schemaFiles;
        if (this.schemas == null || this.schemas.length == 0) {
            this.schemas = new String[]{"src/jaxme/*.xsd"};
        }
        if ((schemaFiles = this.getFiles(this.schemas)).length == 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("Schema specification returns no result: ");
            int i = 0;
            while (i < this.schemas.length) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(this.schemas[i]);
                ++i;
            }
            this.getLog().warn((CharSequence)sb);
        }
        return schemaFiles;
    }

    private File[] getBindingFiles() {
        return this.getFiles(this.getBindings());
    }

    private File[] getDependencies() {
        return this.getFiles(this.getDepends());
    }

    private boolean isUptodate(File[] pSourceFiles, File[] pProducedFiles) {
        if (this.isForce()) {
            this.getLog().debug((CharSequence)"Force flag set, disabling uptodate check.");
            return false;
        }
        if (pProducedFiles.length == 0) {
            this.getLog().debug((CharSequence)"No produced files found, disabling uptodate check.");
            return false;
        }
        File minProducedFile = null;
        long minProducedTime = 0L;
        int i = 0;
        while (i < pProducedFiles.length) {
            File f = pProducedFiles[i];
            long l = f.lastModified();
            if (l == 0L) {
                this.getLog().debug((CharSequence)("Produced file " + f + " has unknown timestamp, disabling uptodate check."));
                return false;
            }
            if (minProducedTime == 0L || minProducedTime > l) {
                minProducedTime = l;
                minProducedFile = f;
            }
            ++i;
        }
        File[] deps = pSourceFiles;
        long maxDepTime = 0L;
        File maxDepFile = null;
        int i2 = 0;
        while (i2 < deps.length) {
            File f = deps[i2];
            long l = f.lastModified();
            if (l == 0L) {
                this.getLog().debug((CharSequence)("Dependency file " + f + " has unknown timestamp, disabling uptodate check."));
                return false;
            }
            if (maxDepTime == 0L || maxDepTime < l) {
                maxDepTime = l;
                maxDepFile = f;
            }
            ++i2;
        }
        if (maxDepTime >= minProducedTime) {
            this.getLog().debug((CharSequence)("Dependency file " + maxDepFile + " is more recent than produced file " + minProducedFile));
            return true;
        }
        this.getLog().debug((CharSequence)"All produced files are uptodate.");
        return false;
    }

    private File[] concat(File[] pFiles1, File[] pFiles2) {
        File[] deps = new File[pFiles1.length + pFiles2.length];
        System.arraycopy(pFiles1, 0, deps, 0, pFiles1.length);
        System.arraycopy(pFiles2, 0, deps, pFiles1.length, pFiles2.length);
        return deps;
    }

    private void removeOldOutput(File[] pProducedFiles) throws MojoExecutionException {
        if (this.isRemovingOldOutput()) {
            int i = 0;
            while (i < pProducedFiles.length) {
                File f = pProducedFiles[i];
                if (f.isFile() && !f.delete()) {
                    throw new MojoExecutionException("Unable to delete file: " + f.getAbsolutePath());
                }
                ++i;
            }
        }
    }

    private Class getSgFactoryChainClass(String pClass) throws MojoFailureException {
        Class<?> c;
        try {
            c = Thread.currentThread().getContextClassLoader().loadClass(pClass);
        }
        catch (ClassNotFoundException e) {
            throw new MojoFailureException("The factory chain class " + pClass + " was not found.");
        }
        if (!SGFactoryChain.class.isAssignableFrom(c)) {
            throw new MojoFailureException("The factory chain class " + c.getName() + " is not implementing " + SGFactoryChain.class);
        }
        return c;
    }

    private ClassLoader getClassLoader(ClassLoader pParent) throws MojoFailureException {
        List clElements = this.getClasspathElements();
        if (clElements == null && clElements.size() == 0) {
            return pParent;
        }
        URL[] urls = new URL[clElements.size()];
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < clElements.size()) {
            String elem = (String)clElements.get(i);
            File f = new File(elem);
            if (!f.isAbsolute()) {
                f = new File(this.getProject().getBasedir(), elem);
            }
            try {
                urls[i] = f.toURL();
            }
            catch (MalformedURLException e) {
                throw new MojoFailureException("Invalid classpath element: " + elem);
            }
            if (i > 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(urls[i]);
            ++i;
        }
        this.getLog().debug((CharSequence)("Using classpath " + sb));
        return new URLClassLoader(urls, pParent);
    }

    private SchemaReader getSchemaReaderInstance() throws MojoFailureException, MojoExecutionException {
        SchemaReader result = this.newSchemaReaderInstance();
        this.getLog().debug((CharSequence)("Schema reader class: " + result.getClass().getName()));
        String[] chains = this.getSgFactoryChain();
        if (chains != null) {
            int i = 0;
            while (i < chains.length) {
                Class c = this.getSgFactoryChainClass(chains[i]);
                this.getLog().debug((CharSequence)("Adding SG Factory chain: " + c.getName()));
                result.addSGFactoryChain(c);
                ++i;
            }
        }
        return result;
    }

    private SchemaReader newSchemaReaderInstance() throws MojoFailureException, MojoExecutionException {
        Object result;
        String s = this.getSchemaReader();
        if (s == null || s.length() == 0) {
            result = this.isExtension() ? new JaxMeSchemaReader() : new JAXBSchemaReader();
        } else {
            Object o;
            Class<?> c;
            try {
                c = Thread.currentThread().getContextClassLoader().loadClass(s);
            }
            catch (ClassNotFoundException e) {
                throw new MojoFailureException("The schema reader class " + s + " was not found.");
            }
            try {
                o = c.newInstance();
            }
            catch (InstantiationException e) {
                throw new MojoExecutionException("Failed to instantiate schema reader class " + c.getName(), (Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new MojoExecutionException("Illegal access to schema reader class " + c.getName(), (Exception)e);
            }
            try {
                result = (SchemaReader)o;
            }
            catch (ClassCastException e) {
                throw new MojoFailureException("The configured schema reader class " + c.getName() + " is not implementing " + SchemaReader.class.getName());
            }
        }
        return result;
    }

    private File getSrcTargetDirectory() {
        return this.getTargetDir(this.getSrcTarget());
    }

    private File getTargetDir(String pDir) {
        File f = new File(pDir);
        if (!f.isAbsolute()) {
            f = new File(this.getProject().getBasedir(), this.getSrcTarget());
        }
        return f;
    }

    private File getResourceTargetDirectory() {
        return this.getTargetDir(this.getResourceTarget());
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader(SchemaReader.class.getClassLoader()));
        LoggerFactory lf = LoggerAccess.getLoggerFactory();
        try {
            LoggerAccess.setLoggerFactory((LoggerFactory)new LoggerFactory(){

                public Logger getLogger(String pName) {
                    return new MavenProjectLogger(JaxMeGoal.this.getLog(), pName);
                }
            });
            File[] schemaFiles = this.getSchemaFiles();
            if (schemaFiles.length == 0) {
                return;
            }
            File[] producedFiles = this.getProducedFiles();
            File[] dependencies = this.getDependencies();
            File[] bindingFiles = this.getBindingFiles();
            boolean uptodate = this.isUptodate(this.concat(this.concat(schemaFiles, dependencies), bindingFiles), producedFiles);
            if (uptodate) {
                this.getLog().info((CharSequence)"Generated files are uptodate.");
                return;
            }
            this.removeOldOutput(producedFiles);
            GeneratorImpl g = new GeneratorImpl();
            int i = 0;
            while (i < bindingFiles.length) {
                File f = bindingFiles[i];
                try {
                    g.addBindings(new InputSource(f.toURL().toExternalForm()));
                }
                catch (ParserConfigurationException e) {
                    throw new MojoExecutionException("Failed to add binding file " + f.getPath() + ": " + e.getMessage(), (Exception)e);
                }
                catch (SAXException e) {
                    throw new MojoExecutionException("Failed to add binding file " + f.getPath() + ": " + e.getMessage(), (Exception)e);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to add binding file " + f.getPath() + ": " + e.getMessage(), (Exception)e);
                }
                ++i;
            }
            i = 0;
            while (i < schemaFiles.length) {
                SchemaReader reader = this.getSchemaReaderInstance();
                g.setSchemaReader(reader);
                g.setForcingOverwrite(this.isForce());
                g.setSettingReadOnly(this.isReadOnly());
                g.setTargetDirectory(this.getSrcTargetDirectory());
                g.setResourceTargetDirectory(this.getResourceTargetDirectory());
                g.setValidating(this.isValidating());
                Map props = this.getProperties();
                if (props != null) {
                    for (Map.Entry entry : props.entrySet()) {
                        g.setProperty((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                try {
                    g.generate(schemaFiles[i]);
                }
                catch (Exception e) {
                    throw new MojoExecutionException(e.getMessage(), e);
                }
                ++i;
            }
            this.getProject().addCompileSourceRoot(this.getSrcTarget());
            Resource resource = new Resource();
            resource.setDirectory(this.getResourceTarget());
            this.getProject().addResource(resource);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
            LoggerAccess.setLoggerFactory((LoggerFactory)lf);
        }
    }
}

