/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.pm.generator.jdbc;

import org.apache.ws.jaxme.pm.generator.jdbc.JaxMeJdbcSG;
import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.apache.ws.jaxme.xs.xml.XsObject;
import org.apache.ws.jaxme.xs.xml.impl.XsObjectImpl;
import org.xml.sax.SAXException;

public class ConnectionDetails
extends XsObjectImpl {
    private final JaxMeJdbcSG jdbcSG;
    private JaxMeJdbcSG.Mode mode;
    private String driver;
    private String url;
    private String user;
    private String password;
    private String datasource;
    private Boolean usingDatasource;

    protected ConnectionDetails(JaxMeJdbcSG pJdbcSG, XsObject pParent) {
        super(pParent);
        this.jdbcSG = pJdbcSG;
    }

    public void setDriver(String pDriver) {
        this.driver = pDriver;
    }

    public String getDriver() {
        return this.jdbcSG.getSGFactory().getGenerator().getProperty("jdbc.driver", this.driver);
    }

    public void setUrl(String pUrl) {
        this.url = pUrl;
    }

    public String getUrl() {
        return this.jdbcSG.getSGFactory().getGenerator().getProperty("jdbc.url", this.url);
    }

    public void setUser(String pUser) {
        this.user = pUser;
    }

    public String getUser() {
        return this.jdbcSG.getSGFactory().getGenerator().getProperty("jdbc.user", this.user);
    }

    public void setPassword(String pPassword) {
        this.password = pPassword;
    }

    public String getPassword() {
        return this.jdbcSG.getSGFactory().getGenerator().getProperty("jdbc.password", this.password);
    }

    public void setDatasource(String pDatasource) {
        this.datasource = pDatasource;
    }

    public String getDatasource() {
        return this.jdbcSG.getSGFactory().getGenerator().getProperty("jdbc.datasource", this.datasource);
    }

    public void setUsingDatasource(Boolean pUsingDatasource) {
        this.usingDatasource = pUsingDatasource;
    }

    public Boolean isUsingDatasource() {
        String s = this.jdbcSG.getSGFactory().getGenerator().getProperty("jdbc.usingDatasource");
        return s == null ? this.usingDatasource : Boolean.valueOf(s);
    }

    public void setDbMode(String pMode) {
        this.mode = JaxMeJdbcSG.Mode.valueOf(pMode);
    }

    public JaxMeJdbcSG.Mode getDbMode() {
        String s = this.jdbcSG.getSGFactory().getGenerator().getProperty("jdbc.dbMode");
        return s == null ? this.mode : JaxMeJdbcSG.Mode.valueOf(s);
    }

    public void cloneFrom(ConnectionDetails pFrom) {
        this.mode = pFrom.mode;
        this.driver = pFrom.driver;
        this.url = pFrom.url;
        this.user = pFrom.user;
        this.password = pFrom.password;
        this.datasource = pFrom.datasource;
        this.usingDatasource = pFrom.usingDatasource;
    }

    public void validate() throws SAXException {
        boolean datasourceIsSet;
        boolean driverIsSet = this.driver != null && this.driver.length() > 0;
        boolean bl = datasourceIsSet = this.datasource != null && this.datasource.length() > 0;
        if (driverIsSet) {
            if (!datasourceIsSet) {
                throw new LocSAXException("Either of the 'driver' or 'datasource' attributes must be set.", this.getLocator());
            }
            if (this.url == null && this.url.length() == 0) {
                throw new LocSAXException("Missing attribute: 'url'", this.getLocator());
            }
        }
        if (driverIsSet && datasourceIsSet) {
            throw new LocSAXException("The 'driver' and 'datasource' attributes are mutually exclusive.", this.getLocator());
        }
    }
}

