/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.pm.ino.api4j;

import com.softwareag.tamino.db.api.objectModel.sax.TSAXElement;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXElementDefaultHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.ws.jaxme.pm.ino.InoObject;
import org.apache.ws.jaxme.pm.ino.api4j.DocumentDefaultHandler;
import org.apache.ws.jaxme.pm.ino.api4j.TJMElement;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ElementDefaultHandler
extends TSAXElementDefaultHandler {
    static ThreadLocal data = new ThreadLocal();

    static void initData() {
        data.set(new Data());
    }

    static void resetData() {
        data.set(null);
    }

    private Data getData() {
        return (Data)data.get();
    }

    public TSAXElement getFirstElement() {
        List result = this.getData().result;
        if (result.size() > 0) {
            return new TJMElement((InoObject)result.get(0));
        }
        return null;
    }

    public Iterator getElementIterator() {
        return new Iterator(){
            Iterator inner;
            {
                this.inner = ((ElementDefaultHandler)ElementDefaultHandler.this).getData().result.iterator();
            }

            public void remove() {
                this.inner.remove();
            }

            public boolean hasNext() {
                return this.inner.hasNext();
            }

            public Object next() {
                return new TJMElement((InoObject)this.inner.next());
            }
        };
    }

    public void startDocument() throws SAXException {
        Data d = this.getData();
        d.iHaveCreatedStartDocument = false;
        d.inDocument = true;
        DocumentDefaultHandler.getUnmarshallerHandler().startDocument();
    }

    public void endDocument() throws SAXException {
        Data d = this.getData();
        if (d.inDocument) {
            DocumentDefaultHandler.getUnmarshallerHandler().endDocument();
            try {
                d.result.add(DocumentDefaultHandler.getUnmarshallerHandler().getResult());
            }
            catch (JAXBException e) {
                throw new SAXException((Exception)((Object)e));
            }
            d.inDocument = false;
            d.iHaveCreatedStartDocument = false;
        }
    }

    public void startElement(String pNamespaceURI, String pLocalName, String pQName, Attributes pAttr) throws SAXException {
        Data d = this.getData();
        if (d.level++ == 0 && !d.inDocument) {
            this.startDocument();
            d.iHaveCreatedStartDocument = true;
        }
        DocumentDefaultHandler.getUnmarshallerHandler().startElement(pNamespaceURI, pLocalName, pQName, pAttr);
    }

    public void endElement(String pNamespaceURI, String pLocalName, String pQName) throws SAXException {
        Data d = this.getData();
        DocumentDefaultHandler.getUnmarshallerHandler().endElement(pNamespaceURI, pLocalName, pQName);
        if (--d.level == 0 && d.iHaveCreatedStartDocument) {
            this.endDocument();
        }
    }

    public void characters(char[] pBuffer, int pOffset, int pLen) throws SAXException {
        Data d = this.getData();
        if (d.inDocument) {
            DocumentDefaultHandler.getUnmarshallerHandler().characters(pBuffer, pOffset, pLen);
        }
    }

    public void ignorableWhitespace(char[] pBuffer, int pOffset, int pLen) throws SAXException {
        Data d = this.getData();
        if (d.inDocument) {
            DocumentDefaultHandler.getUnmarshallerHandler().ignorableWhitespace(pBuffer, pOffset, pLen);
        }
    }

    public void processingInstruction(String pTarget, String pData) throws SAXException {
        Data d = this.getData();
        if (d.inDocument) {
            DocumentDefaultHandler.getUnmarshallerHandler().processingInstruction(pTarget, pData);
        }
    }

    public void skippedEntity(String pEntity) throws SAXException {
        Data d = this.getData();
        if (d.inDocument) {
            DocumentDefaultHandler.getUnmarshallerHandler().skippedEntity(pEntity);
        }
    }

    public void endPrefixMapping(String pPrefix) throws SAXException {
        Data d = this.getData();
        if (d.inDocument) {
            DocumentDefaultHandler.getUnmarshallerHandler().endPrefixMapping(pPrefix);
        }
    }

    public void startPrefixMapping(String pPrefix, String pNamespaceURI) throws SAXException {
        Data d = this.getData();
        if (d.inDocument) {
            DocumentDefaultHandler.getUnmarshallerHandler().startPrefixMapping(pPrefix, pNamespaceURI);
        }
    }

    public void setDocumentLocator(Locator pLocator) {
        Data d = this.getData();
        if (d.inDocument) {
            DocumentDefaultHandler.getUnmarshallerHandler().setDocumentLocator(pLocator);
        }
    }

    static class Data {
        int level = 0;
        boolean inDocument = false;
        boolean iHaveCreatedStartDocument = false;
        final List result = new ArrayList();

        Data() {
        }
    }
}

