/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.impl;

import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.PrintConversionEventImpl;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import org.apache.ws.jaxme.impl.JMMarshallerImpl;
import org.apache.ws.jaxme.impl.JMSAXDriver;
import org.apache.ws.jaxme.util.NamespaceSupport;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JMSAXDriverController {
    private static final Attributes ZERO_ATTRIBUTES = new AttributesImpl();
    private final JMMarshallerImpl marshaller;
    private final DatatypeConverterInterface converter;
    private final ContentHandler target;
    private final NamespaceSupport nss = new NamespaceSupport();
    private int cnt;

    public JMMarshallerImpl getJMMarshaller() {
        return this.marshaller;
    }

    public ContentHandler getTarget() {
        return this.target;
    }

    public NamespaceSupport getNamespaceContext() {
        return this.nss;
    }

    public JMSAXDriverController(JMMarshallerImpl pMarshaller, ContentHandler pTarget) throws SAXException {
        this.marshaller = pMarshaller;
        this.target = pTarget;
        this.converter = this.marshaller.getDatatypeConverter();
    }

    public DatatypeConverterInterface getDatatypeConverter() {
        return this.converter;
    }

    protected String getNewPrefix(String pURI, String pSuggestedPrefix) {
        if (pSuggestedPrefix == null || pSuggestedPrefix.length() == 0) {
            if (!this.nss.isPrefixDeclared("")) {
                this.nss.declarePrefix("", pURI);
                return "";
            }
            pSuggestedPrefix = "p";
        }
        String pc = pSuggestedPrefix;
        while (true) {
            if (!this.nss.isPrefixDeclared(pc)) {
                this.nss.declarePrefix(pc, pURI);
                return pc;
            }
            pc = pSuggestedPrefix + ++this.cnt;
        }
    }

    protected String getPreferredPrefix(JMSAXDriver pDriver, String pURI) {
        String prefix;
        if (pDriver != null && (prefix = pDriver.getPreferredPrefix(pURI)) != null) {
            return prefix;
        }
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(pURI)) {
            return "xsi";
        }
        return null;
    }

    protected String getElementQName(JMSAXDriver pDriver, String pPrefix, String pNamespaceURI, String pLocalName) throws SAXException {
        String prefix;
        if (pNamespaceURI == null) {
            pNamespaceURI = "";
        }
        if ((prefix = this.nss.getPrefix(pNamespaceURI)) == null) {
            prefix = pPrefix != null ? pPrefix : this.getNewPrefix(pNamespaceURI, this.getPreferredPrefix(pDriver, pNamespaceURI));
            this.nss.declarePrefix(prefix, pNamespaceURI);
            this.getTarget().startPrefixMapping(prefix, pNamespaceURI);
        }
        if (prefix == null || "".equals(prefix)) {
            return pLocalName;
        }
        return prefix + ":" + pLocalName;
    }

    public String getElementQName(JMSAXDriver pDriver, String pNamespaceURI, String pLocalName) throws SAXException {
        String prefix;
        if (pNamespaceURI == null) {
            pNamespaceURI = "";
        }
        if ((prefix = this.nss.getPrefix(pNamespaceURI)) == null) {
            prefix = this.getNewPrefix(pNamespaceURI, this.getPreferredPrefix(pDriver, pNamespaceURI));
            this.nss.declarePrefix(prefix, pNamespaceURI);
            this.getTarget().startPrefixMapping(prefix, pNamespaceURI);
        }
        if (prefix == null || "".equals(prefix)) {
            return pLocalName;
        }
        return prefix + ":" + pLocalName;
    }

    public String getAttrQName(JMSAXDriver pDriver, String pNamespaceURI, String pLocalName) throws SAXException {
        String prefix;
        if (pNamespaceURI == null) {
            pNamespaceURI = "";
        }
        if ((prefix = this.nss.getAttributePrefix(pNamespaceURI)) == null) {
            prefix = this.getPreferredPrefix(pDriver, pNamespaceURI);
            if (prefix == null) {
                prefix = this.getNewPrefix(pNamespaceURI, "p");
            }
            this.getTarget().startPrefixMapping(prefix, pNamespaceURI);
        }
        if (prefix == null || "".equals(prefix)) {
            return pLocalName;
        }
        return prefix + ":" + pLocalName;
    }

    protected void addSchemaLocationAttributes(JMSAXDriver pDriver, AttributesImpl pAttrs) throws SAXException {
        JMMarshallerImpl m = this.getJMMarshaller();
        String schemaLocation = m.getSchemaLocation();
        String schemaLocationAttribute = schemaLocation != null ? "schemaLocation" : ((schemaLocation = m.getNoNamespaceSchemaLocation()) != null ? "noNamespaceSchemaLocation" : null);
        if (schemaLocation != null) {
            String qName = this.getAttrQName(pDriver, "http://www.w3.org/2001/XMLSchema-instance", schemaLocationAttribute);
            pAttrs.addAttribute("http://www.w3.org/2001/XMLSchema-instance", schemaLocationAttribute, qName, "CDATA", schemaLocation);
        }
    }

    public void marshal(JMSAXDriver pDriver, String pPrefix, String pNamespaceURI, String pLocalName, Object pElement) throws SAXException {
        int context = this.nss.getContext();
        String qName = this.getElementQName(pDriver, pPrefix, pNamespaceURI, pLocalName);
        AttributesImpl attrs = pDriver.getAttributes(this, pElement);
        this.addSchemaLocationAttributes(pDriver, attrs);
        ContentHandler h = this.getTarget();
        h.startElement(pNamespaceURI, pLocalName, qName, attrs);
        pDriver.marshalChilds(this, h, pElement);
        h.endElement(pNamespaceURI, pLocalName, qName);
        this.restoreContext(context);
    }

    public void marshal(JMSAXDriver pDriver, String pNamespaceURI, String pLocalName, Object pElement) throws SAXException {
        int context = this.nss.getContext();
        String qName = this.getElementQName(pDriver, pNamespaceURI, pLocalName);
        AttributesImpl attrs = pDriver.getAttributes(this, pElement);
        ContentHandler h = this.getTarget();
        h.startElement(pNamespaceURI, pLocalName, qName, attrs);
        pDriver.marshalChilds(this, h, pElement);
        h.endElement(pNamespaceURI, pLocalName, qName);
        this.restoreContext(context);
    }

    public void marshalSimpleChild(JMSAXDriver pDriver, String pNamespaceURI, String pLocalName, String pValue) throws SAXException {
        int context = this.nss.getContext();
        String qName = this.getElementQName(pDriver, pNamespaceURI, pLocalName);
        ContentHandler h = this.getTarget();
        h.startElement(pNamespaceURI, pLocalName, qName, ZERO_ATTRIBUTES);
        if (pValue != null && pValue.length() > 0) {
            h.characters(pValue.toCharArray(), 0, pValue.length());
        }
        h.endElement(pNamespaceURI, pLocalName, qName);
        this.restoreContext(context);
    }

    private void restoreContext(int pContext) throws SAXException {
        NamespaceSupport nss = this.getNamespaceContext();
        ContentHandler h = this.getTarget();
        String prefix;
        while ((prefix = nss.checkContext(pContext)) != null) {
            h.endPrefixMapping(prefix);
        }
        return;
    }

    public void printConversionEvent(Object pObject, String pMsg, Exception pException) throws SAXException {
        ValidationEventLocatorImpl locator;
        PrintConversionEventImpl event;
        ValidationEventHandler handler = this.getJMMarshaller().getEventHandler();
        if (handler != null && handler.handleEvent((ValidationEvent)(event = new PrintConversionEventImpl(2, pMsg, (ValidationEventLocator)(locator = new ValidationEventLocatorImpl(pObject)))))) {
            return;
        }
        throw new SAXException(pMsg, pException);
    }
}

