/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.buildutils.shade.axiomxml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class DOMUtils {
    private DOMUtils() {
    }

    public static Document parse(InputStream is) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            return factory.newDocumentBuilder().parse(is);
        }
        catch (SAXException ex) {
            throw DOMUtils.toIOException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw DOMUtils.toIOException(ex);
        }
    }

    public static void serialize(Document document, OutputStream os) throws IOException {
        try {
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document), new StreamResult(os));
        }
        catch (TransformerException ex) {
            throw DOMUtils.toIOException(ex);
        }
    }

    private static IOException toIOException(Exception ex) {
        IOException ioException = new IOException();
        ioException.initCause(ex);
        return ioException;
    }
}

