/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.buildutils.shade.axiomxml;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.axiom.buildutils.shade.axiomxml.DOMUtils;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AxiomXmlResourceTransformer
implements ResourceTransformer {
    private static final String AXIOM_XML = "META-INF/axiom.xml";
    private Document mergedAxiomXml;

    public boolean canTransformResource(String resource) {
        return resource.equals(AXIOM_XML);
    }

    public boolean hasTransformedResource() {
        return this.mergedAxiomXml != null;
    }

    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
        Document axiomXml = DOMUtils.parse(is);
        is.close();
        NodeList implementations = axiomXml.getElementsByTagNameNS("http://ws.apache.org/axiom/", "implementation");
        block0: for (int i = 0; i < implementations.getLength(); ++i) {
            Element implementation = (Element)implementations.item(i);
            String loader = implementation.getAttributeNS(null, "loader");
            for (Relocator relocator : relocators) {
                if (!relocator.canRelocateClass(loader)) continue;
                implementation.setAttributeNS(null, "loader", relocator.relocateClass(loader));
                continue block0;
            }
        }
        if (this.mergedAxiomXml == null) {
            this.mergedAxiomXml = axiomXml;
        } else {
            for (Node node = axiomXml.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
                this.mergedAxiomXml.getDocumentElement().appendChild(this.mergedAxiomXml.importNode(node, true));
            }
        }
    }

    public void modifyOutputStream(JarOutputStream os) throws IOException {
        os.putNextEntry(new JarEntry(AXIOM_XML));
        DOMUtils.serialize(this.mergedAxiomXml, os);
    }
}

