/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.buildutils.javadoc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;

@Mojo(name="post-process")
public class PostProcessMojo
extends AbstractMojo {
    @Component
    private SiteTool siteTool;
    @Parameter(property="locales")
    private String locales;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    private List<ArtifactRepository> repositories;
    @Parameter(defaultValue="${basedir}/src/site")
    private File siteDirectory;
    @Parameter(required=true)
    private File javadocDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        DecorationModel decorationModel;
        try {
            decorationModel = this.siteTool.getDecorationModel(this.project, this.reactorProjects, this.localRepository, this.repositories, this.siteTool.getRelativePath(this.siteDirectory.getAbsolutePath(), this.project.getBasedir().getAbsolutePath()), (Locale)this.siteTool.getAvailableLocales(this.locales).get(0));
        }
        catch (SiteToolException ex) {
            throw new MojoExecutionException("SiteToolException: " + ex.getMessage(), (Exception)((Object)ex));
        }
        StringWriter sw = new StringWriter();
        PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter((Writer)sw, null, null);
        for (Xpp3Dom element : ((Xpp3Dom)decorationModel.getBody().getHead()).getChildren()) {
            Xpp3DomWriter.write((XMLWriter)xmlWriter, (Xpp3Dom)element, (!element.getName().equals("script") ? 1 : 0) != 0);
        }
        String headElements = sw.toString();
        DirectoryScanner ds = new DirectoryScanner();
        ds.setIncludes(new String[]{"**/*.html"});
        ds.setBasedir(this.javadocDirectory);
        ds.scan();
        for (String relativePath : ds.getIncludedFiles()) {
            File file = new File(this.javadocDirectory, relativePath);
            File tmpFile = new File(this.javadocDirectory, relativePath + ".tmp");
            file.renameTo(tmpFile);
            try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tmpFile), "UTF-8"));
                 PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
                String line;
                while ((line = in.readLine()) != null) {
                    if (line.equals("</head>")) {
                        out.println(headElements);
                    }
                    out.println(line);
                }
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to process " + relativePath + ": " + ex.getMessage(), (Exception)ex);
            }
            tmpFile.delete();
        }
    }
}

