/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom.element;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.ts.dom.DOMTestCase;
import org.apache.axiom.ts.dom.DOMUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestSetAttributeNSInvalid
extends DOMTestCase {
    private final QName qname;

    public TestSetAttributeNSInvalid(DocumentBuilderFactory dbf, QName qname) {
        super(dbf);
        this.qname = qname;
        this.addTestProperty("ns", qname.getNamespaceURI());
        this.addTestProperty("name", DOMUtils.getQualifiedName(qname));
    }

    protected void runTest() throws Throwable {
        Document document = this.dbf.newDocumentBuilder().newDocument();
        Element element = document.createElementNS(null, "test");
        try {
            element.setAttributeNS(DOMUtils.getNamespaceURI(this.qname), DOMUtils.getQualifiedName(this.qname), "value");
            TestSetAttributeNSInvalid.fail((String)"Expected DOMException");
        }
        catch (DOMException ex) {
            TestSetAttributeNSInvalid.assertEquals((short)14, (short)ex.code);
        }
    }
}

