/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom.document;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.axiom.ts.dom.document.TransformerTestCase;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestTransformerWithIdentityStylesheet
extends TransformerTestCase {
    public TestTransformerWithIdentityStylesheet(DocumentBuilderFactory dbf, Class transformerFactoryClass) {
        super(dbf, transformerFactoryClass);
    }

    protected void runTest() throws Throwable {
        DocumentBuilder builder = this.dbf.newDocumentBuilder();
        Document document = builder.newDocument();
        Element root = document.createElement("root");
        Element element = document.createElementNS("urn:mynamespace", "element1");
        element.setAttribute("att", "testValue");
        element.appendChild(document.createTextNode("test"));
        root.appendChild(element);
        document.appendChild(root);
        Document stylesheet = builder.parse(TestTransformerWithIdentityStylesheet.class.getResourceAsStream("identity.xslt"));
        Document output = builder.newDocument();
        Transformer transformer = ((TransformerFactory)this.transformerFactoryClass.newInstance()).newTransformer(new DOMSource(stylesheet));
        transformer.transform(new DOMSource(document), new DOMResult(output));
        XMLAssert.assertXMLIdentical((Diff)XMLUnit.compareXML((Document)document, (Document)output), (boolean)true);
    }
}

