/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom.document;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.ts.dom.DOMTestCase;
import org.apache.axiom.ts.dom.DOMUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

public class TestCreateAttributeNS
extends DOMTestCase {
    private final QName qname;

    public TestCreateAttributeNS(DocumentBuilderFactory dbf, QName qname) {
        super(dbf);
        this.qname = qname;
        this.addTestProperty("ns", qname.getNamespaceURI());
        this.addTestProperty("name", DOMUtils.getQualifiedName(qname));
    }

    protected void runTest() throws Throwable {
        String localName = this.qname.getLocalPart();
        String uri = DOMUtils.getNamespaceURI(this.qname);
        String prefix = DOMUtils.getPrefix(this.qname);
        String name = DOMUtils.getQualifiedName(this.qname);
        Document doc = this.dbf.newDocumentBuilder().newDocument();
        Attr attr = doc.createAttributeNS(uri, name);
        TestCreateAttributeNS.assertEquals((String)"Attr name mismatch", (String)localName, (String)attr.getLocalName());
        TestCreateAttributeNS.assertEquals((String)"NamsspaceURI mismatch", (String)uri, (String)attr.getNamespaceURI());
        TestCreateAttributeNS.assertEquals((String)"namespace prefix mismatch", (String)prefix, (String)attr.getPrefix());
        TestCreateAttributeNS.assertEquals((String)name, (String)attr.getName());
        TestCreateAttributeNS.assertSame((Object)doc, (Object)attr.getOwnerDocument());
        TestCreateAttributeNS.assertNull((Object)attr.getOwnerElement());
        TestCreateAttributeNS.assertNull((Object)attr.getFirstChild());
        TestCreateAttributeNS.assertEquals((String)"", (String)attr.getValue());
    }
}

