/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom.attr;

import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.ts.dom.DOMTestCase;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TestCloneNode
extends DOMTestCase {
    private final boolean deep;

    public TestCloneNode(DocumentBuilderFactory dbf, boolean deep) {
        super(dbf);
        this.deep = deep;
        this.addTestProperty("deep", String.valueOf(deep));
    }

    protected void runTest() throws Throwable {
        Document document = this.dbf.newDocumentBuilder().newDocument();
        Attr attr = document.createAttributeNS(null, "attr");
        attr.appendChild(document.createTextNode("foo"));
        attr.appendChild(document.createTextNode("bar"));
        Attr clone = (Attr)attr.cloneNode(this.deep);
        Node child = clone.getFirstChild();
        TestCloneNode.assertNotNull((Object)child);
        TestCloneNode.assertEquals((short)3, (short)child.getNodeType());
        TestCloneNode.assertEquals((String)"foo", (String)child.getNodeValue());
        child = child.getNextSibling();
        TestCloneNode.assertEquals((short)3, (short)child.getNodeType());
        TestCloneNode.assertEquals((String)"bar", (String)child.getNodeValue());
        TestCloneNode.assertNull((Object)child.getNextSibling());
    }
}

