/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import sun.rmi.registry.RegistryImpl;

@Deprecated
public class JmxRemoteLifecycleListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(JmxRemoteLifecycleListener.class);
    protected static final StringManager sm = StringManager.getManager(JmxRemoteLifecycleListener.class);
    protected String rmiBindAddress = null;
    protected int rmiRegistryPortPlatform = -1;
    protected int rmiServerPortPlatform = -1;
    protected boolean rmiRegistrySSL = true;
    protected boolean rmiServerSSL = true;
    protected String[] ciphers = null;
    protected String[] protocols = null;
    protected boolean clientAuth = true;
    protected boolean authenticate = true;
    protected String passwordFile = null;
    protected String loginModuleName = null;
    protected String accessFile = null;
    protected boolean useLocalPorts = false;
    protected JMXConnectorServer csPlatform = null;

    public String getRmiBindAddress() {
        return this.rmiBindAddress;
    }

    public void setRmiBindAddress(String theRmiBindAddress) {
        this.rmiBindAddress = theRmiBindAddress;
    }

    public int getRmiServerPortPlatform() {
        return this.rmiServerPortPlatform;
    }

    public void setRmiServerPortPlatform(int theRmiServerPortPlatform) {
        this.rmiServerPortPlatform = theRmiServerPortPlatform;
    }

    public int getRmiRegistryPortPlatform() {
        return this.rmiRegistryPortPlatform;
    }

    public void setRmiRegistryPortPlatform(int theRmiRegistryPortPlatform) {
        this.rmiRegistryPortPlatform = theRmiRegistryPortPlatform;
    }

    public boolean getUseLocalPorts() {
        return this.useLocalPorts;
    }

    public void setUseLocalPorts(boolean useLocalPorts) {
        this.useLocalPorts = useLocalPorts;
    }

    private void init() {
        String ciphersValue;
        String rmiRegistrySSLValue = System.getProperty("com.sun.management.jmxremote.registry.ssl", "false");
        this.rmiRegistrySSL = Boolean.parseBoolean(rmiRegistrySSLValue);
        String rmiServerSSLValue = System.getProperty("com.sun.management.jmxremote.ssl", "true");
        this.rmiServerSSL = Boolean.parseBoolean(rmiServerSSLValue);
        String protocolsValue = System.getProperty("com.sun.management.jmxremote.ssl.enabled.protocols");
        if (protocolsValue != null) {
            this.protocols = protocolsValue.split(",");
        }
        if ((ciphersValue = System.getProperty("com.sun.management.jmxremote.ssl.enabled.cipher.suites")) != null) {
            this.ciphers = ciphersValue.split(",");
        }
        String clientAuthValue = System.getProperty("com.sun.management.jmxremote.ssl.need.client.auth", "true");
        this.clientAuth = Boolean.parseBoolean(clientAuthValue);
        String authenticateValue = System.getProperty("com.sun.management.jmxremote.authenticate", "true");
        this.authenticate = Boolean.parseBoolean(authenticateValue);
        this.passwordFile = System.getProperty("com.sun.management.jmxremote.password.file", "jmxremote.password");
        this.accessFile = System.getProperty("com.sun.management.jmxremote.access.file", "jmxremote.access");
        this.loginModuleName = System.getProperty("com.sun.management.jmxremote.login.config");
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_init".equals(event.getType())) {
            log.warn((Object)sm.getString("jmxRemoteLifecycleListener.deprecated"));
        } else if ("start".equals(event.getType())) {
            this.init();
            System.setProperty("java.rmi.server.randomIDs", "true");
            HashMap<String, Object> env = new HashMap<String, Object>();
            RMIClientSocketFactory registryCsf = null;
            RMIServerSocketFactory registrySsf = null;
            RMIClientSocketFactory serverCsf = null;
            RMIServerSocketFactory serverSsf = null;
            if (this.rmiRegistrySSL) {
                registryCsf = new SslRMIClientSocketFactory();
                registrySsf = this.rmiBindAddress == null ? new SslRMIServerSocketFactory(this.ciphers, this.protocols, this.clientAuth) : new SslRmiServerBindSocketFactory(this.ciphers, this.protocols, this.clientAuth, this.rmiBindAddress);
            } else if (this.rmiBindAddress != null) {
                registrySsf = new RmiServerBindSocketFactory(this.rmiBindAddress);
            }
            if (this.rmiServerSSL) {
                serverCsf = new SslRMIClientSocketFactory();
                serverSsf = this.rmiBindAddress == null ? new SslRMIServerSocketFactory(this.ciphers, this.protocols, this.clientAuth) : new SslRmiServerBindSocketFactory(this.ciphers, this.protocols, this.clientAuth, this.rmiBindAddress);
            } else if (this.rmiBindAddress != null) {
                serverSsf = new RmiServerBindSocketFactory(this.rmiBindAddress);
            }
            if (this.rmiBindAddress != null) {
                System.setProperty("java.rmi.server.hostname", this.rmiBindAddress);
            }
            if (this.useLocalPorts) {
                registryCsf = new RmiClientLocalhostSocketFactory(registryCsf);
                serverCsf = new RmiClientLocalhostSocketFactory(serverCsf);
            }
            env.put("jmx.remote.rmi.server.credential.types", new String[]{String[].class.getName(), String.class.getName()});
            if (serverCsf != null) {
                env.put("jmx.remote.rmi.client.socket.factory", serverCsf);
                env.put("com.sun.jndi.rmi.factory.socket", registryCsf);
            }
            if (serverSsf != null) {
                env.put("jmx.remote.rmi.server.socket.factory", serverSsf);
            }
            if (this.authenticate) {
                env.put("jmx.remote.x.password.file", this.passwordFile);
                env.put("jmx.remote.x.access.file", this.accessFile);
                env.put("jmx.remote.x.login.config", this.loginModuleName);
            }
            this.csPlatform = this.createServer("Platform", this.rmiBindAddress, this.rmiRegistryPortPlatform, this.rmiServerPortPlatform, env, registryCsf, registrySsf, serverCsf, serverSsf);
        } else if ("stop".equals(event.getType())) {
            this.destroyServer("Platform", this.csPlatform);
        }
    }

    private JMXConnectorServer createServer(String serverName, String bindAddress, int theRmiRegistryPort, int theRmiServerPort, HashMap<String, Object> theEnv, RMIClientSocketFactory registryCsf, RMIServerSocketFactory registrySsf, RMIClientSocketFactory serverCsf, RMIServerSocketFactory serverSsf) {
        JMXServiceURL serviceUrl;
        if (bindAddress == null) {
            bindAddress = "localhost";
        }
        String url = "service:jmx:rmi://" + bindAddress;
        try {
            serviceUrl = new JMXServiceURL(url);
        }
        catch (MalformedURLException e) {
            log.error((Object)sm.getString("jmxRemoteLifecycleListener.invalidURL", new Object[]{serverName, url}), (Throwable)e);
            return null;
        }
        RMIConnectorServer cs = null;
        try {
            RMIJRMPServerImpl server = new RMIJRMPServerImpl(this.rmiServerPortPlatform, serverCsf, serverSsf, theEnv);
            cs = new RMIConnectorServer(serviceUrl, theEnv, server, ManagementFactory.getPlatformMBeanServer());
            cs.start();
            Remote jmxServer = server.toStub();
            try {
                JmxRegistry unused = new JmxRegistry(theRmiRegistryPort, registryCsf, registrySsf, "jmxrmi", jmxServer);
            }
            catch (RemoteException e) {
                log.error((Object)sm.getString("jmxRemoteLifecycleListener.createRegistryFailed", new Object[]{serverName, Integer.toString(theRmiRegistryPort)}), (Throwable)e);
                return null;
            }
            log.info((Object)sm.getString("jmxRemoteLifecycleListener.start", new Object[]{Integer.toString(theRmiRegistryPort), Integer.toString(theRmiServerPort), serverName}));
        }
        catch (IOException e) {
            log.error((Object)sm.getString("jmxRemoteLifecycleListener.createServerFailed", new Object[]{serverName}), (Throwable)e);
        }
        return cs;
    }

    private void destroyServer(String serverName, JMXConnectorServer theConnectorServer) {
        if (theConnectorServer != null) {
            try {
                theConnectorServer.stop();
            }
            catch (IOException e) {
                log.error((Object)sm.getString("jmxRemoteLifecycleListener.destroyServerFailed", new Object[]{serverName}), (Throwable)e);
            }
        }
    }

    private static class JmxRegistry
    extends RegistryImpl {
        private static final long serialVersionUID = -3772054804656428217L;
        private final String jmxName;
        private final Remote jmxServer;

        public JmxRegistry(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, String jmxName, Remote jmxServer) throws RemoteException {
            super(port, csf, ssf);
            this.jmxName = jmxName;
            this.jmxServer = jmxServer;
        }

        @Override
        public Remote lookup(String name) throws RemoteException, NotBoundException {
            return this.jmxName.equals(name) ? this.jmxServer : null;
        }

        @Override
        public void bind(String name, Remote obj) throws RemoteException, AlreadyBoundException, AccessException {
        }

        @Override
        public void unbind(String name) throws RemoteException, NotBoundException, AccessException {
        }

        @Override
        public void rebind(String name, Remote obj) throws RemoteException, AccessException {
        }

        @Override
        public String[] list() throws RemoteException {
            return new String[]{this.jmxName};
        }
    }

    public static class SslRmiServerBindSocketFactory
    extends SslRMIServerSocketFactory {
        private static final SSLServerSocketFactory sslServerSocketFactory;
        private static final String[] defaultProtocols;
        private final InetAddress bindAddress;

        public SslRmiServerBindSocketFactory(String[] enabledCipherSuites, String[] enabledProtocols, boolean needClientAuth, String address) {
            super(enabledCipherSuites, enabledProtocols, needClientAuth);
            InetAddress bindAddress = null;
            try {
                bindAddress = InetAddress.getByName(address);
            }
            catch (UnknownHostException e) {
                log.error((Object)sm.getString("jmxRemoteLifecycleListener.invalidRmiBindAddress", new Object[]{address}), (Throwable)e);
            }
            this.bindAddress = bindAddress;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            SSLServerSocket sslServerSocket = (SSLServerSocket)sslServerSocketFactory.createServerSocket(port, 0, this.bindAddress);
            if (this.getEnabledCipherSuites() != null) {
                sslServerSocket.setEnabledCipherSuites(this.getEnabledCipherSuites());
            }
            if (this.getEnabledProtocols() == null) {
                sslServerSocket.setEnabledProtocols(defaultProtocols);
            } else {
                sslServerSocket.setEnabledProtocols(this.getEnabledProtocols());
            }
            sslServerSocket.setNeedClientAuth(this.getNeedClientAuth());
            return sslServerSocket;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.bindAddress == null ? 0 : this.bindAddress.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SslRmiServerBindSocketFactory other = (SslRmiServerBindSocketFactory)obj;
            return !(this.bindAddress == null ? other.bindAddress != null : !this.bindAddress.equals(other.bindAddress));
        }

        static {
            SSLContext sslContext;
            try {
                sslContext = SSLContext.getDefault();
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
            sslServerSocketFactory = sslContext.getServerSocketFactory();
            String[] protocols = sslContext.getDefaultSSLParameters().getProtocols();
            ArrayList<String> filteredProtocols = new ArrayList<String>(protocols.length);
            for (String protocol : protocols) {
                if (protocol.toUpperCase(Locale.ENGLISH).contains("SSL")) continue;
                filteredProtocols.add(protocol);
            }
            defaultProtocols = filteredProtocols.toArray(new String[filteredProtocols.size()]);
        }
    }

    public static class RmiServerBindSocketFactory
    implements RMIServerSocketFactory {
        private final InetAddress bindAddress;

        public RmiServerBindSocketFactory(String address) {
            InetAddress bindAddress = null;
            try {
                bindAddress = InetAddress.getByName(address);
            }
            catch (UnknownHostException e) {
                log.error((Object)sm.getString("jmxRemoteLifecycleListener.invalidRmiBindAddress", new Object[]{address}), (Throwable)e);
            }
            this.bindAddress = bindAddress;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            return new ServerSocket(port, 0, this.bindAddress);
        }
    }

    public static class RmiClientLocalhostSocketFactory
    implements RMIClientSocketFactory,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final String FORCED_HOST = "localhost";
        private final RMIClientSocketFactory factory;

        public RmiClientLocalhostSocketFactory(RMIClientSocketFactory theFactory) {
            this.factory = theFactory;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            if (this.factory == null) {
                return new Socket(FORCED_HOST, port);
            }
            return this.factory.createSocket(FORCED_HOST, port);
        }
    }
}

