/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.PageTool;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrParamResourceLoader;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.SolrVelocityLogger;
import org.apache.solr.response.SolrVelocityResourceLoader;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.tools.ConversionUtils;
import org.apache.velocity.tools.generic.ComparisonDateTool;
import org.apache.velocity.tools.generic.DisplayTool;
import org.apache.velocity.tools.generic.EscapeTool;
import org.apache.velocity.tools.generic.ListTool;
import org.apache.velocity.tools.generic.MathTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.apache.velocity.tools.generic.ResourceTool;
import org.apache.velocity.tools.generic.SortTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityResponseWriter
implements QueryResponseWriter,
SolrCoreAware {
    public static final String TEMPLATE_BASE_DIR = "template.base.dir";
    public static final String PARAMS_RESOURCE_LOADER_ENABLED = "params.resource.loader.enabled";
    public static final String SOLR_RESOURCE_LOADER_ENABLED = "solr.resource.loader.enabled";
    public static final String PROPERTIES_FILE = "init.properties.file";
    public static final String TEMPLATE = "v.template";
    public static final String LAYOUT = "v.layout";
    public static final String LAYOUT_ENABLED = "v.layout.enabled";
    public static final String CONTENT_TYPE = "v.contentType";
    public static final String JSON = "v.json";
    public static final String LOCALE = "v.locale";
    public static final String TEMPLATE_EXTENSION = ".vm";
    public static final String DEFAULT_CONTENT_TYPE = "text/html;charset=UTF-8";
    public static final String JSON_CONTENT_TYPE = "application/json;charset=UTF-8";
    private File fileResourceLoaderBaseDir;
    private boolean paramsResourceLoaderEnabled;
    private boolean solrResourceLoaderEnabled;
    private String initPropertiesFileName;
    private static final Logger log = LoggerFactory.getLogger(VelocityResponseWriter.class);
    private static final SolrVelocityLogger velocityLogger = new SolrVelocityLogger(log);
    private Properties velocityInitProps = new Properties();

    public void init(NamedList args) {
        Boolean prle;
        this.fileResourceLoaderBaseDir = null;
        String templateBaseDir = (String)args.get(TEMPLATE_BASE_DIR);
        if (templateBaseDir != null && !templateBaseDir.isEmpty()) {
            this.fileResourceLoaderBaseDir = new File(templateBaseDir).getAbsoluteFile();
            if (!this.fileResourceLoaderBaseDir.exists()) {
                log.warn("template.base.dir specified does not exist: " + this.fileResourceLoaderBaseDir);
                this.fileResourceLoaderBaseDir = null;
            } else if (!this.fileResourceLoaderBaseDir.isDirectory()) {
                log.warn("template.base.dir specified is not a directory: " + this.fileResourceLoaderBaseDir);
                this.fileResourceLoaderBaseDir = null;
            }
        }
        this.paramsResourceLoaderEnabled = null == (prle = args.getBooleanArg(PARAMS_RESOURCE_LOADER_ENABLED)) ? false : prle;
        Boolean srle = args.getBooleanArg(SOLR_RESOURCE_LOADER_ENABLED);
        this.solrResourceLoaderEnabled = null == srle ? true : srle;
        this.initPropertiesFileName = (String)args.get(PROPERTIES_FILE);
    }

    public void inform(SolrCore core) {
        if (this.initPropertiesFileName != null) {
            Object is = null;
            try {
                this.velocityInitProps.load(new InputStreamReader(core.getResourceLoader().openResource(this.initPropertiesFileName), StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                log.warn("Error loading init.properties.file specified property file: " + this.initPropertiesFileName, (Throwable)e);
            }
        }
    }

    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        String contentType = request.getParams().get(CONTENT_TYPE);
        return contentType != null ? contentType : (request.getParams().get(JSON) == null ? DEFAULT_CONTENT_TYPE : JSON_CONTENT_TYPE);
    }

    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        boolean wrapResponse;
        VelocityEngine engine = this.createEngine(request);
        Template template = this.getTemplate(engine, request);
        VelocityContext context = this.createContext(request, response);
        context.put("engine", (Object)engine);
        String layoutTemplate = request.getParams().get(LAYOUT);
        boolean layoutEnabled = request.getParams().getBool(LAYOUT_ENABLED, true) && layoutTemplate != null;
        String jsonWrapper = request.getParams().get(JSON);
        boolean bl = wrapResponse = layoutEnabled || jsonWrapper != null;
        if (!wrapResponse) {
            template.merge((Context)context, writer);
        } else {
            StringWriter stringWriter = new StringWriter();
            template.merge((Context)context, (Writer)stringWriter);
            if (layoutEnabled) {
                context.put("content", (Object)stringWriter.toString());
                stringWriter = new StringWriter();
                try {
                    engine.getTemplate(layoutTemplate + TEMPLATE_EXTENSION).merge((Context)context, (Writer)stringWriter);
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            }
            if (jsonWrapper != null) {
                writer.write(jsonWrapper + "(");
                writer.write(this.getJSONWrap(stringWriter.toString()));
                writer.write(41);
            } else {
                writer.write(stringWriter.toString());
            }
        }
    }

    private VelocityContext createContext(SolrQueryRequest request, SolrQueryResponse response) {
        VelocityContext context = new VelocityContext();
        context.put("request", (Object)request);
        context.put("esc", (Object)new EscapeTool());
        context.put("date", (Object)new ComparisonDateTool());
        context.put("list", (Object)new ListTool());
        context.put("math", (Object)new MathTool());
        context.put("number", (Object)new NumberTool());
        context.put("sort", (Object)new SortTool());
        context.put("display", (Object)new DisplayTool());
        context.put("resource", (Object)new SolrVelocityResourceTool(request.getCore().getSolrConfig().getResourceLoader().getClassLoader(), request.getParams().get(LOCALE)));
        QueryResponse rsp = new QueryResponse();
        NamedList parsedResponse = BinaryResponseWriter.getParsedResponse((SolrQueryRequest)request, (SolrQueryResponse)response);
        try {
            rsp.setResponse(parsedResponse);
            context.put("page", (Object)new PageTool(request, response));
            context.put("debug", (Object)rsp.getDebugMap());
        }
        catch (ClassCastException e) {
            rsp = new SolrResponseBase();
            rsp.setResponse(parsedResponse);
        }
        context.put("response", (Object)rsp);
        return context;
    }

    private VelocityEngine createEngine(SolrQueryRequest request) {
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("runtime.log.logsystem", (Object)velocityLogger);
        engine.setProperty("velocimacro.library", (Object)"_macros.vm,VM_global_library.vm,macros.vm");
        engine.setProperty("velocimacro.library.autoreload", (Object)"true");
        ArrayList<String> loaders = new ArrayList<String>();
        if (this.paramsResourceLoaderEnabled) {
            loaders.add("params");
            engine.setProperty("params.resource.loader.instance", (Object)new SolrParamResourceLoader(request));
        }
        if (this.fileResourceLoaderBaseDir != null) {
            loaders.add("file");
            engine.setProperty("file.resource.loader.path", (Object)this.fileResourceLoaderBaseDir.getAbsolutePath());
        }
        if (this.solrResourceLoaderEnabled) {
            loaders.add("solr");
            engine.setProperty("solr.resource.loader.instance", (Object)new SolrVelocityResourceLoader(request.getCore().getSolrConfig().getResourceLoader()));
        }
        loaders.add("builtin");
        engine.setProperty("builtin.resource.loader.instance", (Object)new ClasspathResourceLoader());
        engine.setProperty("resource.loader", (Object)StringUtils.join(loaders, (char)','));
        engine.init(this.velocityInitProps);
        return engine;
    }

    private Template getTemplate(VelocityEngine engine, SolrQueryRequest request) throws IOException {
        Template template;
        String templateName = request.getParams().get(TEMPLATE);
        String qt = request.getParams().get("qt");
        String path = (String)request.getContext().get("path");
        if (templateName == null && path != null) {
            templateName = path;
        }
        if (templateName == null && qt != null) {
            templateName = qt;
        }
        if (templateName == null) {
            templateName = "index";
        }
        try {
            template = engine.getTemplate(templateName + TEMPLATE_EXTENSION);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return template;
    }

    private String getJSONWrap(String xmlResult) {
        String replace1 = xmlResult.replaceAll("\\\\", "\\\\\\\\");
        replace1 = replace1.replaceAll("\\n", "\\\\n");
        replace1 = replace1.replaceAll("\\r", "\\\\r");
        String replaced = replace1.replaceAll("\"", "\\\\\"");
        return "{\"result\":\"" + replaced + "\"}";
    }

    private class SolrVelocityResourceTool
    extends ResourceTool {
        private ClassLoader solrClassLoader;

        public SolrVelocityResourceTool(ClassLoader cl, String localeString) {
            this.solrClassLoader = cl;
            Locale l = this.toLocale(localeString);
            this.setLocale(l == null ? Locale.ROOT : l);
        }

        protected ResourceBundle getBundle(String baseName, Object loc) {
            return ResourceBundle.getBundle("velocity." + baseName, this.getLocale(), this.solrClassLoader);
        }

        private Locale toLocale(Object obj) {
            if (obj == null) {
                return null;
            }
            if (obj instanceof Locale) {
                return (Locale)obj;
            }
            String s = String.valueOf(obj);
            return ConversionUtils.toLocale((String)s);
        }
    }
}

