/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.scraper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.prometheus.client.Collector;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.prometheus.exporter.SolrExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrScraper
implements Callable<Map<String, Collector.MetricFamilySamples>> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private SolrClient solrClient;
    private LinkedHashMap conf;
    private List<String> labelNames;
    private List<String> labelValues;

    public SolrScraper(SolrClient solrClient, LinkedHashMap conf) {
        this.solrClient = solrClient;
        this.conf = conf;
        this.labelNames = new ArrayList<String>();
        this.labelValues = new ArrayList<String>();
    }

    @Override
    public Map<String, Collector.MetricFamilySamples> call() throws Exception {
        return this.collectResponse(this.solrClient, this.conf);
    }

    public Map<String, Collector.MetricFamilySamples> collectResponse(SolrClient solrClient, LinkedHashMap conf) {
        LinkedHashMap<String, Collector.MetricFamilySamples> metricFamilySamplesMap = new LinkedHashMap<String, Collector.MetricFamilySamples>();
        try {
            LinkedHashMap confQuery = (LinkedHashMap)conf.get("query");
            LinkedHashMap confParams = (LinkedHashMap)confQuery.get("params");
            String path = (String)confQuery.get("path");
            String core = (String)confQuery.get("core");
            String collection = (String)confQuery.get("collection");
            ArrayList jsonQueries = (ArrayList)conf.get("jsonQueries");
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (confParams != null) {
                for (Object k : confParams.keySet()) {
                    String name = (String)k;
                    String value = (String)confParams.get(k);
                    params.add(name, new String[]{value});
                }
            }
            QueryRequest queryRequest = new QueryRequest((SolrParams)params);
            queryRequest.setPath(path);
            NamedList queryResponse = null;
            try {
                if (core == null && collection == null) {
                    queryResponse = solrClient.request((SolrRequest)queryRequest);
                } else if (core != null) {
                    queryResponse = solrClient.request((SolrRequest)queryRequest, core);
                } else if (collection != null) {
                    queryResponse = solrClient.request((SolrRequest)queryRequest, collection);
                }
            }
            catch (IOException | SolrServerException e) {
                logger.error("failed to request: " + queryRequest.getPath() + " " + e.getMessage());
            }
            ObjectMapper om = new ObjectMapper();
            JsonNode metricsJson = om.readTree((String)queryResponse.get("response"));
            ArrayList<JsonQuery> jqs = new ArrayList<JsonQuery>();
            if (jsonQueries != null) {
                for (String jsonQuery : jsonQueries) {
                    JsonQuery compiledJsonQuery = JsonQuery.compile((String)jsonQuery);
                    jqs.add(compiledJsonQuery);
                }
            }
            for (int i = 0; i < jqs.size(); ++i) {
                JsonQuery q = (JsonQuery)jqs.get(i);
                try {
                    List results = q.apply(metricsJson);
                    for (JsonNode result : results) {
                        Collector.MetricFamilySamples.Sample sample;
                        String type = result.get("type").textValue();
                        String name = result.get("name").textValue();
                        String help = result.get("help").textValue();
                        Double value = result.get("value").doubleValue();
                        ArrayList<String> labelNames = new ArrayList<String>(this.labelNames);
                        ArrayList<String> labelValues = new ArrayList<String>(this.labelValues);
                        if (solrClient instanceof CloudSolrClient) {
                            labelNames.add("zk_host");
                            labelValues.add(((CloudSolrClient)solrClient).getZkHost());
                        }
                        if (collection != null) {
                            labelNames.add("collection");
                            labelValues.add(collection);
                        }
                        if (solrClient instanceof HttpSolrClient) {
                            labelNames.add("base_url");
                            labelValues.add(((HttpSolrClient)solrClient).getBaseURL());
                        }
                        if (core != null) {
                            labelNames.add("core");
                            labelValues.add(core);
                        }
                        for (JsonNode item : result.get("label_names")) {
                            labelNames.add(item.textValue());
                        }
                        for (JsonNode item : result.get("label_values")) {
                            labelValues.add(item.textValue());
                        }
                        if (labelNames.indexOf("core") < 0 && labelNames.indexOf("collection") >= 0 && labelNames.indexOf("shard") >= 0 && labelNames.indexOf("replica") >= 0) {
                            StringBuffer sb = new StringBuffer();
                            sb.append(labelValues.get(labelNames.indexOf("collection"))).append("_").append(labelValues.get(labelNames.indexOf("shard"))).append("_").append(labelValues.get(labelNames.indexOf("replica")));
                            labelNames.add("core");
                            labelValues.add(sb.toString());
                        }
                        if (!metricFamilySamplesMap.containsKey(name)) {
                            Collector.MetricFamilySamples metricFamilySamples = new Collector.MetricFamilySamples(name, Collector.Type.valueOf((String)type), help, new ArrayList());
                            metricFamilySamplesMap.put(name, metricFamilySamples);
                        }
                        if (((Collector.MetricFamilySamples)metricFamilySamplesMap.get((Object)name)).samples.contains(sample = new Collector.MetricFamilySamples.Sample(name, labelNames, labelValues, value.doubleValue()))) continue;
                        ((Collector.MetricFamilySamples)metricFamilySamplesMap.get((Object)name)).samples.add(sample);
                    }
                    continue;
                }
                catch (JsonQueryException e) {
                    logger.error(e.toString() + " " + q.toString());
                    SolrExporter.scrapeErrorTotal.inc();
                }
            }
        }
        catch (IOException | HttpSolrClient.RemoteSolrException e) {
            logger.error("failed to request: " + e.toString());
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
        }
        return metricFamilySamplesMap;
    }
}

