/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.collector;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.prometheus.client.Collector;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.NoOpResponseParser;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.Config;
import org.apache.solr.prometheus.scraper.SolrScraper;
import org.apache.solr.util.DOMUtil;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class SolrCollector
extends Collector
implements Collector.Describable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private SolrClient solrClient;
    private Config config;
    private int numThreads;
    private ExecutorService executorService;
    private static ObjectMapper om = new ObjectMapper();

    public SolrCollector(SolrClient solrClient, Config config, int numThreads) {
        this.solrClient = solrClient;
        this.config = config;
        this.numThreads = numThreads;
    }

    public List<Collector.MetricFamilySamples> describe() {
        ArrayList<Collector.MetricFamilySamples> metricFamilies = new ArrayList<Collector.MetricFamilySamples>();
        metricFamilies.add(new Collector.MetricFamilySamples("solr_exporter_duration_seconds", Collector.Type.GAUGE, "Time this Solr scrape took, in seconds.", new ArrayList()));
        return metricFamilies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Collector.MetricFamilySamples> collect() {
        long startTime = System.nanoTime();
        this.executorService = ExecutorUtil.newMDCAwareFixedThreadPool((int)this.numThreads, (ThreadFactory)new DefaultSolrThreadFactory("solr-exporter"));
        LinkedHashMap<String, Collector.MetricFamilySamples> metricFamilySamplesMap = new LinkedHashMap<String, Collector.MetricFamilySamples>();
        ArrayList<Future<Map<String, Object>>> futureList = new ArrayList<Future<Map<String, Object>>>();
        try {
            Node searchNode;
            Node collectionsNode;
            Future<Map<String, Collector.MetricFamilySamples>> future;
            SolrScraper scraper;
            LinkedHashMap conf;
            block64: {
                List requestsNL;
                block68: {
                    Object metricsNode;
                    block65: {
                        List requestsNL2;
                        block66: {
                            Node pingNode = this.config.getNode("/config/rules/ping", true);
                            if (pingNode == null) break block65;
                            NamedList pingNL = DOMUtil.childNodesToNamedList((Node)pingNode);
                            requestsNL2 = pingNL.getAll("request");
                            if (!(this.solrClient instanceof CloudSolrClient)) break block66;
                            List<HttpSolrClient> httpSolrClients = new ArrayList();
                            try {
                                httpSolrClients = this.getHttpSolrClients((CloudSolrClient)this.solrClient);
                                for (HttpSolrClient httpSolrClient : httpSolrClients) {
                                    for (NamedList requestNL : requestsNL2) {
                                        String coreName = (String)((NamedList)requestNL.get("query")).get("core");
                                        String collectionName = (String)((NamedList)requestNL.get("query")).get("collection");
                                        if (coreName == null && collectionName == null) {
                                            try {
                                                List<String> cores = SolrCollector.getCores(httpSolrClient);
                                                for (String core : cores) {
                                                    LinkedHashMap conf4 = (LinkedHashMap)requestNL.asMap(10);
                                                    LinkedHashMap query = (LinkedHashMap)conf4.get("query");
                                                    if (query != null) {
                                                        query.put("core", core);
                                                    }
                                                    SolrScraper scraper4 = new SolrScraper((SolrClient)httpSolrClient, conf4);
                                                    Future<Map<String, Collector.MetricFamilySamples>> future4 = this.executorService.submit(scraper4);
                                                    futureList.add(future4);
                                                }
                                                continue;
                                            }
                                            catch (IOException | SolrServerException e) {
                                                logger.error("failed to get cores: " + e.getMessage());
                                                continue;
                                            }
                                        }
                                        if (coreName == null || collectionName != null) continue;
                                        LinkedHashMap conf5 = (LinkedHashMap)requestNL.asMap(10);
                                        SolrScraper scraper2 = new SolrScraper((SolrClient)httpSolrClient, conf5);
                                        Future<Map<String, Collector.MetricFamilySamples>> future2 = this.executorService.submit(scraper2);
                                        futureList.add(future2);
                                    }
                                }
                                for (Future future3 : futureList) {
                                    try {
                                        Map map = (Map)future3.get(60L, TimeUnit.SECONDS);
                                        this.mergeMetrics(metricFamilySamplesMap, map);
                                    }
                                    catch (InterruptedException | ExecutionException | TimeoutException exception) {
                                        logger.error(exception.getMessage());
                                    }
                                }
                            }
                            catch (IOException | SolrServerException e) {
                                try {
                                    logger.error("failed to get HttpSolrClients: " + e.getMessage());
                                }
                                catch (Throwable throwable) {
                                    for (HttpSolrClient httpSolrClient : httpSolrClients) {
                                        try {
                                            httpSolrClient.close();
                                        }
                                        catch (IOException e2) {
                                            logger.error("failed to close HttpSolrClient: " + e2.getMessage());
                                        }
                                    }
                                    throw throwable;
                                }
                                for (HttpSolrClient httpSolrClient : httpSolrClients) {
                                    try {
                                        httpSolrClient.close();
                                    }
                                    catch (IOException iOException) {
                                        logger.error("failed to close HttpSolrClient: " + iOException.getMessage());
                                    }
                                }
                            }
                            for (HttpSolrClient httpSolrClient : httpSolrClients) {
                                try {
                                    httpSolrClient.close();
                                }
                                catch (IOException iOException) {
                                    logger.error("failed to close HttpSolrClient: " + iOException.getMessage());
                                }
                            }
                            for (NamedList namedList : requestsNL2) {
                                String string = (String)((NamedList)namedList.get("query")).get("core");
                                String collectionName = (String)((NamedList)namedList.get("query")).get("collection");
                                if (string == null && collectionName == null) {
                                    try {
                                        List<String> collections = SolrCollector.getCollections((CloudSolrClient)this.solrClient);
                                        for (String collection : collections) {
                                            LinkedHashMap conf6 = (LinkedHashMap)namedList.asMap(10);
                                            LinkedHashMap query = (LinkedHashMap)conf6.get("query");
                                            if (query != null) {
                                                query.put("collection", collection);
                                            }
                                            SolrScraper scraper5 = new SolrScraper(this.solrClient, conf6);
                                            Future<Map<String, Collector.MetricFamilySamples>> future6 = this.executorService.submit(scraper5);
                                            futureList.add(future6);
                                        }
                                        continue;
                                    }
                                    catch (IOException | SolrServerException e) {
                                        logger.error("failed to get cores: " + e.getMessage());
                                        continue;
                                    }
                                }
                                if (string != null || collectionName == null) continue;
                                conf = (LinkedHashMap)namedList.asMap(10);
                                scraper = new SolrScraper(this.solrClient, conf);
                                future = this.executorService.submit(scraper);
                                futureList.add(future);
                            }
                            break block65;
                        }
                        for (NamedList requestNL : requestsNL2) {
                            String string = (String)((NamedList)requestNL.get("query")).get("core");
                            if (string == null) {
                                try {
                                    List<String> list = SolrCollector.getCores((HttpSolrClient)this.solrClient);
                                    for (String core : list) {
                                        LinkedHashMap conf3 = (LinkedHashMap)requestNL.asMap(10);
                                        LinkedHashMap query = (LinkedHashMap)conf3.get("query");
                                        if (query != null) {
                                            query.put("core", core);
                                        }
                                        SolrScraper scraper3 = new SolrScraper(this.solrClient, conf3);
                                        Future<Map<String, Collector.MetricFamilySamples>> future3 = this.executorService.submit(scraper3);
                                        futureList.add(future3);
                                    }
                                    continue;
                                }
                                catch (IOException | SolrServerException throwable) {
                                    logger.error("failed to get cores: " + throwable.getMessage());
                                    continue;
                                }
                            }
                            LinkedHashMap linkedHashMap = (LinkedHashMap)requestNL.asMap(10);
                            SolrScraper scraper3 = new SolrScraper(this.solrClient, linkedHashMap);
                            Future future4 = this.executorService.submit(scraper3);
                            futureList.add(future4);
                        }
                    }
                    if ((metricsNode = this.config.getNode("/config/rules/metrics", false)) == null) break block64;
                    NamedList metricsNL = DOMUtil.childNodesToNamedList((Node)metricsNode);
                    requestsNL = metricsNL.getAll("request");
                    if (!(this.solrClient instanceof CloudSolrClient)) break block68;
                    List<HttpSolrClient> httpSolrClients = new ArrayList();
                    try {
                        httpSolrClients = this.getHttpSolrClients((CloudSolrClient)this.solrClient);
                        for (HttpSolrClient httpSolrClient : httpSolrClients) {
                            for (NamedList requestNL : requestsNL) {
                                LinkedHashMap conf2 = (LinkedHashMap)requestNL.asMap(10);
                                SolrScraper scraper6 = new SolrScraper((SolrClient)httpSolrClient, conf2);
                                Future<Map<String, Collector.MetricFamilySamples>> future7 = this.executorService.submit(scraper6);
                                futureList.add(future7);
                            }
                        }
                        for (Future future5 : futureList) {
                            try {
                                Map m2 = (Map)future5.get(60L, TimeUnit.SECONDS);
                                this.mergeMetrics(metricFamilySamplesMap, m2);
                            }
                            catch (InterruptedException | ExecutionException | TimeoutException e) {
                                logger.error(e.getMessage());
                            }
                        }
                    }
                    catch (IOException | SolrServerException throwable) {
                        try {
                            logger.error(throwable.getMessage());
                        }
                        catch (Throwable throwable2) {
                            for (HttpSolrClient httpSolrClient : httpSolrClients) {
                                try {
                                    httpSolrClient.close();
                                }
                                catch (IOException e4) {
                                    logger.error(e4.getMessage());
                                }
                            }
                            throw throwable2;
                        }
                        for (HttpSolrClient httpSolrClient : httpSolrClients) {
                            try {
                                httpSolrClient.close();
                            }
                            catch (IOException e5) {
                                logger.error(e5.getMessage());
                            }
                        }
                        break block64;
                    }
                    for (HttpSolrClient httpSolrClient : httpSolrClients) {
                        try {
                            httpSolrClient.close();
                        }
                        catch (IOException e) {
                            logger.error(e.getMessage());
                        }
                    }
                    break block64;
                }
                for (NamedList namedList : requestsNL) {
                    LinkedHashMap linkedHashMap = (LinkedHashMap)namedList.asMap(10);
                    SolrScraper scraper2 = new SolrScraper(this.solrClient, linkedHashMap);
                    Future<Map<String, Collector.MetricFamilySamples>> future2 = this.executorService.submit(scraper2);
                    futureList.add(future2);
                }
            }
            if ((collectionsNode = this.config.getNode("/config/rules/collections", false)) != null && this.solrClient instanceof CloudSolrClient) {
                NamedList collectionsNL = DOMUtil.childNodesToNamedList((Node)collectionsNode);
                List requestsNL = collectionsNL.getAll("request");
                for (NamedList namedList : requestsNL) {
                    LinkedHashMap conf7 = (LinkedHashMap)namedList.asMap(10);
                    SolrScraper scraper7 = new SolrScraper(this.solrClient, conf7);
                    Future<Map<String, Collector.MetricFamilySamples>> future9 = this.executorService.submit(scraper7);
                    futureList.add(future9);
                }
            }
            if ((searchNode = this.config.getNode("/config/rules/search", false)) != null) {
                NamedList searchNL = DOMUtil.childNodesToNamedList((Node)searchNode);
                List list = searchNL.getAll("request");
                for (NamedList requestNL : list) {
                    conf = (LinkedHashMap)requestNL.asMap(10);
                    scraper = new SolrScraper(this.solrClient, conf);
                    future = this.executorService.submit(scraper);
                    futureList.add(future);
                }
            }
            for (Future future6 : futureList) {
                try {
                    Map map = (Map)future6.get(60L, TimeUnit.SECONDS);
                    this.mergeMetrics(metricFamilySamplesMap, map);
                }
                catch (InterruptedException | ExecutionException | TimeoutException exception) {
                    logger.error(exception.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        ArrayList<Collector.MetricFamilySamples> metricFamiliesSamplesList = new ArrayList<Collector.MetricFamilySamples>();
        for (String gaugeMetricName : metricFamilySamplesMap.keySet()) {
            Collector.MetricFamilySamples metricFamilySamples = (Collector.MetricFamilySamples)metricFamilySamplesMap.get(gaugeMetricName);
            if (metricFamilySamples.samples.size() <= 0) continue;
            metricFamiliesSamplesList.add(metricFamilySamples);
        }
        ArrayList<Collector.MetricFamilySamples.Sample> durationSample = new ArrayList<Collector.MetricFamilySamples.Sample>();
        durationSample.add(new Collector.MetricFamilySamples.Sample("solr_exporter_duration_seconds", new ArrayList(), new ArrayList(), (double)(System.nanoTime() - startTime) / 1.0E9));
        metricFamiliesSamplesList.add(new Collector.MetricFamilySamples("solr_exporter_duration_seconds", Collector.Type.GAUGE, "Time this Solr exporter took, in seconds.", durationSample));
        this.executorService.shutdown();
        return metricFamiliesSamplesList;
    }

    private Map<String, Collector.MetricFamilySamples> mergeMetrics(Map<String, Collector.MetricFamilySamples> metrics1, Map<String, Collector.MetricFamilySamples> metrics2) {
        for (String k : metrics2.keySet()) {
            if (metrics1.containsKey(k)) {
                for (Collector.MetricFamilySamples.Sample sample : metrics2.get((Object)k).samples) {
                    if (metrics1.get((Object)k).samples.contains(sample)) continue;
                    metrics1.get((Object)k).samples.add(sample);
                }
                continue;
            }
            metrics1.put(k, metrics2.get(k));
        }
        return metrics1;
    }

    public static List<String> getCores(HttpSolrClient httpSolrClient) throws SolrServerException, IOException {
        ArrayList<String> cores = new ArrayList<String>();
        NoOpResponseParser responseParser = new NoOpResponseParser();
        responseParser.setWriterType("json");
        httpSolrClient.setParser((ResponseParser)responseParser);
        CoreAdminRequest coreAdminRequest = new CoreAdminRequest();
        coreAdminRequest.setAction(CoreAdminParams.CoreAdminAction.STATUS);
        coreAdminRequest.setIndexInfoNeeded(false);
        NamedList coreAdminResponse = httpSolrClient.request((SolrRequest)coreAdminRequest);
        JsonNode statusJsonNode = om.readTree((String)coreAdminResponse.get("response")).get("status");
        Iterator i = statusJsonNode.iterator();
        while (i.hasNext()) {
            String core = ((JsonNode)i.next()).get("name").textValue();
            if (cores.contains(core)) continue;
            cores.add(core);
        }
        return cores;
    }

    public static List<String> getCollections(CloudSolrClient cloudSolrClient) throws SolrServerException, IOException {
        ArrayList<String> collections = new ArrayList<String>();
        NoOpResponseParser responseParser = new NoOpResponseParser();
        responseParser.setWriterType("json");
        cloudSolrClient.setParser((ResponseParser)responseParser);
        CollectionAdminRequest.List collectionAdminRequest = new CollectionAdminRequest.List();
        NamedList collectionAdminResponse = cloudSolrClient.request((SolrRequest)collectionAdminRequest);
        JsonNode collectionsJsonNode = om.readTree((String)collectionAdminResponse.get("response")).get("collections");
        Iterator i = collectionsJsonNode.iterator();
        while (i.hasNext()) {
            String collection = ((JsonNode)i.next()).textValue();
            if (collections.contains(collection)) continue;
            collections.add(collection);
        }
        return collections;
    }

    private List<String> getBaseUrls(CloudSolrClient cloudSolrClient) throws SolrServerException, IOException {
        ArrayList<String> baseUrls = new ArrayList<String>();
        NoOpResponseParser responseParser = new NoOpResponseParser();
        responseParser.setWriterType("json");
        cloudSolrClient.setParser((ResponseParser)responseParser);
        CollectionAdminRequest.ClusterStatus collectionAdminRequest = new CollectionAdminRequest.ClusterStatus();
        NamedList collectionAdminResponse = cloudSolrClient.request((SolrRequest)collectionAdminRequest);
        List baseUrlJsonNode = om.readTree((String)collectionAdminResponse.get("response")).findValues("base_url");
        Iterator i = baseUrlJsonNode.iterator();
        while (i.hasNext()) {
            String baseUrl = ((JsonNode)i.next()).textValue();
            if (baseUrls.contains(baseUrl)) continue;
            baseUrls.add(baseUrl);
        }
        return baseUrls;
    }

    private List<HttpSolrClient> getHttpSolrClients(CloudSolrClient cloudSolrClient) throws SolrServerException, IOException {
        ArrayList<HttpSolrClient> solrClients = new ArrayList<HttpSolrClient>();
        for (String baseUrl : this.getBaseUrls(cloudSolrClient)) {
            NoOpResponseParser responseParser = new NoOpResponseParser();
            responseParser.setWriterType("json");
            HttpSolrClient.Builder builder = new HttpSolrClient.Builder();
            builder.withBaseSolrUrl(baseUrl);
            HttpSolrClient httpSolrClient = builder.build();
            httpSolrClient.setParser((ResponseParser)responseParser);
            solrClients.add(httpSolrClient);
        }
        return solrClients;
    }
}

